/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.postingsformat;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.TermsConsumer;
import org.apache.lucene.codecs.lucene41.Lucene41PostingsFormat;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.postingsformat.BloomFilter;
import org.elasticsearch.index.codec.postingsformat.BloomFilterPostingsFormat;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;

public final class ElasticSearch090PostingsFormat
extends PostingsFormat {
    private final BloomFilterPostingsFormat bloomPostings = new BloomFilterPostingsFormat((PostingsFormat)new Lucene41PostingsFormat(), BloomFilter.Factory.DEFAULT);

    public ElasticSearch090PostingsFormat() {
        super("es090");
    }

    public PostingsFormat getDefaultWrapped() {
        return this.bloomPostings.getDelegate();
    }

    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        final BloomFilterPostingsFormat.BloomFilteredFieldsConsumer fieldsConsumer = this.bloomPostings.fieldsConsumer(state);
        return new FieldsConsumer(){

            public void close() throws IOException {
                fieldsConsumer.close();
            }

            public TermsConsumer addField(FieldInfo field) throws IOException {
                if (UidFieldMapper.NAME.equals(field.name)) {
                    return fieldsConsumer.addField(field);
                }
                return fieldsConsumer.getDelegate().addField(field);
            }
        };
    }

    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        return this.bloomPostings.fieldsProducer(state);
    }
}

