/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine.robin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.SegmentInfoPerCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.routing.operation.hash.djb.DjbHashFunction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.CreateFailedEngineException;
import org.elasticsearch.index.engine.DeleteByQueryFailedEngineException;
import org.elasticsearch.index.engine.DeleteFailedEngineException;
import org.elasticsearch.index.engine.DocumentAlreadyExistsException;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineAlreadyStartedException;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineCreationFailureException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.FlushFailedEngineException;
import org.elasticsearch.index.engine.FlushNotAllowedEngineException;
import org.elasticsearch.index.engine.IndexFailedEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RecoveryEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.engine.Segment;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.search.nested.IncludeNestedDocsQuery;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.indices.warmer.InternalIndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public class RobinEngine
extends AbstractIndexShardComponent
implements Engine {
    private volatile ByteSizeValue indexingBufferSize;
    private volatile int termIndexInterval;
    private volatile int termIndexDivisor;
    private volatile int indexConcurrency;
    private long gcDeletesInMillis;
    private volatile boolean enableGcDeletes = true;
    private volatile String codecName;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    private final IndexSettingsService indexSettingsService;
    @Nullable
    private final InternalIndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final AnalysisService analysisService;
    private final SimilarityService similarityService;
    private final CodecService codecService;
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();
    private volatile IndexWriter indexWriter;
    private final SearcherFactory searcherFactory = new RobinSearchFactory();
    private volatile SearcherManager searcherManager;
    private volatile boolean closed = false;
    private volatile boolean dirty = false;
    private volatile boolean possibleMergeNeeded = false;
    private final AtomicBoolean optimizeMutex = new AtomicBoolean();
    private volatile boolean flushNeeded = false;
    private final AtomicInteger flushing = new AtomicInteger();
    private final Lock flushLock = new ReentrantLock();
    private volatile int onGoingRecoveries = 0;
    private final ConcurrentMap<HashedBytesRef, VersionValue> versionMap;
    private final Object[] dirtyLocks;
    private final Object refreshMutex = new Object();
    private final ApplySettings applySettings = new ApplySettings();
    private volatile boolean failOnMergeFailure;
    private Throwable failedEngine = null;
    private final Object failedEngineMutex = new Object();
    private final CopyOnWriteArrayList<Engine.FailedEngineListener> failedEngineListeners = new CopyOnWriteArrayList();
    private final AtomicLong translogIdGenerator = new AtomicLong();
    private SegmentInfos lastCommittedSegmentInfos;
    public static final String INDEX_TERM_INDEX_INTERVAL = "index.term_index_interval";
    public static final String INDEX_TERM_INDEX_DIVISOR = "index.term_index_divisor";
    public static final String INDEX_INDEX_CONCURRENCY = "index.index_concurrency";
    public static final String INDEX_GC_DELETES = "index.gc_deletes";
    public static final String INDEX_CODEC = "index.codec";
    public static final String INDEX_FAIL_ON_MERGE_FAILURE = "index.fail_on_merge_failure";

    @Inject
    public RobinEngine(ShardId shardId, @IndexSettings Settings indexSettings, ThreadPool threadPool, IndexSettingsService indexSettingsService, ShardIndexingService indexingService, @Nullable IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, AnalysisService analysisService, SimilarityService similarityService, CodecService codecService) throws EngineException {
        super(shardId, indexSettings);
        Preconditions.checkNotNull(store, "Store must be provided to the engine");
        Preconditions.checkNotNull(deletionPolicy, "Snapshot deletion policy must be provided to the engine");
        Preconditions.checkNotNull(translog, "Translog must be provided to the engine");
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES, TimeValue.timeValueSeconds(60L)).millis();
        this.indexingBufferSize = this.componentSettings.getAsBytesSize("index_buffer_size", new ByteSizeValue(64L, ByteSizeUnit.MB));
        this.termIndexInterval = indexSettings.getAsInt(INDEX_TERM_INDEX_INTERVAL, (Integer)32);
        this.termIndexDivisor = indexSettings.getAsInt(INDEX_TERM_INDEX_DIVISOR, (Integer)1);
        this.codecName = indexSettings.get(INDEX_CODEC, "default");
        this.threadPool = threadPool;
        this.indexSettingsService = indexSettingsService;
        this.indexingService = indexingService;
        this.warmer = (InternalIndicesWarmer)warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analysisService = analysisService;
        this.similarityService = similarityService;
        this.codecService = codecService;
        this.indexConcurrency = indexSettings.getAsInt(INDEX_INDEX_CONCURRENCY, (Integer)8);
        this.versionMap = ConcurrentCollections.newConcurrentMapWithAggressiveConcurrency();
        this.dirtyLocks = new Object[this.indexConcurrency * 50];
        for (int i = 0; i < this.dirtyLocks.length; ++i) {
            this.dirtyLocks[i] = new Object();
        }
        this.indexSettingsService.addListener(this.applySettings);
        this.failOnMergeFailure = indexSettings.getAsBoolean(INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)true);
        if (this.failOnMergeFailure) {
            this.mergeScheduler.addFailureListener(new FailEngineOnMergeFailure());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        ByteSizeValue preValue = this.indexingBufferSize;
        this.rwl.readLock().lock();
        try {
            this.indexingBufferSize = indexingBufferSize;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter != null) {
                indexWriter.getConfig().setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (preValue.bytes() != indexingBufferSize.bytes()) {
            if (indexingBufferSize == Engine.INACTIVE_SHARD_INDEXING_BUFFER && preValue != Engine.INACTIVE_SHARD_INDEXING_BUFFER) {
                this.logger.debug("updating index_buffer_size from [{}] to (inactive) [{}]", preValue, indexingBufferSize);
                try {
                    this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
                catch (EngineClosedException e) {
                }
                catch (FlushNotAllowedEngineException e) {
                }
                catch (Exception e) {
                    this.logger.warn("failed to flush after setting shard to inactive", e, new Object[0]);
                }
            } else {
                this.logger.debug("updating index_buffer_size from [{}] to [{}]", preValue, indexingBufferSize);
            }
        }
    }

    @Override
    public void addFailedEngineListener(Engine.FailedEngineListener listener) {
        this.failedEngineListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws EngineException {
        this.rwl.writeLock().lock();
        try {
            if (this.indexWriter != null) {
                throw new EngineAlreadyStartedException(this.shardId);
            }
            if (this.closed) {
                throw new EngineClosedException(this.shardId);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("starting engine", new Object[0]);
            }
            try {
                this.indexWriter = this.createWriter();
            }
            catch (IOException e) {
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", (Throwable)e);
            }
            try {
                if (Lucene.indexExists(this.store.directory())) {
                    Map commitUserData = Lucene.readSegmentInfos(this.store.directory()).getUserData();
                    if (commitUserData.containsKey("translog_id")) {
                        this.translogIdGenerator.set(Long.parseLong((String)commitUserData.get("translog_id")));
                    } else {
                        this.translogIdGenerator.set(System.currentTimeMillis());
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                        this.indexWriter.commit();
                    }
                } else {
                    this.translogIdGenerator.set(System.currentTimeMillis());
                    this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(this.translogIdGenerator.get())).map());
                    this.indexWriter.commit();
                }
                this.translog.newTranslog(this.translogIdGenerator.get());
                this.searcherManager = this.buildSearchManager(this.indexWriter);
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.store.directory());
                this.lastCommittedSegmentInfos = infos;
            }
            catch (IOException e) {
                try {
                    this.indexWriter.rollback();
                }
                catch (IOException e1) {
                }
                finally {
                    try {
                        this.indexWriter.close();
                    }
                    catch (IOException e1) {}
                }
                throw new EngineCreationFailureException(this.shardId, "failed to open reader on writer", (Throwable)e);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    @Override
    public TimeValue defaultRefreshInterval() {
        return new TimeValue(1L, TimeUnit.SECONDS);
    }

    @Override
    public void enableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Engine.GetResult get(Engine.Get get) throws EngineException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 2[TRYBLOCK]], but top level block is 11[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void create(Engine.Create create) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerCreate(create, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new CreateFailedEngineException(this.shardId, create, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerCreate(Engine.Create create, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(create.uid());
        synchronized (object) {
            long updatedVersion;
            UidField uidField = create.uidField();
            HashedBytesRef versionKey = this.versionKey(create.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(create.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (create.origin() == Engine.Operation.Origin.PRIMARY) {
                if (create.versionType() == VersionType.INTERNAL) {
                    long expectedVersion = create.version();
                    if (expectedVersion != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), -1L, expectedVersion);
                        }
                        if (expectedVersion != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion >= 0L && currentVersion >= create.version()) {
                        throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, create.version());
                    }
                    updatedVersion = create.version();
                }
            } else {
                long expectedVersion = create.version();
                if (currentVersion != -2L && (currentVersion != -1L || create.version() != 1L) && expectedVersion <= currentVersion) {
                    if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, create.type(), create.id(), currentVersion, expectedVersion);
                }
                updatedVersion = create.version();
            }
            if (versionValue != null) {
                if (!versionValue.delete()) {
                    if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
                }
            } else if (currentVersion != -1L) {
                if (create.origin() == Engine.Operation.Origin.RECOVERY) {
                    return;
                }
                throw new DocumentAlreadyExistsException(this.shardId, create.type(), create.id());
            }
            uidField.version(updatedVersion);
            create.version(updatedVersion);
            if (create.docs().size() > 1) {
                writer.addDocuments(create.docs(), create.analyzer());
            } else {
                writer.addDocument((Iterable)create.docs().get(0), create.analyzer());
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Create(create));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postCreateUnderLock(create);
        }
    }

    @Override
    public void index(Engine.Index index) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerIndex(index, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new IndexFailedEngineException(this.shardId, index, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerIndex(Engine.Index index, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(index.uid());
        synchronized (object) {
            long updatedVersion;
            UidField uidField = index.uidField();
            HashedBytesRef versionKey = this.versionKey(index.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(index.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (index.origin() == Engine.Operation.Origin.PRIMARY) {
                if (index.versionType() == VersionType.INTERNAL) {
                    long expectedVersion = index.version();
                    if (expectedVersion != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), -1L, expectedVersion);
                        }
                        if (expectedVersion != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion >= 0L && currentVersion >= index.version()) {
                        throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, index.version());
                    }
                    updatedVersion = index.version();
                }
            } else {
                long expectedVersion = index.version();
                if (currentVersion != -2L && (currentVersion != -1L || index.version() != 1L) && expectedVersion <= currentVersion) {
                    if (index.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, index.type(), index.id(), currentVersion, expectedVersion);
                }
                updatedVersion = index.version();
            }
            uidField.version(updatedVersion);
            index.version(updatedVersion);
            if (currentVersion == -1L) {
                if (index.docs().size() > 1) {
                    writer.addDocuments(index.docs(), index.analyzer());
                } else {
                    writer.addDocument((Iterable)index.docs().get(0), index.analyzer());
                }
            } else if (index.docs().size() > 1) {
                writer.updateDocuments(index.uid(), index.docs(), index.analyzer());
            } else {
                writer.updateDocument(index.uid(), (Iterable)index.docs().get(0), index.analyzer());
            }
            Translog.Location translogLocation = this.translog.add(new Translog.Index(index));
            this.versionMap.put(versionKey, new VersionValue(updatedVersion, false, this.threadPool.estimatedTimeInMillis(), translogLocation));
            this.indexingService.postIndexUnderLock(index);
        }
    }

    @Override
    public void delete(Engine.Delete delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.innerDelete(delete, writer);
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new DeleteFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDelete(Engine.Delete delete, IndexWriter writer) throws IOException {
        Object object = this.dirtyLock(delete.uid());
        synchronized (object) {
            long updatedVersion;
            HashedBytesRef versionKey = this.versionKey(delete.uid());
            VersionValue versionValue = (VersionValue)this.versionMap.get(versionKey);
            long currentVersion = versionValue == null ? this.loadCurrentVersionFromIndex(delete.uid()) : (this.enableGcDeletes && versionValue.delete() && this.threadPool.estimatedTimeInMillis() - versionValue.time() > this.gcDeletesInMillis ? -1L : versionValue.version());
            if (delete.origin() == Engine.Operation.Origin.PRIMARY) {
                if (delete.versionType() == VersionType.INTERNAL) {
                    if (delete.version() != 0L && currentVersion != -2L) {
                        if (currentVersion == -1L) {
                            throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), -1L, delete.version());
                        }
                        if (delete.version() != currentVersion) {
                            throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, delete.version());
                        }
                    }
                    updatedVersion = currentVersion < 0L ? 1L : currentVersion + 1L;
                } else {
                    if (currentVersion != -1L && currentVersion >= delete.version()) {
                        throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion, delete.version());
                    }
                    updatedVersion = delete.version();
                }
            } else {
                if (currentVersion != -2L && currentVersion != -1L && delete.version() <= currentVersion) {
                    if (delete.origin() == Engine.Operation.Origin.RECOVERY) {
                        return;
                    }
                    throw new VersionConflictEngineException(this.shardId, delete.type(), delete.id(), currentVersion - 1L, delete.version());
                }
                updatedVersion = delete.version();
            }
            if (currentVersion == -1L) {
                delete.version(updatedVersion).notFound(true);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else if (versionValue != null && versionValue.delete()) {
                delete.version(updatedVersion).notFound(true);
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            } else {
                delete.version(updatedVersion);
                writer.deleteDocuments(delete.uid());
                Translog.Location translogLocation = this.translog.add(new Translog.Delete(delete));
                this.versionMap.put(versionKey, new VersionValue(updatedVersion, true, this.threadPool.estimatedTimeInMillis(), translogLocation));
            }
            this.indexingService.postDeleteUnderLock(delete);
        }
    }

    @Override
    public void delete(Engine.DeleteByQuery delete) throws EngineException {
        this.rwl.readLock().lock();
        try {
            IndexWriter writer = this.indexWriter;
            if (writer == null) {
                throw new EngineClosedException(this.shardId);
            }
            Query query = delete.nested() && delete.aliasFilter() != null ? new IncludeNestedDocsQuery((Query)new XFilteredQuery(delete.query(), delete.aliasFilter()), delete.parentFilter()) : (delete.nested() ? new IncludeNestedDocsQuery(delete.query(), delete.parentFilter()) : (delete.aliasFilter() != null ? new XFilteredQuery(delete.query(), delete.aliasFilter()) : delete.query()));
            writer.deleteDocuments(query);
            this.translog.add(new Translog.DeleteByQuery(delete));
            this.dirty = true;
            this.possibleMergeNeeded = true;
            this.flushNeeded = true;
        }
        catch (IOException e) {
            throw new DeleteByQueryFailedEngineException(this.shardId, delete, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.refreshVersioningTable(System.currentTimeMillis());
    }

    @Override
    public Engine.Searcher searcher() throws EngineException {
        SearcherManager manager = this.searcherManager;
        try {
            IndexSearcher searcher = (IndexSearcher)manager.acquire();
            return new RobinSearcher(searcher, manager);
        }
        catch (IOException ex) {
            this.logger.error("failed to accquire searcher for shard [{}]", ex, this.shardId);
            throw new EngineException(this.shardId, ex.getMessage());
        }
    }

    @Override
    public boolean refreshNeeded() {
        return this.dirty;
    }

    @Override
    public boolean possibleMergeNeeded() {
        return this.possibleMergeNeeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(Engine.Refresh refresh) throws EngineException {
        block17: {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId);
            }
            this.rwl.readLock().lock();
            try {
                IndexWriter currentWriter = this.indexWriter;
                if (currentWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                try {
                    Object object = this.refreshMutex;
                    synchronized (object) {
                        if (this.dirty || refresh.force()) {
                            this.dirty = false;
                            this.searcherManager.maybeRefresh();
                        }
                    }
                }
                catch (AlreadyClosedException e) {
                }
                catch (OutOfMemoryError e) {
                    this.failEngine(e);
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("OutOfMemoryError")) {
                        this.failEngine(e);
                    }
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
                catch (Exception e) {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    if (currentWriter != this.indexWriter) {
                        break block17;
                    }
                    throw new RefreshFailedEngineException(this.shardId, (Throwable)e);
                }
            }
            finally {
                this.rwl.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void flush(Engine.Flush flush) throws EngineException {
        if (this.indexWriter == null) {
            throw new EngineClosedException(this.shardId, this.failedEngine);
        }
        if ((flush.type() == Engine.Flush.Type.NEW_WRITER || flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) && this.onGoingRecoveries > 0) {
            throw new FlushNotAllowedEngineException(this.shardId, "recovery is in progress, flush [" + (Object)((Object)flush.type()) + "] is not allowed");
        }
        int currentFlushing = this.flushing.incrementAndGet();
        if (currentFlushing > 1 && !flush.waitIfOngoing()) {
            this.flushing.decrementAndGet();
            throw new FlushNotAllowedEngineException(this.shardId, "already flushing...");
        }
        this.flushLock.lock();
        try {
            block37: {
                if (flush.type() == Engine.Flush.Type.NEW_WRITER) {
                    this.rwl.writeLock().lock();
                    try {
                        if (this.indexWriter == null) {
                            throw new EngineClosedException(this.shardId, this.failedEngine);
                        }
                        if (this.onGoingRecoveries > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        this.dirty = false;
                        try {
                            this.indexWriter.close(false);
                            this.indexWriter = this.createWriter();
                            if (this.flushNeeded || flush.force()) {
                                this.flushNeeded = false;
                                long translogId = this.translogIdGenerator.incrementAndGet();
                                this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                                this.indexWriter.commit();
                                this.translog.newTranslog(translogId);
                            }
                            SearcherManager current = this.searcherManager;
                            this.searcherManager = this.buildSearchManager(this.indexWriter);
                            current.close();
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            break block37;
                        }
                        catch (OutOfMemoryError e) {
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Exception e) {
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                    }
                    finally {
                        this.rwl.writeLock().unlock();
                    }
                }
                if (flush.type() == Engine.Flush.Type.COMMIT_TRANSLOG) {
                    this.rwl.readLock().lock();
                    try {
                        if (this.indexWriter == null) {
                            throw new EngineClosedException(this.shardId, this.failedEngine);
                        }
                        if (this.onGoingRecoveries > 0) {
                            throw new FlushNotAllowedEngineException(this.shardId, "Recovery is in progress, flush is not allowed");
                        }
                        if (!this.flushNeeded && !flush.force()) break block37;
                        this.flushNeeded = false;
                        try {
                            long translogId = this.translogIdGenerator.incrementAndGet();
                            this.translog.newTransientTranslog(translogId);
                            this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                            this.indexWriter.commit();
                            this.refreshVersioningTable(this.threadPool.estimatedTimeInMillis());
                            this.translog.makeTransientCurrent();
                            break block37;
                        }
                        catch (OutOfMemoryError e) {
                            this.translog.revertTransient();
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (IllegalStateException e) {
                            if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                            this.failEngine(e);
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                        catch (Exception e) {
                            this.translog.revertTransient();
                            throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        }
                    }
                    finally {
                        this.rwl.readLock().unlock();
                    }
                }
                if (flush.type() != Engine.Flush.Type.COMMIT) throw new ElasticSearchIllegalStateException("flush type [" + (Object)((Object)flush.type()) + "] not supported");
                this.rwl.readLock().lock();
                try {
                    if (this.indexWriter == null) {
                        throw new EngineClosedException(this.shardId, this.failedEngine);
                    }
                    try {
                        long translogId = this.translog.currentId();
                        this.indexWriter.setCommitData(MapBuilder.newMapBuilder().put("translog_id", Long.toString(translogId)).map());
                        this.indexWriter.commit();
                    }
                    catch (OutOfMemoryError e) {
                        this.translog.revertTransient();
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (!e.getMessage().contains("OutOfMemoryError")) throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                        this.failEngine(e);
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new FlushFailedEngineException(this.shardId, (Throwable)e);
                    }
                }
                finally {
                    this.rwl.readLock().unlock();
                }
            }
            try {
                SegmentInfos infos = new SegmentInfos();
                infos.read(this.store.directory());
                this.lastCommittedSegmentInfos = infos;
                return;
            }
            catch (Exception e) {
                if (this.closed) return;
                this.logger.warn("failed to read latest segment infos on flush", e, new Object[0]);
                return;
            }
        }
        finally {
            this.flushLock.unlock();
            this.flushing.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningTable(long time) {
        this.refresh(new Engine.Refresh(true).force(true));
        for (Map.Entry entry : this.versionMap.entrySet()) {
            HashedBytesRef uid = (HashedBytesRef)entry.getKey();
            Object object = this.dirtyLock(uid.bytes);
            synchronized (object) {
                VersionValue versionValue = (VersionValue)this.versionMap.get(uid);
                if (versionValue == null) {
                    continue;
                }
                if (time - versionValue.time() <= 0L) {
                    continue;
                }
                if (versionValue.delete()) {
                    if (this.enableGcDeletes && time - versionValue.time() > this.gcDeletesInMillis) {
                        this.versionMap.remove(uid);
                    }
                } else {
                    this.versionMap.remove(uid);
                }
            }
        }
    }

    @Override
    public void maybeMerge() throws EngineException {
        if (!this.possibleMergeNeeded) {
            return;
        }
        this.possibleMergeNeeded = false;
        this.rwl.readLock().lock();
        try {
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            this.indexWriter.maybeMerge();
        }
        catch (OutOfMemoryError e) {
            this.failEngine(e);
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (IllegalStateException e) {
            if (e.getMessage().contains("OutOfMemoryError")) {
                this.failEngine(e);
            }
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        catch (Exception e) {
            throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws EngineException {
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true));
        }
        if (this.optimizeMutex.compareAndSet(false, true)) {
            this.rwl.readLock().lock();
            try {
                if (this.indexWriter == null) {
                    throw new EngineClosedException(this.shardId, this.failedEngine);
                }
                if (optimize.onlyExpungeDeletes()) {
                    this.indexWriter.forceMergeDeletes(false);
                } else if (optimize.maxNumSegments() <= 0) {
                    this.indexWriter.maybeMerge();
                    this.possibleMergeNeeded = false;
                } else {
                    this.indexWriter.forceMerge(optimize.maxNumSegments(), false);
                }
            }
            catch (OutOfMemoryError e) {
                this.failEngine(e);
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (IllegalStateException e) {
                if (e.getMessage().contains("OutOfMemoryError")) {
                    this.failEngine(e);
                }
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            catch (Exception e) {
                throw new OptimizeFailedEngineException(this.shardId, (Throwable)e);
            }
            finally {
                this.rwl.readLock().unlock();
                this.optimizeMutex.set(false);
            }
        }
        if (optimize.waitForMerge()) {
            this.indexWriter.waitForMerges();
        }
        if (optimize.flush()) {
            this.flush(new Engine.Flush().force(true));
        }
        if (optimize.refresh()) {
            this.refresh(new Engine.Refresh(false).force(true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        SnapshotIndexCommit snapshotIndexCommit = null;
        Translog.Snapshot traslogSnapshot = null;
        this.rwl.readLock().lock();
        try {
            snapshotIndexCommit = this.deletionPolicy.snapshot();
            traslogSnapshot = this.translog.snapshot();
        }
        catch (Exception e) {
            if (snapshotIndexCommit != null) {
                snapshotIndexCommit.release();
            }
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        try {
            T t = snapshotHandler.snapshot(snapshotIndexCommit, traslogSnapshot);
            return t;
        }
        finally {
            snapshotIndexCommit.release();
            traslogSnapshot.release();
        }
    }

    @Override
    public SnapshotIndexCommit snapshotIndex() throws EngineException {
        this.rwl.readLock().lock();
        try {
            this.flush(new Engine.Flush().type(Engine.Flush.Type.COMMIT).waitIfOngoing(true));
            if (this.indexWriter == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            SnapshotIndexCommit snapshotIndexCommit = this.deletionPolicy.snapshot();
            return snapshotIndexCommit;
        }
        catch (IOException e) {
            throw new SnapshotFailedEngineException(this.shardId, (Throwable)e);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        Translog.Snapshot phase2Snapshot;
        SnapshotIndexCommit phase1Snapshot;
        this.rwl.writeLock().lock();
        try {
            ++this.onGoingRecoveries;
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        try {
            phase1Snapshot = this.deletionPolicy.snapshot();
        }
        catch (Exception e) {
            --this.onGoingRecoveries;
            throw new RecoveryEngineException(this.shardId, 1, "Snapshot failed", (Throwable)e);
        }
        try {
            recoveryHandler.phase1(phase1Snapshot);
        }
        catch (Exception e2) {
            EngineClosedException e2;
            --this.onGoingRecoveries;
            phase1Snapshot.release();
            if (this.closed) {
                e2 = new EngineClosedException(this.shardId, (Throwable)e2);
            }
            throw new RecoveryEngineException(this.shardId, 1, "Execution failed", (Throwable)e2);
        }
        try {
            phase2Snapshot = this.translog.snapshot();
        }
        catch (Exception e3) {
            EngineClosedException e3;
            --this.onGoingRecoveries;
            phase1Snapshot.release();
            if (this.closed) {
                e3 = new EngineClosedException(this.shardId, (Throwable)e3);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Snapshot failed", (Throwable)e3);
        }
        try {
            recoveryHandler.phase2(phase2Snapshot);
        }
        catch (Exception e4) {
            EngineClosedException e4;
            --this.onGoingRecoveries;
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (this.closed) {
                e4 = new EngineClosedException(this.shardId, (Throwable)e4);
            }
            throw new RecoveryEngineException(this.shardId, 2, "Execution failed", (Throwable)e4);
        }
        this.rwl.writeLock().lock();
        Translog.Snapshot phase3Snapshot = null;
        try {
            phase3Snapshot = this.translog.snapshot(phase2Snapshot);
            recoveryHandler.phase3(phase3Snapshot);
        }
        catch (Exception e) {
            throw new RecoveryEngineException(this.shardId, 3, "Execution failed", (Throwable)e);
        }
        finally {
            --this.onGoingRecoveries;
            this.rwl.writeLock().unlock();
            phase1Snapshot.release();
            phase2Snapshot.release();
            if (phase3Snapshot != null) {
                phase3Snapshot.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Segment> segments() {
        this.rwl.readLock().lock();
        try {
            Segment segment;
            IndexWriter indexWriter = this.indexWriter;
            if (indexWriter == null) {
                throw new EngineClosedException(this.shardId, this.failedEngine);
            }
            HashMap<String, Segment> segments = new HashMap<String, Segment>();
            Engine.Searcher searcher = this.searcher();
            try {
                for (AtomicReaderContext reader : searcher.reader().leaves()) {
                    assert (reader.reader() instanceof SegmentReader);
                    SegmentInfoPerCommit info = ((SegmentReader)reader.reader()).getSegmentInfo();
                    assert (!segments.containsKey(info.info.name));
                    segment = new Segment(info.info.name);
                    segment.search = true;
                    segment.docCount = reader.reader().numDocs();
                    segment.delDocCount = reader.reader().numDeletedDocs();
                    segment.version = info.info.getVersion();
                    segment.compound = info.info.getUseCompoundFile();
                    try {
                        segment.sizeInBytes = info.sizeInBytes();
                    }
                    catch (IOException e) {
                        this.logger.trace("failed to get size for [{}]", e, info.info.name);
                    }
                    segments.put(info.info.name, segment);
                }
            }
            finally {
                searcher.release();
            }
            if (this.lastCommittedSegmentInfos != null) {
                SegmentInfos infos = this.lastCommittedSegmentInfos;
                for (SegmentInfoPerCommit info : infos) {
                    segment = (Segment)segments.get(info.info.name);
                    if (segment == null) {
                        segment = new Segment(info.info.name);
                        segment.search = false;
                        segment.committed = true;
                        segment.docCount = info.info.getDocCount();
                        segment.delDocCount = info.getDelCount();
                        segment.version = info.info.getVersion();
                        segment.compound = info.info.getUseCompoundFile();
                        try {
                            segment.sizeInBytes = info.sizeInBytes();
                        }
                        catch (IOException e) {
                            this.logger.trace("failed to get size for [{}]", e, info.info.name);
                        }
                        segments.put(info.info.name, segment);
                        continue;
                    }
                    segment.committed = true;
                }
            }
            Segment[] segmentsArr = segments.values().toArray(new Segment[segments.values().size()]);
            Arrays.sort(segmentsArr, new Comparator<Segment>(){

                @Override
                public int compare(Segment o1, Segment o2) {
                    return (int)(o1.getGeneration() - o2.getGeneration());
                }
            });
            List<Segment> list = Arrays.asList(segmentsArr);
            return list;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticSearchException {
        this.rwl.writeLock().lock();
        try {
            this.innerClose();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failEngine(Throwable failure) {
        Object object = this.failedEngineMutex;
        synchronized (object) {
            if (this.failedEngine != null) {
                return;
            }
            this.logger.warn("failed engine", failure, new Object[0]);
            this.failedEngine = failure;
            for (Engine.FailedEngineListener listener : this.failedEngineListeners) {
                listener.onFailedEngine(this.shardId, failure);
            }
            this.innerClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerClose() {
        if (this.closed) {
            return;
        }
        this.indexSettingsService.removeListener(this.applySettings);
        this.closed = true;
        this.versionMap.clear();
        this.failedEngineListeners.clear();
        try {
            if (this.searcherManager != null) {
                this.searcherManager.close();
            }
            if (this.indexWriter != null) {
                try {
                    this.indexWriter.rollback();
                }
                catch (AlreadyClosedException e) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("failed to rollback writer on close", e, new Object[0]);
        }
        finally {
            this.indexWriter = null;
        }
    }

    private HashedBytesRef versionKey(Term uid) {
        return new HashedBytesRef(uid.bytes());
    }

    private Object dirtyLock(BytesRef uid) {
        int hash = DjbHashFunction.DJB_HASH(uid.bytes, uid.offset, uid.length);
        if (hash == Integer.MIN_VALUE) {
            hash = 0;
        }
        return this.dirtyLocks[Math.abs(hash) % this.dirtyLocks.length];
    }

    private Object dirtyLock(Term uid) {
        return this.dirtyLock(uid.bytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadCurrentVersionFromIndex(Term uid) {
        Engine.Searcher searcher = this.searcher();
        try {
            List readers = searcher.reader().leaves();
            for (int i = 0; i < readers.size(); ++i) {
                AtomicReaderContext readerContext = (AtomicReaderContext)readers.get(i);
                long version = UidField.loadVersion(readerContext, uid);
                if (version == -1L) continue;
                long l = version;
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            searcher.release();
        }
    }

    private IndexWriter createWriter() throws IOException {
        IndexWriter indexWriter = null;
        try {
            if (IndexWriter.isLocked((Directory)this.store.directory())) {
                this.logger.warn("shard is locked, releasing lock", new Object[0]);
                IndexWriter.unlock((Directory)this.store.directory());
            }
            boolean create = !Lucene.indexExists(this.store.directory());
            IndexWriterConfig config = new IndexWriterConfig(Lucene.VERSION, (Analyzer)this.analysisService.defaultIndexAnalyzer());
            config.setOpenMode(create ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.APPEND);
            config.setIndexDeletionPolicy((IndexDeletionPolicy)this.deletionPolicy);
            config.setMergeScheduler(this.mergeScheduler.newMergeScheduler());
            config.setMergePolicy(this.mergePolicyProvider.newMergePolicy());
            config.setSimilarity(this.similarityService.similarity());
            config.setRAMBufferSizeMB(this.indexingBufferSize.mbFrac());
            config.setTermIndexInterval(this.termIndexInterval);
            config.setReaderTermsIndexDivisor(this.termIndexDivisor);
            config.setMaxThreadStates(this.indexConcurrency);
            config.setCodec(this.codecService.codec(this.codecName));
            indexWriter = new IndexWriter(this.store.directory(), config);
        }
        catch (IOException e) {
            Lucene.safeClose(indexWriter);
            throw e;
        }
        return indexWriter;
    }

    private SearcherManager buildSearchManager(IndexWriter indexWriter) throws IOException {
        return new SearcherManager(indexWriter, true, this.searcherFactory);
    }

    class RobinSearchFactory
    extends SearcherFactory {
        RobinSearchFactory() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IndexSearcher newSearcher(IndexReader reader) throws IOException {
            IndexSearcher searcher = new IndexSearcher(reader);
            searcher.setSimilarity(RobinEngine.this.similarityService.similarity());
            if (RobinEngine.this.warmer != null) {
                Releasable currentSearcher = null;
                IndexSearcher newSearcher = null;
                boolean closeNewSearcher = false;
                try {
                    if (RobinEngine.this.searcherManager == null) {
                        newSearcher = searcher;
                    } else {
                        currentSearcher = RobinEngine.this.searcher();
                        ArrayList<AtomicReader> readers = Lists.newArrayList();
                        for (AtomicReaderContext newReaderContext : searcher.getIndexReader().leaves()) {
                            boolean found = false;
                            for (AtomicReaderContext currentReaderContext : currentSearcher.reader().leaves()) {
                                if (!currentReaderContext.reader().getCoreCacheKey().equals(newReaderContext.reader().getCoreCacheKey())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            readers.add(newReaderContext.reader());
                        }
                        if (!readers.isEmpty()) {
                            newSearcher = new IndexSearcher((IndexReader)new MultiReader(readers.toArray(new IndexReader[readers.size()]), false));
                            closeNewSearcher = true;
                        }
                    }
                    if (newSearcher != null) {
                        IndicesWarmer.WarmerContext context = new IndicesWarmer.WarmerContext(RobinEngine.this.shardId, new Engine.SimpleSearcher(searcher), new Engine.SimpleSearcher(newSearcher));
                        RobinEngine.this.warmer.warm(context);
                    }
                }
                catch (Exception e) {
                    if (!RobinEngine.this.closed) {
                        RobinEngine.this.logger.warn("failed to prepare/warm", e, new Object[0]);
                    }
                }
                finally {
                    if (currentSearcher != null) {
                        currentSearcher.release();
                    }
                    if (newSearcher != null && closeNewSearcher) {
                        try {
                            newSearcher.getIndexReader().close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            return searcher;
        }
    }

    static class VersionValue {
        private final long version;
        private final boolean delete;
        private final long time;
        private final Translog.Location translogLocation;

        VersionValue(long version, boolean delete, long time, Translog.Location translogLocation) {
            this.version = version;
            this.delete = delete;
            this.time = time;
            this.translogLocation = translogLocation;
        }

        public long time() {
            return this.time;
        }

        public long version() {
            return this.version;
        }

        public boolean delete() {
            return this.delete;
        }

        public Translog.Location translogLocation() {
            return this.translogLocation;
        }
    }

    static class RobinSearcher
    implements Engine.Searcher {
        private final IndexSearcher searcher;
        private final SearcherManager manager;

        private RobinSearcher(IndexSearcher searcher, SearcherManager manager) {
            this.searcher = searcher;
            this.manager = manager;
        }

        @Override
        public IndexReader reader() {
            return this.searcher.getIndexReader();
        }

        @Override
        public IndexSearcher searcher() {
            return this.searcher;
        }

        @Override
        public boolean release() throws ElasticSearchException {
            try {
                this.manager.release((Object)this.searcher);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    class ApplySettings
    implements IndexSettingsService.Listener {
        ApplySettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            long gcDeletesInMillis = RobinEngine.this.indexSettings.getAsTime(RobinEngine.INDEX_GC_DELETES, TimeValue.timeValueMillis(RobinEngine.this.gcDeletesInMillis)).millis();
            if (gcDeletesInMillis != RobinEngine.this.gcDeletesInMillis) {
                RobinEngine.this.logger.info("updating index.gc_deletes from [{}] to [{}]", TimeValue.timeValueMillis(RobinEngine.this.gcDeletesInMillis), TimeValue.timeValueMillis(gcDeletesInMillis));
                RobinEngine.this.gcDeletesInMillis = gcDeletesInMillis;
            }
            int termIndexInterval = settings.getAsInt(RobinEngine.INDEX_TERM_INDEX_INTERVAL, (Integer)RobinEngine.this.termIndexInterval);
            int termIndexDivisor = settings.getAsInt(RobinEngine.INDEX_TERM_INDEX_DIVISOR, (Integer)RobinEngine.this.termIndexDivisor);
            int indexConcurrency = settings.getAsInt(RobinEngine.INDEX_INDEX_CONCURRENCY, (Integer)RobinEngine.this.indexConcurrency);
            boolean failOnMergeFailure = settings.getAsBoolean(RobinEngine.INDEX_FAIL_ON_MERGE_FAILURE, (Boolean)RobinEngine.this.failOnMergeFailure);
            String codecName = settings.get(RobinEngine.INDEX_CODEC, RobinEngine.this.codecName);
            boolean requiresFlushing = false;
            if (termIndexInterval != RobinEngine.this.termIndexInterval || termIndexDivisor != RobinEngine.this.termIndexDivisor || indexConcurrency != RobinEngine.this.indexConcurrency || !codecName.equals(RobinEngine.this.codecName) || failOnMergeFailure != RobinEngine.this.failOnMergeFailure) {
                RobinEngine.this.rwl.readLock().lock();
                try {
                    if (termIndexInterval != RobinEngine.this.termIndexInterval) {
                        RobinEngine.this.logger.info("updating index.term_index_interval from [{}] to [{}]", RobinEngine.this.termIndexInterval, termIndexInterval);
                        RobinEngine.this.termIndexInterval = termIndexInterval;
                        RobinEngine.this.indexWriter.getConfig().setTermIndexInterval(termIndexInterval);
                    }
                    if (termIndexDivisor != RobinEngine.this.termIndexDivisor) {
                        RobinEngine.this.logger.info("updating index.term_index_divisor from [{}] to [{}]", RobinEngine.this.termIndexDivisor, termIndexDivisor);
                        RobinEngine.this.termIndexDivisor = termIndexDivisor;
                        RobinEngine.this.indexWriter.getConfig().setReaderTermsIndexDivisor(termIndexDivisor);
                        requiresFlushing = true;
                    }
                    if (indexConcurrency != RobinEngine.this.indexConcurrency) {
                        RobinEngine.this.logger.info("updating index.index_concurrency from [{}] to [{}]", RobinEngine.this.indexConcurrency, indexConcurrency);
                        RobinEngine.this.indexConcurrency = indexConcurrency;
                        requiresFlushing = true;
                    }
                    if (!codecName.equals(RobinEngine.this.codecName)) {
                        RobinEngine.this.logger.info("updating index.codec from [{}] to [{}]", RobinEngine.this.codecName, codecName);
                        RobinEngine.this.codecName = codecName;
                        requiresFlushing = true;
                    }
                    if (failOnMergeFailure != RobinEngine.this.failOnMergeFailure) {
                        RobinEngine.this.logger.info("updating {} from [{}] to [{}]", RobinEngine.INDEX_FAIL_ON_MERGE_FAILURE, RobinEngine.this.failOnMergeFailure, failOnMergeFailure);
                        RobinEngine.this.failOnMergeFailure = failOnMergeFailure;
                    }
                }
                finally {
                    RobinEngine.this.rwl.readLock().unlock();
                }
                if (requiresFlushing) {
                    RobinEngine.this.flush(new Engine.Flush().type(Engine.Flush.Type.NEW_WRITER));
                }
            }
        }
    }

    class FailEngineOnMergeFailure
    implements MergeSchedulerProvider.FailureListener {
        FailEngineOnMergeFailure() {
        }

        @Override
        public void onFailedMerge(MergePolicy.MergeException e) {
            RobinEngine.this.failEngine((Throwable)e);
        }
    }
}

