/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class DoubleValues {
    public static final DoubleValues EMPTY = new Empty();
    private final boolean multiValued;
    protected final Iter.Single iter = new Iter.Single();

    protected DoubleValues(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public final boolean isMultiValued() {
        return this.multiValued;
    }

    public abstract boolean hasValue(int var1);

    public abstract double getValue(int var1);

    public double getValueMissing(int docId, double missingValue) {
        if (this.hasValue(docId)) {
            return this.getValue(docId);
        }
        return missingValue;
    }

    public Iter getIter(int docId) {
        assert (!this.isMultiValued());
        if (this.hasValue(docId)) {
            return this.iter.reset(this.getValue(docId));
        }
        return Iter.Empty.INSTANCE;
    }

    public static class Filtered
    extends DoubleValues {
        protected final DoubleValues delegate;

        public Filtered(DoubleValues delegate) {
            super(delegate.isMultiValued());
            this.delegate = delegate;
        }

        @Override
        public boolean hasValue(int docId) {
            return this.delegate.hasValue(docId);
        }

        @Override
        public double getValue(int docId) {
            return this.delegate.getValue(docId);
        }

        @Override
        public Iter getIter(int docId) {
            return this.delegate.getIter(docId);
        }
    }

    static class Empty
    extends DoubleValues {
        public Empty() {
            super(false);
        }

        @Override
        public boolean hasValue(int docId) {
            return false;
        }

        @Override
        public double getValue(int docId) {
            throw new ElasticSearchIllegalStateException("Can't retrieve a value from an empty DoubleValues");
        }

        @Override
        public Iter getIter(int docId) {
            return Iter.Empty.INSTANCE;
        }
    }

    public static interface Iter {
        public boolean hasNext();

        public double next();

        public static class Multi
        implements Iter {
            private Ordinals.Docs.Iter ordsIter;
            private int ord;
            private WithOrdinals values;

            public Multi(WithOrdinals values) {
                this.values = values;
            }

            public Multi reset(Ordinals.Docs.Iter ordsIter) {
                this.ordsIter = ordsIter;
                this.ord = ordsIter.next();
                return this;
            }

            @Override
            public boolean hasNext() {
                return this.ord != 0;
            }

            @Override
            public double next() {
                double value = this.values.getValueByOrd(this.ord);
                this.ord = this.ordsIter.next();
                return value;
            }
        }

        public static class Single
        implements Iter {
            public double value;
            public boolean done;

            public Single reset(double value) {
                this.value = value;
                this.done = false;
                return this;
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public double next() {
                assert (!this.done);
                this.done = true;
                return this.value;
            }
        }

        public static class Empty
        implements Iter {
            public static final Empty INSTANCE = new Empty();

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public double next() {
                throw new ElasticSearchIllegalStateException();
            }
        }
    }

    public static abstract class WithOrdinals
    extends DoubleValues {
        protected final Ordinals.Docs ordinals;
        private final Iter.Multi iter;

        protected WithOrdinals(Ordinals.Docs ordinals) {
            super(ordinals.isMultiValued());
            this.ordinals = ordinals;
            this.iter = new Iter.Multi(this);
        }

        public Ordinals.Docs ordinals() {
            return this.ordinals;
        }

        @Override
        public final boolean hasValue(int docId) {
            return this.ordinals.getOrd(docId) != 0;
        }

        @Override
        public final double getValue(int docId) {
            return this.getValueByOrd(this.ordinals.getOrd(docId));
        }

        @Override
        public final double getValueMissing(int docId, double missingValue) {
            int ord = this.ordinals.getOrd(docId);
            if (ord == 0) {
                return missingValue;
            }
            return this.getValueByOrd(ord);
        }

        public abstract double getValueByOrd(int var1);

        @Override
        public final Iter getIter(int docId) {
            return this.iter.reset(this.ordinals.getIter(docId));
        }
    }

    public static abstract class Dense
    extends DoubleValues {
        protected Dense(boolean multiValued) {
            super(multiValued);
        }

        @Override
        public final boolean hasValue(int docId) {
            return true;
        }

        @Override
        public final double getValueMissing(int docId, double missingValue) {
            assert (this.hasValue(docId));
            assert (!this.isMultiValued());
            return this.getValue(docId);
        }

        @Override
        public final Iter getIter(int docId) {
            assert (this.hasValue(docId));
            assert (!this.isMultiValued());
            return this.iter.reset(this.getValue(docId));
        }
    }
}

