/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class FieldDataType {
    private final String type;
    private final Settings settings;

    public FieldDataType(String type) {
        this(type, ImmutableSettings.Builder.EMPTY_SETTINGS);
    }

    public FieldDataType(String type, Settings.Builder builder) {
        this(type, builder.build());
    }

    public FieldDataType(String type, Settings settings) {
        this.type = type;
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldDataType that = (FieldDataType)o;
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.settings.hashCode();
        return result;
    }
}

