/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.ByteValuesComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class ByteValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData<?> indexFieldData;
    private final Object missingValue;
    private final SortMode sortMode;

    public ByteValuesComparatorSource(IndexNumericFieldData<?> indexFieldData, @Nullable Object missingValue, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        byte dMissingValue = this.missingValue == null || "_last".equals(this.missingValue) ? (reversed ? (byte)-128 : 127) : ("_first".equals(this.missingValue) ? (reversed ? (byte)127 : -128) : (this.missingValue instanceof Number ? ((Number)this.missingValue).byteValue() : Byte.parseByte(this.missingValue.toString())));
        return new ByteValuesComparator(this.indexFieldData, dMissingValue, numHits, this.sortMode);
    }
}

