/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefOrdValComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefValComparator;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;

public class BytesRefFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexFieldData<?> indexFieldData;
    private final SortMode sortMode;

    public BytesRefFieldComparatorSource(IndexFieldData<?> indexFieldData, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.sortMode = sortMode;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.STRING;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        if (this.indexFieldData.valuesOrdered() && this.indexFieldData instanceof IndexFieldData.WithOrdinals) {
            return new BytesRefOrdValComparator((IndexFieldData.WithOrdinals)this.indexFieldData, numHits, this.sortMode);
        }
        return new BytesRefValComparator(this.indexFieldData, numHits, this.sortMode);
    }
}

