/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public final class BytesRefOrdValComparator
extends FieldComparator<BytesRef> {
    final IndexFieldData.WithOrdinals<?> indexFieldData;
    final int[] ords;
    final SortMode sortMode;
    final BytesRef[] values;
    final int[] readerGen;
    int currentReaderGen = -1;
    BytesValues.WithOrdinals termsIndex;
    int bottomSlot = -1;
    int bottomOrd;
    boolean bottomSameReader;
    BytesRef bottomValue;
    final BytesRef tempBR = new BytesRef();

    public BytesRefOrdValComparator(IndexFieldData.WithOrdinals<?> indexFieldData, int numHits, SortMode sortMode) {
        this.indexFieldData = indexFieldData;
        this.sortMode = sortMode;
        this.ords = new int[numHits];
        this.values = new BytesRef[numHits];
        this.readerGen = new int[numHits];
    }

    public int compare(int slot1, int slot2) {
        if (this.readerGen[slot1] == this.readerGen[slot2]) {
            return this.ords[slot1] - this.ords[slot2];
        }
        BytesRef val1 = this.values[slot1];
        BytesRef val2 = this.values[slot2];
        if (val1 == null) {
            if (val2 == null) {
                return 0;
            }
            return -1;
        }
        if (val2 == null) {
            return 1;
        }
        return val1.compareTo(val2);
    }

    public int compareBottom(int doc) {
        throw new UnsupportedOperationException();
    }

    public void copy(int slot, int doc) {
        throw new UnsupportedOperationException();
    }

    public int compareDocToValue(int doc, BytesRef value) {
        BytesRef docValue = this.termsIndex.getValue(doc);
        if (docValue == null) {
            if (value == null) {
                return 0;
            }
            return -1;
        }
        if (value == null) {
            return 1;
        }
        return docValue.compareTo(value);
    }

    public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
        int docBase = context.docBase;
        this.termsIndex = this.indexFieldData.load(context).getBytesValues();
        PerSegmentComparator perSegComp = null;
        if (this.termsIndex.isMultiValued()) {
            perSegComp = new MultiAnyOrdComparator(this.termsIndex);
        } else {
            Ordinals.Docs docToOrd = this.termsIndex.ordinals();
            Object ordsStorage = docToOrd.ordinals().getBackingStorage();
            if (docToOrd.ordinals().hasSingleArrayBackingStorage()) {
                if (ordsStorage instanceof byte[]) {
                    perSegComp = new ByteOrdComparator((byte[])ordsStorage, this.termsIndex, docBase);
                } else if (ordsStorage instanceof short[]) {
                    perSegComp = new ShortOrdComparator((short[])ordsStorage, this.termsIndex, docBase);
                } else if (ordsStorage instanceof int[]) {
                    perSegComp = new IntOrdComparator((int[])ordsStorage, this.termsIndex, docBase);
                }
            }
            if (perSegComp == null) {
                perSegComp = new AnyOrdComparator(this.indexFieldData, this.termsIndex, docBase);
            }
        }
        ++this.currentReaderGen;
        if (this.bottomSlot != -1) {
            perSegComp.setBottom(this.bottomSlot);
        }
        return perSegComp;
    }

    public void setBottom(int bottom) {
        this.bottomSlot = bottom;
        this.bottomValue = this.values[this.bottomSlot];
        if (this.currentReaderGen == this.readerGen[this.bottomSlot]) {
            this.bottomOrd = this.ords[this.bottomSlot];
            this.bottomSameReader = true;
        } else if (this.bottomValue == null) {
            assert (this.ords[this.bottomSlot] == 0);
            this.bottomOrd = 0;
            this.bottomSameReader = true;
            this.readerGen[this.bottomSlot] = this.currentReaderGen;
        } else {
            int index = BytesRefOrdValComparator.binarySearch(this.termsIndex, this.bottomValue);
            if (index < 0) {
                this.bottomOrd = -index - 2;
                this.bottomSameReader = false;
            } else {
                this.bottomOrd = index;
                this.bottomSameReader = true;
                this.readerGen[this.bottomSlot] = this.currentReaderGen;
                this.ords[this.bottomSlot] = this.bottomOrd;
            }
        }
    }

    public BytesRef value(int slot) {
        return this.values[slot];
    }

    protected static final int binarySearch(BytesValues.WithOrdinals a, BytesRef key) {
        return BytesRefOrdValComparator.binarySearch(a, key, 1, a.ordinals().getNumOrds());
    }

    protected static final int binarySearch(BytesValues.WithOrdinals a, BytesRef key, int low, int high) {
        assert (a.getValueByOrd(high) == null | a.getValueByOrd(high) != null);
        assert (a.getValueByOrd(low) == null | a.getValueByOrd(low) != null);
        while (low <= high) {
            int mid = low + high >>> 1;
            BytesRef midVal = a.getValueByOrd(mid);
            int cmp = midVal != null ? midVal.compareTo(key) : -1;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    static BytesRef getRelevantValue(BytesValues.WithOrdinals readerValues, int docId, SortMode sortMode) {
        BytesRef currentVal;
        BytesValues.Iter iter = readerValues.getIter(docId);
        if (!iter.hasNext()) {
            return null;
        }
        BytesRef relevantVal = currentVal = iter.next();
        while (true) {
            int cmp = currentVal.compareTo(relevantVal);
            if (sortMode == SortMode.MAX) {
                if (cmp > 0) {
                    relevantVal = currentVal;
                }
            } else if (cmp < 0) {
                relevantVal = currentVal;
            }
            if (!iter.hasNext()) break;
            currentVal = iter.next();
        }
        return relevantVal;
    }

    static int getRelevantOrd(Ordinals.Docs readerOrds, int docId, SortMode sortMode) {
        Ordinals.Docs.Iter iter = readerOrds.getIter(docId);
        int currentVal = iter.next();
        if (currentVal == 0) {
            return 0;
        }
        int relevantVal = currentVal;
        do {
            if (sortMode == SortMode.MAX) {
                if (currentVal <= relevantVal) continue;
                relevantVal = currentVal;
                continue;
            }
            if (currentVal >= relevantVal) continue;
            relevantVal = currentVal;
        } while ((currentVal = iter.next()) != 0);
        return relevantVal;
    }

    class MultiAnyOrdComparator
    extends PerSegmentComparator {
        private final BytesValues.WithOrdinals termsIndex;
        private final Ordinals.Docs readerOrds;

        private MultiAnyOrdComparator(BytesValues.WithOrdinals termsIndex) {
            this.termsIndex = termsIndex;
            this.readerOrds = termsIndex.ordinals();
        }

        public int compareBottom(int doc) throws IOException {
            int docOrd = BytesRefOrdValComparator.getRelevantOrd(this.readerOrds, doc, BytesRefOrdValComparator.this.sortMode);
            if (BytesRefOrdValComparator.this.bottomSameReader) {
                return BytesRefOrdValComparator.this.bottomOrd - docOrd;
            }
            if (BytesRefOrdValComparator.this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        public void copy(int slot, int doc) throws IOException {
            int ord;
            BytesRefOrdValComparator.this.ords[slot] = ord = BytesRefOrdValComparator.getRelevantOrd(this.readerOrds, doc, BytesRefOrdValComparator.this.sortMode);
            if (ord == 0) {
                BytesRefOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord > 0);
                if (BytesRefOrdValComparator.this.values[slot] == null) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getValueScratchByOrd(ord, BytesRefOrdValComparator.this.values[slot]);
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }

        @Override
        public int compareDocToValue(int doc, BytesRef value) {
            BytesRef docValue = BytesRefOrdValComparator.getRelevantValue(this.termsIndex, doc, BytesRefOrdValComparator.this.sortMode);
            if (docValue == null) {
                if (value == null) {
                    return 0;
                }
                return -1;
            }
            if (value == null) {
                return 1;
            }
            return docValue.compareTo(value);
        }
    }

    final class AnyOrdComparator
    extends PerSegmentComparator {
        private final IndexFieldData fieldData;
        private final Ordinals.Docs readerOrds;
        private final BytesValues.WithOrdinals termsIndex;
        private final int docBase;

        public AnyOrdComparator(IndexFieldData fieldData, BytesValues.WithOrdinals termsIndex, int docBase) {
            this.fieldData = fieldData;
            this.readerOrds = termsIndex.ordinals();
            this.termsIndex = termsIndex;
            this.docBase = docBase;
        }

        public int compareBottom(int doc) {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            int docOrd = this.readerOrds.getOrd(doc);
            if (BytesRefOrdValComparator.this.bottomSameReader) {
                return BytesRefOrdValComparator.this.bottomOrd - docOrd;
            }
            if (BytesRefOrdValComparator.this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        public void copy(int slot, int doc) {
            int ord;
            BytesRefOrdValComparator.this.ords[slot] = ord = this.readerOrds.getOrd(doc);
            if (ord == 0) {
                BytesRefOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord > 0);
                if (BytesRefOrdValComparator.this.values[slot] == null) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getValueScratchByOrd(ord, BytesRefOrdValComparator.this.values[slot]);
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }
    }

    private final class IntOrdComparator
    extends PerSegmentComparator {
        private final int[] readerOrds;
        private final BytesValues.WithOrdinals termsIndex;
        private final int docBase;

        public IntOrdComparator(int[] readerOrds, BytesValues.WithOrdinals termsIndex, int docBase) {
            this.readerOrds = readerOrds;
            this.termsIndex = termsIndex;
            this.docBase = docBase;
        }

        public int compareBottom(int doc) {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            int docOrd = this.readerOrds[doc];
            if (BytesRefOrdValComparator.this.bottomSameReader) {
                return BytesRefOrdValComparator.this.bottomOrd - docOrd;
            }
            if (BytesRefOrdValComparator.this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        public void copy(int slot, int doc) {
            int ord;
            BytesRefOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc];
            if (ord == 0) {
                BytesRefOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord > 0);
                if (BytesRefOrdValComparator.this.values[slot] == null) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getValueScratchByOrd(ord, BytesRefOrdValComparator.this.values[slot]);
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }
    }

    private final class ShortOrdComparator
    extends PerSegmentComparator {
        private final short[] readerOrds;
        private final BytesValues.WithOrdinals termsIndex;
        private final int docBase;

        public ShortOrdComparator(short[] readerOrds, BytesValues.WithOrdinals termsIndex, int docBase) {
            this.readerOrds = readerOrds;
            this.termsIndex = termsIndex;
            this.docBase = docBase;
        }

        public int compareBottom(int doc) {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            int docOrd = this.readerOrds[doc] & 0xFFFF;
            if (BytesRefOrdValComparator.this.bottomSameReader) {
                return BytesRefOrdValComparator.this.bottomOrd - docOrd;
            }
            if (BytesRefOrdValComparator.this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        public void copy(int slot, int doc) {
            int ord;
            BytesRefOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFFFF;
            if (ord == 0) {
                BytesRefOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord > 0);
                if (BytesRefOrdValComparator.this.values[slot] == null) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getValueScratchByOrd(ord, BytesRefOrdValComparator.this.values[slot]);
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }
    }

    private final class ByteOrdComparator
    extends PerSegmentComparator {
        private final byte[] readerOrds;
        private final BytesValues.WithOrdinals termsIndex;
        private final int docBase;

        public ByteOrdComparator(byte[] readerOrds, BytesValues.WithOrdinals termsIndex, int docBase) {
            this.readerOrds = readerOrds;
            this.termsIndex = termsIndex;
            this.docBase = docBase;
        }

        public int compareBottom(int doc) {
            assert (BytesRefOrdValComparator.this.bottomSlot != -1);
            int docOrd = this.readerOrds[doc] & 0xFF;
            if (BytesRefOrdValComparator.this.bottomSameReader) {
                return BytesRefOrdValComparator.this.bottomOrd - docOrd;
            }
            if (BytesRefOrdValComparator.this.bottomOrd >= docOrd) {
                return 1;
            }
            return -1;
        }

        public void copy(int slot, int doc) {
            int ord;
            BytesRefOrdValComparator.this.ords[slot] = ord = this.readerOrds[doc] & 0xFF;
            if (ord == 0) {
                BytesRefOrdValComparator.this.values[slot] = null;
            } else {
                assert (ord > 0);
                if (BytesRefOrdValComparator.this.values[slot] == null) {
                    BytesRefOrdValComparator.this.values[slot] = new BytesRef();
                }
                this.termsIndex.getValueScratchByOrd(ord, BytesRefOrdValComparator.this.values[slot]);
            }
            BytesRefOrdValComparator.this.readerGen[slot] = BytesRefOrdValComparator.this.currentReaderGen;
        }
    }

    abstract class PerSegmentComparator
    extends FieldComparator<BytesRef> {
        PerSegmentComparator() {
        }

        public FieldComparator<BytesRef> setNextReader(AtomicReaderContext context) throws IOException {
            return BytesRefOrdValComparator.this.setNextReader(context);
        }

        public int compare(int slot1, int slot2) {
            return BytesRefOrdValComparator.this.compare(slot1, slot2);
        }

        public void setBottom(int bottom) {
            BytesRefOrdValComparator.this.setBottom(bottom);
        }

        public BytesRef value(int slot) {
            return BytesRefOrdValComparator.this.value(slot);
        }

        public int compareValues(BytesRef val1, BytesRef val2) {
            if (val1 == null) {
                if (val2 == null) {
                    return 0;
                }
                return -1;
            }
            if (val2 == null) {
                return 1;
            }
            return val1.compareTo(val2);
        }

        public int compareDocToValue(int doc, BytesRef value) {
            return BytesRefOrdValComparator.this.compareDocToValue(doc, value);
        }
    }
}

