/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class EmptyOrdinals
implements Ordinals {
    private final int numDocs;

    public EmptyOrdinals(int numDocs) {
        this.numDocs = numDocs;
    }

    @Override
    public long getMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return false;
    }

    @Override
    public Object getBackingStorage() {
        return null;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public int getNumOrds() {
        return 0;
    }

    @Override
    public int getMaxOrd() {
        return 1;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final EmptyOrdinals parent;
        public static final IntsRef EMPTY_INTS_REF = new IntsRef();

        public Docs(EmptyOrdinals parent) {
            this.parent = parent;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return 0;
        }

        @Override
        public int getMaxOrd() {
            return 1;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getOrd(int docId) {
            return 0;
        }

        @Override
        public IntsRef getOrds(int docId) {
            return EMPTY_INTS_REF;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return Ordinals.Docs.EmptyIter.INSTANCE;
        }
    }
}

