/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.fielddata.ordinals.MultiFlatArrayOrdinals;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.SingleArrayOrdinals;
import org.elasticsearch.index.fielddata.ordinals.SparseMultiArrayOrdinals;

public final class OrdinalsBuilder
implements Closeable {
    private final int[] ords;
    private int[] offsets;
    private final IntBlockPool pool;
    private final IntBlockPool.SliceWriter writer;
    private final IntsRef intsRef = new IntsRef(1);
    private final IntBlockPool.SliceReader reader;
    private int currentOrd = 0;
    private int numDocsWithValue = 0;
    private int numMultiValuedDocs = 0;
    private int totalNumOrds = 0;

    public OrdinalsBuilder(Terms terms, int maxDoc, IntBlockPool.Allocator allocator) {
        this.ords = new int[maxDoc];
        this.pool = new IntBlockPool(allocator);
        this.reader = new IntBlockPool.SliceReader(this.pool);
        this.writer = new IntBlockPool.SliceWriter(this.pool);
    }

    public OrdinalsBuilder(int maxDoc) {
        this(null, maxDoc);
    }

    public OrdinalsBuilder(Terms terms, int maxDoc) {
        this(terms, maxDoc, (IntBlockPool.Allocator)new IntBlockPool.DirectAllocator());
    }

    public int nextOrdinal() {
        return ++this.currentOrd;
    }

    public int currentOrdinal() {
        return this.currentOrd;
    }

    public OrdinalsBuilder addDoc(int doc) {
        ++this.totalNumOrds;
        int docsOrd = this.ords[doc];
        if (docsOrd == 0) {
            this.ords[doc] = this.currentOrd;
            ++this.numDocsWithValue;
        } else if (docsOrd > 0) {
            ++this.numMultiValuedDocs;
            int offset = this.writer.startNewSlice();
            this.writer.writeInt(docsOrd);
            this.writer.writeInt(this.currentOrd);
            if (this.offsets == null) {
                this.offsets = new int[this.ords.length];
            }
            this.offsets[doc] = this.writer.getCurrentOffset();
            this.ords[doc] = -1 * offset - 1;
        } else {
            assert (this.offsets != null);
            this.writer.reset(this.offsets[doc]);
            this.writer.writeInt(this.currentOrd);
            this.offsets[doc] = this.writer.getCurrentOffset();
        }
        return this;
    }

    public boolean isMultiValued() {
        return this.offsets != null;
    }

    public int getNumDocsWithValue() {
        return this.numDocsWithValue;
    }

    public int getNumSingleValuedDocs() {
        return this.numDocsWithValue - this.numMultiValuedDocs;
    }

    public int getNumMultiValuesDocs() {
        return this.numMultiValuedDocs;
    }

    public int getTotalNumOrds() {
        return this.totalNumOrds;
    }

    public int getNumOrds() {
        return this.currentOrd;
    }

    public FixedBitSet buildDocsWithValuesSet() {
        if (this.numDocsWithValue == this.ords.length) {
            return null;
        }
        FixedBitSet bitSet = new FixedBitSet(this.ords.length);
        for (int i = 0; i < this.ords.length; ++i) {
            if (this.ords[i] == 0) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    public Ordinals build(Settings settings) {
        if (this.numMultiValuedDocs == 0) {
            return new SingleArrayOrdinals(this.ords, this.getNumOrds());
        }
        String multiOrdinals = settings.get("multi_ordinals", "sparse");
        if ("flat".equals(multiOrdinals)) {
            ArrayList<int[]> ordinalBuffer = new ArrayList<int[]>();
            for (int i = 0; i < this.ords.length; ++i) {
                IntsRef docOrds = this.docOrds(i);
                while (ordinalBuffer.size() < docOrds.length) {
                    ordinalBuffer.add(new int[this.ords.length]);
                }
                for (int j = docOrds.offset; j < docOrds.offset + docOrds.length; ++j) {
                    ((int[])ordinalBuffer.get((int)j))[i] = docOrds.ints[j];
                }
            }
            int[][] nativeOrdinals = new int[ordinalBuffer.size()][];
            for (int i = 0; i < nativeOrdinals.length; ++i) {
                nativeOrdinals[i] = (int[])ordinalBuffer.get(i);
            }
            return new MultiFlatArrayOrdinals(nativeOrdinals, this.getNumOrds());
        }
        if ("sparse".equals(multiOrdinals)) {
            int multiOrdinalsMaxDocs = settings.getAsInt("multi_ordinals_max_docs", (Integer)0x1000000);
            return new SparseMultiArrayOrdinals(this, multiOrdinalsMaxDocs);
        }
        throw new ElasticSearchIllegalArgumentException("no applicable fielddata multi_ordinals value, got [" + multiOrdinals + "]");
    }

    public IntsRef docOrds(int doc) {
        int docsOrd = this.ords[doc];
        this.intsRef.offset = 0;
        if (docsOrd == 0) {
            this.intsRef.length = 0;
        } else if (docsOrd > 0) {
            this.intsRef.ints[0] = this.ords[doc];
            this.intsRef.length = 1;
        } else {
            assert (this.offsets != null);
            this.reader.reset(-1 * (this.ords[doc] + 1), this.offsets[doc]);
            int pos = 0;
            while (!this.reader.endOfSlice()) {
                if (this.intsRef.ints.length <= pos) {
                    this.intsRef.ints = ArrayUtil.grow((int[])this.intsRef.ints, (int)(pos + 1));
                }
                this.intsRef.ints[pos++] = this.reader.readInt();
            }
            this.intsRef.length = pos;
        }
        return this.intsRef;
    }

    public int maxDoc() {
        return this.ords.length;
    }

    public TermsEnum wrapNumeric64Bit(TermsEnum termsEnum) {
        return new FilteredTermsEnum(termsEnum, false){

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return NumericUtils.getPrefixCodedLongShift((BytesRef)term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public TermsEnum wrapNumeric32Bit(TermsEnum termsEnum) {
        return new FilteredTermsEnum(termsEnum, false){

            protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
                return NumericUtils.getPrefixCodedIntShift((BytesRef)term) == 0 ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.END;
            }
        };
    }

    public BytesRefIterator buildFromTerms(final TermsEnum termsEnum, final Bits liveDocs) throws IOException {
        return new BytesRefIterator(){
            private DocsEnum docsEnum = null;

            public BytesRef next() throws IOException {
                BytesRef ref = termsEnum.next();
                if (ref != null) {
                    int docId;
                    this.docsEnum = termsEnum.docs(liveDocs, this.docsEnum, 0);
                    OrdinalsBuilder.this.nextOrdinal();
                    while ((docId = this.docsEnum.nextDoc()) != Integer.MAX_VALUE) {
                        OrdinalsBuilder.this.addDoc(docId);
                    }
                }
                return ref;
            }

            public Comparator<BytesRef> getComparator() {
                return termsEnum.getComparator();
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.pool.reset(true, false);
        this.offsets = null;
    }
}

