/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.RamUsage;

final class PositiveIntPool {
    private final int blockShift;
    private final int blockMask;
    private final int blockSize;
    private int[][] buffers = new int[10][];
    private int bufferUpto = -1;
    private int intUpto;
    private int[] buffer;
    private int intOffset;

    public PositiveIntPool(int blockShift) {
        this.blockShift = blockShift;
        this.blockSize = 1 << blockShift;
        this.blockMask = this.blockSize - 1;
        this.intUpto = this.blockSize;
        this.intOffset = -this.blockSize;
    }

    public int put(IntsRef slice) {
        if (slice.length > this.blockSize) {
            throw new ElasticSearchIllegalArgumentException("Can not store slices greater or equal to: " + this.blockSize);
        }
        if (this.intUpto + slice.length > this.blockSize) {
            this.nextBuffer();
        }
        int relativeOffset = this.intUpto;
        System.arraycopy(slice.ints, slice.offset, this.buffer, relativeOffset, slice.length);
        this.intUpto += slice.length;
        int n = this.intUpto - 1;
        this.buffer[n] = this.buffer[n] * -1;
        return relativeOffset + this.intOffset;
    }

    public int getFirstFromOffset(int offset) {
        int blockOffset = offset >> this.blockShift;
        int relativeOffset = offset & this.blockMask;
        int[] currentBuffer = this.buffers[blockOffset];
        assert (currentBuffer[relativeOffset] >= 0);
        return currentBuffer[relativeOffset];
    }

    public void fill(IntsRef slice, int offset) {
        int blockOffset = offset >> this.blockShift;
        int relativeOffset = offset & this.blockMask;
        int[] currentBuffer = this.buffers[blockOffset];
        slice.offset = 0;
        slice.length = 0;
        for (int i = relativeOffset; i < currentBuffer.length; ++i) {
            ++slice.length;
            if (currentBuffer[i] < 0) break;
        }
        if (slice.length != 0) {
            slice.ints = ArrayUtil.grow((int[])slice.ints, (int)slice.length);
            System.arraycopy(currentBuffer, relativeOffset, slice.ints, 0, slice.length);
            int n = slice.length - 1;
            slice.ints[n] = slice.ints[n] * -1;
        }
    }

    public long getMemorySizeInBytes() {
        return (this.bufferUpto + 1) * this.blockSize * 4 + (this.bufferUpto + 1) * RamUsage.NUM_BYTES_ARRAY_HEADER;
    }

    private void nextBuffer() {
        if (1 + this.bufferUpto == this.buffers.length) {
            int[][] newBuffers = new int[(int)((double)this.buffers.length * 1.5)][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        int[] nArray = new int[this.blockSize];
        this.buffers[1 + this.bufferUpto] = nArray;
        this.buffer = nArray;
        ++this.bufferUpto;
        this.intUpto = 0;
        this.intOffset += this.blockSize;
    }
}

