/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class SingleArrayOrdinals
implements Ordinals {
    private final int[] ordinals;
    private final int numOrds;
    private final int maxOrd;
    private long size = -1L;

    public SingleArrayOrdinals(int[] ordinals, int numOrds) {
        this.ordinals = ordinals;
        this.numOrds = numOrds;
        this.maxOrd = numOrds + 1;
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return true;
    }

    @Override
    public Object getBackingStorage() {
        return this.ordinals;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            this.size = 4 * this.ordinals.length + RamUsage.NUM_BYTES_ARRAY_HEADER;
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.ordinals.length;
    }

    @Override
    public int getNumOrds() {
        return this.numOrds;
    }

    @Override
    public int getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.ordinals);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final SingleArrayOrdinals parent;
        private final int[] ordinals;
        private final IntsRef intsScratch = new IntsRef(1);
        private final Ordinals.Docs.SingleValueIter iter = new Ordinals.Docs.SingleValueIter();

        public Docs(SingleArrayOrdinals parent, int[] ordinals) {
            this.parent = parent;
            this.ordinals = ordinals;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public int getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getOrd(int docId) {
            return this.ordinals[docId];
        }

        @Override
        public IntsRef getOrds(int docId) {
            int ordinal = this.ordinals[docId];
            if (ordinal == 0) {
                this.intsScratch.length = 0;
            } else {
                this.intsScratch.ints[0] = ordinal;
                this.intsScratch.offset = 0;
                this.intsScratch.length = 1;
            }
            return this.intsScratch;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return this.iter.reset(this.ordinals[docId]);
        }
    }
}

