/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.ordinals;

import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.packed.PackedInts;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public class SinglePackedOrdinals
implements Ordinals {
    private final PackedInts.Reader reader;
    private final int numOrds;
    private final int maxOrd;
    private long size = -1L;

    public SinglePackedOrdinals(PackedInts.Reader reader, int numOrds) {
        this.reader = reader;
        this.numOrds = numOrds;
        this.maxOrd = numOrds + 1;
    }

    @Override
    public boolean hasSingleArrayBackingStorage() {
        return this.reader.hasArray();
    }

    @Override
    public Object getBackingStorage() {
        if (this.reader.hasArray()) {
            return this.reader.getArray();
        }
        return this.reader;
    }

    @Override
    public long getMemorySizeInBytes() {
        if (this.size == -1L) {
            this.size = (long)RamUsage.NUM_BYTES_OBJECT_REF + this.reader.ramBytesUsed();
        }
        return this.size;
    }

    @Override
    public boolean isMultiValued() {
        return false;
    }

    @Override
    public int getNumDocs() {
        return this.reader.size();
    }

    @Override
    public int getNumOrds() {
        return this.numOrds;
    }

    @Override
    public int getMaxOrd() {
        return this.maxOrd;
    }

    @Override
    public Docs ordinals() {
        return new Docs(this, this.reader);
    }

    public static class Docs
    implements Ordinals.Docs {
        private final SinglePackedOrdinals parent;
        private final PackedInts.Reader reader;
        private final IntsRef intsScratch = new IntsRef(1);
        private final Ordinals.Docs.SingleValueIter iter = new Ordinals.Docs.SingleValueIter();

        public Docs(SinglePackedOrdinals parent, PackedInts.Reader reader) {
            this.parent = parent;
            this.reader = reader;
        }

        @Override
        public Ordinals ordinals() {
            return this.parent;
        }

        @Override
        public int getNumDocs() {
            return this.parent.getNumDocs();
        }

        @Override
        public int getNumOrds() {
            return this.parent.getNumOrds();
        }

        @Override
        public int getMaxOrd() {
            return this.parent.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public int getOrd(int docId) {
            return (int)this.reader.get(docId);
        }

        @Override
        public IntsRef getOrds(int docId) {
            int ordinal = (int)this.reader.get(docId);
            if (ordinal == 0) {
                this.intsScratch.length = 0;
            } else {
                this.intsScratch.offset = 0;
                this.intsScratch.length = 1;
                this.intsScratch.ints[0] = ordinal;
            }
            return this.intsScratch;
        }

        @Override
        public Ordinals.Docs.Iter getIter(int docId) {
            return this.iter.reset((int)this.reader.get(docId));
        }
    }
}

