/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.RamUsage;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

public abstract class ByteArrayAtomicFieldData
extends AtomicNumericFieldData {
    public static final ByteArrayAtomicFieldData EMPTY = new Empty();
    protected final byte[] values;
    private final int numDocs;
    protected long size = -1L;

    public ByteArrayAtomicFieldData(byte[] values, int numDocs) {
        super(false);
        this.values = values;
        this.numDocs = numDocs;
    }

    @Override
    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public void close() {
    }

    public static class Single
    extends ByteArrayAtomicFieldData {
        public Single(byte[] values, int numDocs) {
            super(values, numDocs);
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values);
        }

        static class DoubleValues
        extends DoubleValues.Dense {
            private final byte[] values;

            DoubleValues(byte[] values) {
                super(false);
                this.values = values;
            }

            @Override
            public double getValue(int docId) {
                return this.values[docId];
            }
        }

        static class LongValues
        extends LongValues.Dense {
            private final byte[] values;

            LongValues(byte[] values) {
                super(false);
                this.values = values;
            }

            @Override
            public long getValue(int docId) {
                return this.values[docId];
            }
        }
    }

    public static class SingleFixedSet
    extends ByteArrayAtomicFieldData {
        private final FixedBitSet set;

        public SingleFixedSet(byte[] values, int numDocs, FixedBitSet set) {
            super(values, numDocs);
            this.set = set;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length + this.set.getBits().length * 8;
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.set);
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.set);
        }

        static class DoubleValues
        extends org.elasticsearch.index.fielddata.DoubleValues {
            private final byte[] values;
            private final FixedBitSet set;

            DoubleValues(byte[] values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public boolean hasValue(int docId) {
                return this.set.get(docId);
            }

            @Override
            public double getValue(int docId) {
                return this.values[docId];
            }
        }

        static class LongValues
        extends org.elasticsearch.index.fielddata.LongValues {
            private final byte[] values;
            private final FixedBitSet set;

            LongValues(byte[] values, FixedBitSet set) {
                super(false);
                this.values = values;
                this.set = set;
            }

            @Override
            public boolean hasValue(int docId) {
                return this.set.get(docId);
            }

            @Override
            public long getValue(int docId) {
                return this.values[docId];
            }
        }
    }

    public static class WithOrdinals
    extends ByteArrayAtomicFieldData {
        private final Ordinals ordinals;

        public WithOrdinals(byte[] values, int numDocs, Ordinals ordinals) {
            super(values, numDocs);
            this.ordinals = ordinals;
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public boolean isValuesOrdered() {
            return true;
        }

        @Override
        public long getMemorySizeInBytes() {
            if (this.size == -1L) {
                this.size = (long)(8 + RamUsage.NUM_BYTES_ARRAY_HEADER + this.values.length) + this.ordinals.getMemorySizeInBytes();
            }
            return this.size;
        }

        @Override
        public LongValues getLongValues() {
            return new LongValues(this.values, this.ordinals.ordinals());
        }

        @Override
        public DoubleValues getDoubleValues() {
            return new DoubleValues(this.values, this.ordinals.ordinals());
        }

        static class DoubleValues
        extends DoubleValues.WithOrdinals {
            private final byte[] values;

            DoubleValues(byte[] values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public double getValueByOrd(int ord) {
                return this.values[ord];
            }
        }

        static class LongValues
        extends LongValues.WithOrdinals {
            private final byte[] values;

            LongValues(byte[] values, Ordinals.Docs ordinals) {
                super(ordinals);
                this.values = values;
            }

            @Override
            public long getValueByOrd(int ord) {
                return this.values[ord];
            }
        }
    }

    static class Empty
    extends ByteArrayAtomicFieldData {
        Empty() {
            super(null, 0);
        }

        @Override
        public LongValues getLongValues() {
            return LongValues.EMPTY;
        }

        @Override
        public DoubleValues getDoubleValues() {
            return DoubleValues.EMPTY;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isValuesOrdered() {
            return false;
        }

        @Override
        public long getMemorySizeInBytes() {
            return 0L;
        }

        @Override
        public BytesValues getBytesValues() {
            return BytesValues.EMPTY;
        }

        @Override
        public ScriptDocValues getScriptValues() {
            return ScriptDocValues.EMPTY;
        }
    }
}

