/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.list.array.TFloatArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.FloatArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class FloatArrayIndexFieldData
extends AbstractIndexFieldData<FloatArrayAtomicFieldData>
implements IndexNumericFieldData<FloatArrayAtomicFieldData> {
    public FloatArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.FLOAT;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public FloatArrayAtomicFieldData load(AtomicReaderContext context) {
        try {
            return (FloatArrayAtomicFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FloatArrayAtomicFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return FloatArrayAtomicFieldData.EMPTY;
        }
        TFloatArrayList values = new TFloatArrayList();
        values.add(0.0f);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            BytesRef term;
            BytesRefIterator iter = builder.buildFromTerms(builder.wrapNumeric32Bit(terms.iterator(null)), reader.getLiveDocs());
            while ((term = iter.next()) != null) {
                values.add(NumericUtils.sortableIntToFloat((int)NumericUtils.prefixCodedToInt((BytesRef)term)));
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(this.fieldDataType)) {
                long ordinalsSize;
                Ordinals.Docs ordinals = build.ordinals();
                FixedBitSet set = builder.buildDocsWithValuesSet();
                long singleValuesArraySize = reader.maxDoc() * 4 + (set == null ? 0 : set.getBits().length * 8 + 4);
                long uniqueValuesArraySize = values.size() * 4;
                if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                    FloatArrayAtomicFieldData.WithOrdinals withOrdinals = new FloatArrayAtomicFieldData.WithOrdinals(values.toArray(new float[values.size()]), reader.maxDoc(), build);
                    return withOrdinals;
                }
                float[] sValues = new float[reader.maxDoc()];
                int maxDoc = reader.maxDoc();
                for (int i = 0; i < maxDoc; ++i) {
                    sValues[i] = values.get(ordinals.getOrd(i));
                }
                if (set == null) {
                    FloatArrayAtomicFieldData.Single single = new FloatArrayAtomicFieldData.Single(sValues, reader.maxDoc());
                    return single;
                }
                FloatArrayAtomicFieldData.SingleFixedSet singleFixedSet = new FloatArrayAtomicFieldData.SingleFixedSet(sValues, reader.maxDoc(), set);
                return singleFixedSet;
            }
            FloatArrayAtomicFieldData.WithOrdinals withOrdinals = new FloatArrayAtomicFieldData.WithOrdinals(values.toArray(new float[values.size()]), reader.maxDoc(), build);
            return withOrdinals;
        }
        finally {
            builder.close();
        }
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new FloatValuesComparatorSource(this, missingValue, sortMode);
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new FloatArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

