/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.iterator.TIntIterator;
import org.elasticsearch.common.trove.list.array.TIntArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.IntValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.ByteArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ByteArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.IntArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ShortArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ShortArrayIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class IntArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData<AtomicNumericFieldData> {
    public IntArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.INT;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public AtomicNumericFieldData load(AtomicReaderContext context) {
        try {
            return (AtomicNumericFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return IntArrayAtomicFieldData.EMPTY;
        }
        final TIntArrayList values = new TIntArrayList();
        values.add(0);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            BytesRef term;
            int max = Integer.MIN_VALUE;
            int min = Integer.MAX_VALUE;
            BytesRefIterator iter = builder.buildFromTerms(builder.wrapNumeric32Bit(terms.iterator(null)), reader.getLiveDocs());
            while ((term = iter.next()) != null) {
                int value = NumericUtils.prefixCodedToInt((BytesRef)term);
                values.add(value);
                if (value > max) {
                    max = value;
                }
                if (value >= min) continue;
                min = value;
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (this.fieldDataType.getSettings().getAsBoolean("optimize_type", (Boolean)true).booleanValue()) {
                if (min >= -128 && max <= 127) {
                    ByteArrayAtomicFieldData byteArrayAtomicFieldData = ByteArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new ByteArrayIndexFieldData.BuilderBytes(){

                        @Override
                        public byte get(int index) {
                            return (byte)values.get(index);
                        }

                        @Override
                        public byte[] toArray() {
                            byte[] bValues = new byte[values.size()];
                            int i = 0;
                            TIntIterator it = values.iterator();
                            while (it.hasNext()) {
                                bValues[i++] = (byte)it.next();
                            }
                            return bValues;
                        }
                    });
                    return byteArrayAtomicFieldData;
                }
                if (min >= Short.MIN_VALUE && max <= Short.MAX_VALUE) {
                    ShortArrayAtomicFieldData shortArrayAtomicFieldData = ShortArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new ShortArrayIndexFieldData.BuilderShorts(){

                        @Override
                        public short get(int index) {
                            return (short)values.get(index);
                        }

                        @Override
                        public short[] toArray() {
                            short[] sValues = new short[values.size()];
                            int i = 0;
                            TIntIterator it = values.iterator();
                            while (it.hasNext()) {
                                sValues[i++] = (short)it.next();
                            }
                            return sValues;
                        }

                        @Override
                        public int size() {
                            return values.size();
                        }
                    });
                    return shortArrayAtomicFieldData;
                }
            }
            IntArrayAtomicFieldData intArrayAtomicFieldData = IntArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new BuilderIntegers(){

                @Override
                public int get(int index) {
                    return values.get(index);
                }

                @Override
                public int[] toArray() {
                    return values.toArray();
                }

                @Override
                public int size() {
                    return values.size();
                }
            });
            return intArrayAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    static IntArrayAtomicFieldData build(AtomicReader reader, FieldDataType fieldDataType, OrdinalsBuilder builder, Ordinals build, BuilderIntegers values) {
        if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(fieldDataType)) {
            long ordinalsSize;
            Ordinals.Docs ordinals = build.ordinals();
            FixedBitSet set = builder.buildDocsWithValuesSet();
            long singleValuesArraySize = reader.maxDoc() * 4 + (set == null ? 0 : set.getBits().length * 8 + 4);
            long uniqueValuesArraySize = values.size() * 4;
            if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                return new IntArrayAtomicFieldData.WithOrdinals(values.toArray(), reader.maxDoc(), build);
            }
            int[] sValues = new int[reader.maxDoc()];
            int maxDoc = reader.maxDoc();
            for (int i = 0; i < maxDoc; ++i) {
                sValues[i] = values.get(ordinals.getOrd(i));
            }
            if (set == null) {
                return new IntArrayAtomicFieldData.Single(sValues, reader.maxDoc());
            }
            return new IntArrayAtomicFieldData.SingleFixedSet(sValues, reader.maxDoc(), set);
        }
        return new IntArrayAtomicFieldData.WithOrdinals(values.toArray(), reader.maxDoc(), build);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new IntValuesComparatorSource(this, missingValue, sortMode);
    }

    static interface BuilderIntegers {
        public int get(int var1);

        public int[] toArray();

        public int size();
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new IntArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

