/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.iterator.TShortIterator;
import org.elasticsearch.common.trove.list.array.TShortArrayList;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AbstractIndexFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.ShortValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.elasticsearch.index.fielddata.plain.ByteArrayAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.ByteArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.ShortArrayAtomicFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;

public class ShortArrayIndexFieldData
extends AbstractIndexFieldData<AtomicNumericFieldData>
implements IndexNumericFieldData<AtomicNumericFieldData> {
    public ShortArrayIndexFieldData(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndexFieldDataCache cache) {
        super(index, indexSettings, fieldNames, fieldDataType, cache);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return IndexNumericFieldData.NumericType.SHORT;
    }

    @Override
    public boolean valuesOrdered() {
        return false;
    }

    @Override
    public AtomicNumericFieldData load(AtomicReaderContext context) {
        try {
            return (AtomicNumericFieldData)this.cache.load(context, this);
        }
        catch (Throwable e) {
            if (e instanceof ElasticSearchException) {
                throw (ElasticSearchException)e;
            }
            throw new ElasticSearchException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicNumericFieldData loadDirect(AtomicReaderContext context) throws Exception {
        AtomicReader reader = context.reader();
        Terms terms = reader.terms(this.getFieldNames().indexName());
        if (terms == null) {
            return ShortArrayAtomicFieldData.EMPTY;
        }
        final TShortArrayList values = new TShortArrayList();
        values.add((short)0);
        OrdinalsBuilder builder = new OrdinalsBuilder(terms, reader.maxDoc());
        try {
            BytesRef term;
            short max = Short.MIN_VALUE;
            short min = Short.MAX_VALUE;
            BytesRefIterator iter = builder.buildFromTerms(builder.wrapNumeric32Bit(terms.iterator(null)), reader.getLiveDocs());
            while ((term = iter.next()) != null) {
                short value = (short)NumericUtils.prefixCodedToInt((BytesRef)term);
                values.add(value);
                if (value > max) {
                    max = value;
                }
                if (value >= min) continue;
                min = value;
            }
            Ordinals build = builder.build(this.fieldDataType.getSettings());
            if (this.fieldDataType.getSettings().getAsBoolean("optimize_type", (Boolean)true).booleanValue() && min >= -128 && max <= 127) {
                ByteArrayAtomicFieldData byteArrayAtomicFieldData = ByteArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new ByteArrayIndexFieldData.BuilderBytes(){

                    @Override
                    public byte get(int index) {
                        return (byte)values.get(index);
                    }

                    @Override
                    public byte[] toArray() {
                        byte[] bValues = new byte[values.size()];
                        int i = 0;
                        TShortIterator it = values.iterator();
                        while (it.hasNext()) {
                            bValues[i++] = (byte)it.next();
                        }
                        return bValues;
                    }
                });
                return byteArrayAtomicFieldData;
            }
            ShortArrayAtomicFieldData shortArrayAtomicFieldData = ShortArrayIndexFieldData.build(reader, this.fieldDataType, builder, build, new BuilderShorts(){

                @Override
                public short get(int index) {
                    return values.get(index);
                }

                @Override
                public short[] toArray() {
                    return values.toArray();
                }

                @Override
                public int size() {
                    return values.size();
                }
            });
            return shortArrayAtomicFieldData;
        }
        finally {
            builder.close();
        }
    }

    static ShortArrayAtomicFieldData build(AtomicReader reader, FieldDataType fieldDataType, OrdinalsBuilder builder, Ordinals build, BuilderShorts values) {
        if (!build.isMultiValued() && IndexFieldData.CommonSettings.removeOrdsOnSingleValue(fieldDataType)) {
            long ordinalsSize;
            Ordinals.Docs ordinals = build.ordinals();
            FixedBitSet set = builder.buildDocsWithValuesSet();
            long singleValuesArraySize = reader.maxDoc() * 2 + (set == null ? 0 : set.getBits().length * 8 + 4);
            long uniqueValuesArraySize = values.size() * 2;
            if (uniqueValuesArraySize + (ordinalsSize = build.getMemorySizeInBytes()) < singleValuesArraySize) {
                return new ShortArrayAtomicFieldData.WithOrdinals(values.toArray(), reader.maxDoc(), build);
            }
            short[] sValues = new short[reader.maxDoc()];
            int maxDoc = reader.maxDoc();
            for (int i = 0; i < maxDoc; ++i) {
                sValues[i] = values.get(ordinals.getOrd(i));
            }
            if (set == null) {
                return new ShortArrayAtomicFieldData.Single(sValues, reader.maxDoc());
            }
            return new ShortArrayAtomicFieldData.SingleFixedSet(sValues, reader.maxDoc(), set);
        }
        return new ShortArrayAtomicFieldData.WithOrdinals(values.toArray(), reader.maxDoc(), build);
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, SortMode sortMode) {
        return new ShortValuesComparatorSource(this, missingValue, sortMode);
    }

    static interface BuilderShorts {
        public short get(int var1);

        public short[] toArray();

        public int size();
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData build(Index index, @IndexSettings Settings indexSettings, FieldMapper.Names fieldNames, FieldDataType type, IndexFieldDataCache cache) {
            return new ShortArrayIndexFieldData(index, indexSettings, fieldNames, type, cache);
        }
    }
}

