/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.get;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.elasticsearch.index.fieldvisitor.JustSourceFieldsVisitor;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceLookup;

public class ShardGetService
extends AbstractIndexShardComponent {
    private final ScriptService scriptService;
    private final MapperService mapperService;
    private final IndexFieldDataService fieldDataService;
    private IndexShard indexShard;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();

    @Inject
    public ShardGetService(ShardId shardId, @IndexSettings Settings indexSettings, ScriptService scriptService, MapperService mapperService, IndexFieldDataService fieldDataService) {
        super(shardId, indexSettings);
        this.scriptService = scriptService;
        this.mapperService = mapperService;
        this.fieldDataService = fieldDataService;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public ShardGetService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String type, String[] fields) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            DocumentMapper docMapper = this.mapperService.documentMapper(type);
            if (docMapper == null) {
                this.missingMetric.inc(System.nanoTime() - now);
                GetResult getResult = new GetResult(this.shardId.index().name(), type, id, -1L, false, null, null);
                return getResult;
            }
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, fields, engineGetResult, docMapper);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult innerGet(String type, String id, String[] gFields, boolean realtime) throws ElasticSearchException {
        DocumentMapper docMapper;
        boolean loadSource = gFields == null || gFields.length > 0;
        Engine.GetResult get = null;
        if (type == null || ((String)type).equals("_all")) {
            for (String string : this.mapperService.types()) {
                get = this.indexShard.get(new Engine.Get(realtime, new Term(UidFieldMapper.NAME, Uid.createUidAsBytes(string, id))).loadSource(loadSource));
                if (get.exists()) {
                    type = string;
                    break;
                }
                get.release();
            }
            if (get == null) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
            if (!get.exists()) {
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        } else {
            get = this.indexShard.get(new Engine.Get(realtime, new Term(UidFieldMapper.NAME, Uid.createUidAsBytes((String)type, id))).loadSource(loadSource));
            if (!get.exists()) {
                get.release();
                return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
            }
        }
        if ((docMapper = this.mapperService.documentMapper((String)type)) == null) {
            get.release();
            return new GetResult(this.shardId.index().name(), (String)type, id, -1L, false, null, null);
        }
        try {
            if (get.docIdAndVersion() != null) {
                GetResult getResult = this.innerGetLoadFromStoredFields((String)type, id, gFields, get, docMapper);
                return getResult;
            }
            Translog.Source source = get.source();
            HashMap<String, GetField> fields = null;
            boolean sourceRequested = false;
            if (gFields == null) {
                sourceRequested = true;
            } else if (gFields.length == 0) {
                sourceRequested = false;
            } else {
                Map<String, Object> sourceAsMap = null;
                SearchLookup searchLookup = null;
                for (String field : gFields) {
                    if (field.equals("_source")) {
                        sourceRequested = true;
                        continue;
                    }
                    Object value = null;
                    if (field.equals("_routing") && docMapper.routingFieldMapper().fieldType().stored()) {
                        value = source.routing;
                    } else if (field.equals("_parent") && docMapper.parentFieldMapper() != null && docMapper.parentFieldMapper().fieldType().stored()) {
                        value = source.parent;
                    } else if (field.equals("_timestamp") && docMapper.timestampFieldMapper().fieldType().stored()) {
                        value = source.timestamp;
                    } else if (field.equals("_ttl") && docMapper.TTLFieldMapper().fieldType().stored()) {
                        if (source.ttl > 0L) {
                            value = docMapper.TTLFieldMapper().valueForSearch(source.timestamp + source.ttl);
                        }
                    } else if (field.equals("_size") && docMapper.rootMapper(SizeFieldMapper.class).fieldType().stored()) {
                        value = source.source.length();
                    } else if (field.contains("_source.")) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                        }
                        if (sourceAsMap == null) {
                            sourceAsMap = SourceLookup.sourceAsMap(source.source);
                        }
                        SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field, null);
                        searchScript.setNextSource(sourceAsMap);
                        try {
                            value = searchScript.run();
                        }
                        catch (RuntimeException e) {
                            if (this.logger.isTraceEnabled()) {
                                this.logger.trace("failed to execute get request script field [{}]", e, field);
                            }
                        }
                    } else {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                            searchLookup.source().setNextSource(source.source);
                        }
                        FieldMapper x = docMapper.mappers().smartNameFieldMapper(field);
                        if ((docMapper.sourceMapper().enabled() || x == null || x.fieldType().stored()) && (value = searchLookup.source().extractValue(field)) != null && x != null) {
                            if (value instanceof List) {
                                List list = (List)value;
                                for (int i = 0; i < list.size(); ++i) {
                                    list.set(i, x.valueForSearch(list.get(i)));
                                }
                            } else {
                                value = x.valueForSearch(value);
                            }
                        }
                    }
                    if (value == null) continue;
                    if (fields == null) {
                        fields = Maps.newHashMapWithExpectedSize(2);
                    }
                    if (value instanceof List) {
                        fields.put(field, new GetField(field, (List)value));
                        continue;
                    }
                    fields.put(field, new GetField(field, ImmutableList.of(value)));
                }
            }
            if (sourceRequested && !docMapper.sourceMapper().enabled()) {
                sourceRequested = false;
            }
            BytesReference sourceToBeReturned = null;
            if (sourceRequested) {
                sourceToBeReturned = source.source;
                SourceFieldMapper sourceFieldMapper = docMapper.sourceMapper();
                if (sourceFieldMapper.enabled()) {
                    boolean filtered;
                    boolean bl = filtered = sourceFieldMapper.includes().length > 0 || sourceFieldMapper.excludes().length > 0;
                    if (filtered) {
                        Tuple<XContentType, Map<String, Object>> mapTuple = XContentHelper.convertToMap(source.source, true);
                        Map<String, Object> filteredSource = XContentMapValues.filter(mapTuple.v2(), sourceFieldMapper.includes(), sourceFieldMapper.excludes());
                        try {
                            sourceToBeReturned = XContentFactory.contentBuilder(mapTuple.v1()).map(filteredSource).bytes();
                        }
                        catch (IOException e) {
                            throw new ElasticSearchException("Failed to get type [" + (String)type + "] and id [" + id + "] with includes/excludes set", e);
                        }
                    }
                }
            }
            GetResult getResult = new GetResult(this.shardId.index().name(), (String)type, id, get.version(), get.exists(), sourceToBeReturned, fields);
            return getResult;
        }
        finally {
            get.release();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String type, String id, String[] gFields, Engine.GetResult get, DocumentMapper docMapper) {
        HashMap<String, GetField> fields = null;
        BytesReference source = null;
        UidField.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(gFields);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.reader.reader().document(docIdAndVersion.docId, (StoredFieldVisitor)fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticSearchException("Failed to get type [" + type + "] and id [" + id + "]", e);
            }
            source = fieldVisitor.source();
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(docMapper);
                fields = new HashMap<String, GetField>(fieldVisitor.fields().size());
                for (Map.Entry<String, List<Object>> entry : fieldVisitor.fields().entrySet()) {
                    fields.put(entry.getKey(), new GetField(entry.getKey(), entry.getValue()));
                }
            }
        }
        if (gFields != null && gFields.length > 0) {
            SearchLookup searchLookup = null;
            for (String field : gFields) {
                Object value = null;
                if (field.contains("_source.") || field.contains("doc[")) {
                    if (searchLookup == null) {
                        searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                    }
                    SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", field, null);
                    searchScript.setNextReader(docIdAndVersion.reader);
                    searchScript.setNextDocId(docIdAndVersion.docId);
                    try {
                        value = searchScript.run();
                    }
                    catch (RuntimeException e) {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("failed to execute get request script field [{}]", e, field);
                        }
                    }
                } else {
                    FieldMappers x = docMapper.mappers().smartName(field);
                    if (x == null || !x.mapper().fieldType().stored()) {
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(this.mapperService, this.fieldDataService, new String[]{type});
                            searchLookup.setNextReader(docIdAndVersion.reader);
                            searchLookup.setNextDocId(docIdAndVersion.docId);
                        }
                        if ((value = searchLookup.source().extractValue(field)) != null && x != null) {
                            if (value instanceof List) {
                                List list = (List)value;
                                for (int i = 0; i < list.size(); ++i) {
                                    list.set(i, x.mapper().valueForSearch(list.get(i)));
                                }
                            } else {
                                value = x.mapper().valueForSearch(value);
                            }
                        }
                    }
                }
                if (value == null) continue;
                if (fields == null) {
                    fields = Maps.newHashMapWithExpectedSize(2);
                }
                if (value instanceof List) {
                    fields.put(field, new GetField(field, (List)value));
                    continue;
                }
                fields.put(field, new GetField(field, ImmutableList.of(value)));
            }
        }
        return new GetResult(this.shardId.index().name(), type, id, get.version(), get.exists(), source, fields);
    }

    private static FieldsVisitor buildFieldsVisitors(String ... fields) {
        if (fields == null) {
            return new JustSourceFieldsVisitor();
        }
        if (fields.length == 0) {
            return null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), false);
    }
}

