/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.indexing;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class IndexingStats
implements Streamable,
ToXContent {
    private Stats totalStats;
    @Nullable
    private Map<String, Stats> typeStats;

    public IndexingStats() {
        this.totalStats = new Stats();
    }

    public IndexingStats(Stats totalStats, @Nullable Map<String, Stats> typeStats) {
        this.totalStats = totalStats;
        this.typeStats = typeStats;
    }

    public void add(IndexingStats indexingStats) {
        this.add(indexingStats, true);
    }

    public void add(IndexingStats indexingStats, boolean includeTypes) {
        if (indexingStats == null) {
            return;
        }
        this.totalStats.add(indexingStats.totalStats);
        if (includeTypes && indexingStats.typeStats != null && !indexingStats.typeStats.isEmpty()) {
            if (this.typeStats == null) {
                this.typeStats = new HashMap<String, Stats>(indexingStats.typeStats.size());
            }
            for (Map.Entry<String, Stats> entry : indexingStats.typeStats.entrySet()) {
                Stats stats = this.typeStats.get(entry.getKey());
                if (stats == null) {
                    this.typeStats.put(entry.getKey(), entry.getValue());
                    continue;
                }
                stats.add(entry.getValue());
            }
        }
    }

    public Stats getTotal() {
        return this.totalStats;
    }

    @Nullable
    public Map<String, Stats> getTypeStats() {
        return this.typeStats;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.INDEXING);
        this.totalStats.toXContent(builder, params);
        if (this.typeStats != null && !this.typeStats.isEmpty()) {
            builder.startObject(Fields.TYPES);
            for (Map.Entry<String, Stats> entry : this.typeStats.entrySet()) {
                builder.startObject(entry.getKey(), XContentBuilder.FieldCaseConversion.NONE);
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static IndexingStats readIndexingStats(StreamInput in) throws IOException {
        IndexingStats indexingStats = new IndexingStats();
        indexingStats.readFrom(in);
        return indexingStats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.totalStats = Stats.readStats(in);
        if (in.readBoolean()) {
            int size = in.readVInt();
            this.typeStats = new HashMap<String, Stats>(size);
            for (int i = 0; i < size; ++i) {
                this.typeStats.put(in.readString(), Stats.readStats(in));
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.totalStats.writeTo(out);
        if (this.typeStats == null || this.typeStats.isEmpty()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeVInt(this.typeStats.size());
            for (Map.Entry<String, Stats> entry : this.typeStats.entrySet()) {
                out.writeString(entry.getKey());
                entry.getValue().writeTo(out);
            }
        }
    }

    static final class Fields {
        static final XContentBuilderString INDEXING = new XContentBuilderString("indexing");
        static final XContentBuilderString TYPES = new XContentBuilderString("types");
        static final XContentBuilderString INDEX_TOTAL = new XContentBuilderString("index_total");
        static final XContentBuilderString INDEX_TIME = new XContentBuilderString("index_time");
        static final XContentBuilderString INDEX_TIME_IN_MILLIS = new XContentBuilderString("index_time_in_millis");
        static final XContentBuilderString INDEX_CURRENT = new XContentBuilderString("index_current");
        static final XContentBuilderString DELETE_TOTAL = new XContentBuilderString("delete_total");
        static final XContentBuilderString DELETE_TIME = new XContentBuilderString("delete_time");
        static final XContentBuilderString DELETE_TIME_IN_MILLIS = new XContentBuilderString("delete_time_in_millis");
        static final XContentBuilderString DELETE_CURRENT = new XContentBuilderString("delete_current");

        Fields() {
        }
    }

    public static class Stats
    implements Streamable,
    ToXContent {
        private long indexCount;
        private long indexTimeInMillis;
        private long indexCurrent;
        private long deleteCount;
        private long deleteTimeInMillis;
        private long deleteCurrent;

        Stats() {
        }

        public Stats(long indexCount, long indexTimeInMillis, long indexCurrent, long deleteCount, long deleteTimeInMillis, long deleteCurrent) {
            this.indexCount = indexCount;
            this.indexTimeInMillis = indexTimeInMillis;
            this.indexCurrent = indexCurrent;
            this.deleteCount = deleteCount;
            this.deleteTimeInMillis = deleteTimeInMillis;
            this.deleteCurrent = deleteCurrent;
        }

        public void add(Stats stats) {
            this.indexCount += stats.indexCount;
            this.indexTimeInMillis += stats.indexTimeInMillis;
            this.indexCurrent += stats.indexCurrent;
            this.deleteCount += stats.deleteCount;
            this.deleteTimeInMillis += stats.deleteTimeInMillis;
            this.deleteCurrent += stats.deleteCurrent;
        }

        public long getIndexCount() {
            return this.indexCount;
        }

        public TimeValue getIndexTime() {
            return new TimeValue(this.indexTimeInMillis);
        }

        public long getIndexTimeInMillis() {
            return this.indexTimeInMillis;
        }

        public long getIndexCurrent() {
            return this.indexCurrent;
        }

        public long getDeleteCount() {
            return this.deleteCount;
        }

        public TimeValue getDeleteTime() {
            return new TimeValue(this.deleteTimeInMillis);
        }

        public long getDeleteTimeInMillis() {
            return this.deleteTimeInMillis;
        }

        public long getDeleteCurrent() {
            return this.deleteCurrent;
        }

        public static Stats readStats(StreamInput in) throws IOException {
            Stats stats = new Stats();
            stats.readFrom(in);
            return stats;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.indexCount = in.readVLong();
            this.indexTimeInMillis = in.readVLong();
            this.indexCurrent = in.readVLong();
            this.deleteCount = in.readVLong();
            this.deleteTimeInMillis = in.readVLong();
            this.deleteCurrent = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.indexCount);
            out.writeVLong(this.indexTimeInMillis);
            out.writeVLong(this.indexCurrent);
            out.writeVLong(this.deleteCount);
            out.writeVLong(this.deleteTimeInMillis);
            out.writeVLong(this.deleteCurrent);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Fields.INDEX_TOTAL, this.indexCount);
            builder.field(Fields.INDEX_TIME, this.getIndexTime().toString());
            builder.field(Fields.INDEX_TIME_IN_MILLIS, this.indexTimeInMillis);
            builder.field(Fields.INDEX_CURRENT, this.indexCurrent);
            builder.field(Fields.DELETE_TOTAL, this.deleteCount);
            builder.field(Fields.DELETE_TIME, this.getDeleteTime().toString());
            builder.field(Fields.DELETE_TIME_IN_MILLIS, this.deleteTimeInMillis);
            builder.field(Fields.DELETE_CURRENT, this.deleteCurrent);
            return builder;
        }
    }
}

