/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Filter;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.compress.CompressedString;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.text.StringAndBytesText;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FailedToGenerateSourceMapperException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.mapper.internal.AnalyzerMapper;
import org.elasticsearch.index.mapper.internal.BoostFieldMapper;
import org.elasticsearch.index.mapper.internal.IdFieldMapper;
import org.elasticsearch.index.mapper.internal.IndexFieldMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.index.mapper.internal.RoutingFieldMapper;
import org.elasticsearch.index.mapper.internal.SizeFieldMapper;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.index.mapper.internal.TTLFieldMapper;
import org.elasticsearch.index.mapper.internal.TimestampFieldMapper;
import org.elasticsearch.index.mapper.internal.TypeFieldMapper;
import org.elasticsearch.index.mapper.internal.UidFieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public class DocumentMapper
implements ToXContent {
    private ThreadLocal<ParseContext> cache = new ThreadLocal<ParseContext>(){

        @Override
        protected ParseContext initialValue() {
            return new ParseContext(DocumentMapper.this.index, DocumentMapper.this.indexSettings, DocumentMapper.this.docMapperParser, DocumentMapper.this, new ContentPath(0));
        }
    };
    private final String index;
    private final Settings indexSettings;
    private final String type;
    private final StringAndBytesText typeText;
    private final DocumentMapperParser docMapperParser;
    private volatile ImmutableMap<String, Object> meta;
    private volatile CompressedString mappingSource;
    private final RootObjectMapper rootObjectMapper;
    private final ImmutableMap<Class<? extends RootMapper>, RootMapper> rootMappers;
    private final RootMapper[] rootMappersOrdered;
    private final RootMapper[] rootMappersNotIncludedInObject;
    private final NamedAnalyzer indexAnalyzer;
    private final NamedAnalyzer searchAnalyzer;
    private final NamedAnalyzer searchQuoteAnalyzer;
    private volatile DocumentFieldMappers fieldMappers;
    private volatile ImmutableMap<String, ObjectMapper> objectMappers = ImmutableMap.of();
    private final List<FieldMapperListener> fieldMapperListeners = new CopyOnWriteArrayList<FieldMapperListener>();
    private final List<ObjectMapperListener> objectMapperListeners = new CopyOnWriteArrayList<ObjectMapperListener>();
    private boolean hasNestedObjects = false;
    private final Filter typeFilter;
    private final Object mutex = new Object();
    private boolean initMappersAdded = true;

    public DocumentMapper(String index, @Nullable Settings indexSettings, DocumentMapperParser docMapperParser, RootObjectMapper rootObjectMapper, ImmutableMap<String, Object> meta, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, NamedAnalyzer searchQuoteAnalyzer, Map<Class<? extends RootMapper>, RootMapper> rootMappers) {
        this.index = index;
        this.indexSettings = indexSettings;
        this.type = rootObjectMapper.name();
        this.typeText = new StringAndBytesText(this.type);
        this.docMapperParser = docMapperParser;
        this.meta = meta;
        this.rootObjectMapper = rootObjectMapper;
        this.rootMappers = ImmutableMap.copyOf(rootMappers);
        this.rootMappersOrdered = rootMappers.values().toArray(new RootMapper[rootMappers.values().size()]);
        ArrayList<RootMapper> rootMappersNotIncludedInObjectLst = Lists.newArrayList();
        for (RootMapper rootMapper : this.rootMappersOrdered) {
            if (rootMapper.includeInObject()) continue;
            rootMappersNotIncludedInObjectLst.add(rootMapper);
        }
        this.rootMappersNotIncludedInObject = rootMappersNotIncludedInObjectLst.toArray(new RootMapper[rootMappersNotIncludedInObjectLst.size()]);
        this.indexAnalyzer = indexAnalyzer;
        this.searchAnalyzer = searchAnalyzer;
        this.searchQuoteAnalyzer = searchQuoteAnalyzer != null ? searchQuoteAnalyzer : searchAnalyzer;
        this.typeFilter = this.typeMapper().termFilter(this.type, null);
        if (this.rootMapper(ParentFieldMapper.class) != null) {
            this.rootMapper(RoutingFieldMapper.class).markAsRequired();
        }
        FieldMapperListener.Aggregator fieldMappersAgg = new FieldMapperListener.Aggregator();
        for (RootMapper rootMapper : this.rootMappersOrdered) {
            if (rootMapper.includeInObject()) {
                rootObjectMapper.putMapper(rootMapper);
                continue;
            }
            if (!(rootMapper instanceof FieldMapper)) continue;
            fieldMappersAgg.mappers.add((FieldMapper)((Object)rootMapper));
        }
        rootObjectMapper.traverse(fieldMappersAgg);
        this.fieldMappers = new DocumentFieldMappers(this, fieldMappersAgg.mappers);
        final HashMap objectMappers = Maps.newHashMap();
        rootObjectMapper.traverse(new ObjectMapperListener(){

            @Override
            public void objectMapper(ObjectMapper objectMapper) {
                objectMappers.put(objectMapper.fullPath(), objectMapper);
            }
        });
        this.objectMappers = ImmutableMap.copyOf(objectMappers);
        for (ObjectMapper objectMapper : objectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            this.hasNestedObjects = true;
        }
        this.refreshSource();
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public ImmutableMap<String, Object> meta() {
        return this.meta;
    }

    public CompressedString mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.rootObjectMapper;
    }

    public UidFieldMapper uidMapper() {
        return this.rootMapper(UidFieldMapper.class);
    }

    public <T extends RootMapper> T rootMapper(Class<T> type) {
        return (T)this.rootMappers.get(type);
    }

    public TypeFieldMapper typeMapper() {
        return this.rootMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.rootMapper(SourceFieldMapper.class);
    }

    public AllFieldMapper allFieldMapper() {
        return this.rootMapper(AllFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.rootMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.rootMapper(RoutingFieldMapper.class);
    }

    public ParentFieldMapper parentFieldMapper() {
        return this.rootMapper(ParentFieldMapper.class);
    }

    public TimestampFieldMapper timestampFieldMapper() {
        return this.rootMapper(TimestampFieldMapper.class);
    }

    public TTLFieldMapper TTLFieldMapper() {
        return this.rootMapper(TTLFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.rootMapper(IndexFieldMapper.class);
    }

    public SizeFieldMapper SizeFieldMapper() {
        return this.rootMapper(SizeFieldMapper.class);
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuotedAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    public Filter typeFilter() {
        return this.typeFilter;
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public ImmutableMap<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(BytesReference source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source));
    }

    public ParsedDocument parse(String type, String id, BytesReference source) throws MapperParsingException {
        return this.parse(SourceToParse.source(source).type(type).id(id));
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.parse(source, null);
    }

    public ParsedDocument parse(SourceToParse source, @Nullable ParseListener listener) throws MapperParsingException {
        ParseContext context = this.cache.get();
        if (source.type() != null && !source.type().equals(this.type)) {
            throw new MapperParsingException("Type mismatch, provide type [" + source.type() + "] but mapper is of type [" + this.type + "]");
        }
        source.type(this.type);
        XContentParser parser = source.parser();
        try {
            if (parser == null) {
                parser = XContentHelper.createParser(source.source());
            }
            context.reset(parser, new Document(), source, listener);
            if (this.initMappersAdded) {
                context.setMappingsModified();
                this.initMappersAdded = false;
            }
            int countDownTokens = 0;
            XContentParser.Token token = parser.nextToken();
            if (token != XContentParser.Token.START_OBJECT) {
                throw new MapperParsingException("Malformed content, must start with an object");
            }
            boolean emptyDoc = false;
            token = parser.nextToken();
            if (token == XContentParser.Token.END_OBJECT) {
                emptyDoc = true;
            } else if (token != XContentParser.Token.FIELD_NAME) {
                throw new MapperParsingException("Malformed content, after first object, either the type field or the actual properties should exist");
            }
            if (this.type.equals(parser.currentName())) {
                token = parser.nextToken();
                ++countDownTokens;
            }
            for (RootMapper rootMapper : this.rootMappersOrdered) {
                rootMapper.preParse(context);
            }
            if (!emptyDoc) {
                this.rootObjectMapper.parse(context);
            }
            for (int i = 0; i < countDownTokens; ++i) {
                parser.nextToken();
            }
            if (!context.newFieldMappers().mappers.isEmpty()) {
                this.addFieldMappers(context.newFieldMappers().mappers);
                context.newFieldMappers().mappers.clear();
            }
            if (!context.newObjectMappers().mappers.isEmpty()) {
                this.addObjectMappers(context.newObjectMappers().mappers);
                context.newObjectMappers().mappers.clear();
            }
            for (RootMapper rootMapper : this.rootMappersOrdered) {
                rootMapper.postParse(context);
            }
            for (RootMapper rootMapper : this.rootMappersOrdered) {
                rootMapper.validate(context);
            }
        }
        catch (Throwable e) {
            if (!context.newFieldMappers().mappers.isEmpty()) {
                this.addFieldMappers(context.newFieldMappers().mappers);
                context.newFieldMappers().mappers.clear();
            }
            if (!context.newObjectMappers().mappers.isEmpty()) {
                this.addObjectMappers(context.newObjectMappers().mappers);
                context.newObjectMappers().mappers.clear();
            }
            if (e instanceof MapperParsingException) {
                throw (MapperParsingException)e;
            }
            if (source.source() != null && source.source().length() == 0) {
                throw new MapperParsingException("failed to parse, document is empty");
            }
            throw new MapperParsingException("failed to parse", e);
        }
        finally {
            if (source.parser() == null && parser != null) {
                parser.close();
            }
        }
        if (context.docs().size() > 1) {
            Collections.reverse(context.docs());
        }
        if (context.docBoost() != 1.0f) {
            HashSet<String> encounteredFields = Sets.newHashSet();
            for (Document doc : context.docs()) {
                encounteredFields.clear();
                for (IndexableField field : doc) {
                    if (!field.fieldType().indexed() || field.fieldType().omitNorms() || encounteredFields.contains(field.name())) continue;
                    ((Field)field).setBoost(context.docBoost() * field.boost());
                    encounteredFields.add(field.name());
                }
            }
        }
        ParsedDocument doc = new ParsedDocument(context.uid(), context.id(), context.type(), source.routing(), source.timestamp(), source.ttl(), context.docs(), context.analyzer(), context.source(), context.mappingsModified()).parent(source.parent());
        context.reset(null, null, null, null);
        return doc;
    }

    private void addFieldMappers(Collection<FieldMapper> fieldMappers) {
        this.addFieldMappers(fieldMappers.toArray(new FieldMapper[fieldMappers.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFieldMappers(FieldMapper ... fieldMappers) {
        Object object = this.mutex;
        synchronized (object) {
            this.fieldMappers = this.fieldMappers.concat(this, fieldMappers);
        }
        for (FieldMapperListener listener : this.fieldMapperListeners) {
            listener.fieldMappers(fieldMappers);
        }
    }

    public void addFieldMapperListener(FieldMapperListener fieldMapperListener, boolean includeExisting) {
        this.fieldMapperListeners.add(fieldMapperListener);
        if (includeExisting) {
            this.traverse(fieldMapperListener);
        }
    }

    public void traverse(FieldMapperListener listener) {
        for (RootMapper rootMapper : this.rootMappersOrdered) {
            if (rootMapper.includeInObject() || !(rootMapper instanceof FieldMapper)) continue;
            listener.fieldMapper((FieldMapper)((Object)rootMapper));
        }
        this.rootObjectMapper.traverse(listener);
    }

    private void addObjectMappers(Collection<ObjectMapper> objectMappers) {
        this.addObjectMappers(objectMappers.toArray(new ObjectMapper[objectMappers.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObjectMappers(ObjectMapper ... objectMappers) {
        Object object = this.mutex;
        synchronized (object) {
            MapBuilder<String, ObjectMapper> builder = MapBuilder.newMapBuilder(this.objectMappers);
            for (ObjectMapper objectMapper : objectMappers) {
                builder.put(objectMapper.fullPath(), objectMapper);
                if (!objectMapper.nested().isNested()) continue;
                this.hasNestedObjects = true;
            }
            this.objectMappers = builder.immutableMap();
        }
        for (ObjectMapperListener objectMapperListener : this.objectMapperListeners) {
            objectMapperListener.objectMappers(objectMappers);
        }
    }

    public void addObjectMapperListener(ObjectMapperListener objectMapperListener, boolean includeExisting) {
        this.objectMapperListeners.add(objectMapperListener);
        if (includeExisting) {
            this.traverse(objectMapperListener);
        }
    }

    public void traverse(ObjectMapperListener listener) {
        this.rootObjectMapper.traverse(listener);
    }

    public synchronized MergeResult merge(DocumentMapper mergeWith, MergeFlags mergeFlags) {
        MergeContext mergeContext = new MergeContext(this, mergeFlags);
        this.rootObjectMapper.merge(mergeWith.rootObjectMapper, mergeContext);
        for (Map.Entry entry : this.rootMappers.entrySet()) {
            RootMapper mergeWithRootMapper;
            if (((RootMapper)entry.getValue()).includeInObject() || (mergeWithRootMapper = mergeWith.rootMappers.get(entry.getKey())) == null) continue;
            ((RootMapper)entry.getValue()).merge(mergeWithRootMapper, mergeContext);
        }
        if (!mergeFlags.simulate()) {
            if (!mergeContext.newFieldMappers().mappers.isEmpty()) {
                this.addFieldMappers(mergeContext.newFieldMappers().mappers);
            }
            if (!mergeContext.newObjectMappers().mappers.isEmpty()) {
                this.addObjectMappers(mergeContext.newObjectMappers().mappers);
            }
            this.meta = mergeWith.meta();
            this.refreshSource();
        }
        return new MergeResult(mergeContext.buildConflicts());
    }

    public void refreshSource() throws FailedToGenerateSourceMapperException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.startObject();
            this.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject();
            this.mappingSource = new CompressedString(builder.bytes());
        }
        catch (Exception e) {
            throw new FailedToGenerateSourceMapperException(e.getMessage(), e);
        }
    }

    public void close() {
        this.cache.remove();
        this.rootObjectMapper.close();
        for (RootMapper rootMapper : this.rootMappersOrdered) {
            rootMapper.close();
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.rootObjectMapper.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (DocumentMapper.this.indexAnalyzer != null && DocumentMapper.this.searchAnalyzer != null && DocumentMapper.this.indexAnalyzer.name().equals(DocumentMapper.this.searchAnalyzer.name()) && !DocumentMapper.this.indexAnalyzer.name().startsWith("_")) {
                    if (!DocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("analyzer", DocumentMapper.this.indexAnalyzer.name());
                    }
                } else {
                    if (DocumentMapper.this.indexAnalyzer != null && !DocumentMapper.this.indexAnalyzer.name().startsWith("_") && !DocumentMapper.this.indexAnalyzer.name().equals("default")) {
                        builder.field("index_analyzer", DocumentMapper.this.indexAnalyzer.name());
                    }
                    if (DocumentMapper.this.searchAnalyzer != null && !DocumentMapper.this.searchAnalyzer.name().startsWith("_") && !DocumentMapper.this.searchAnalyzer.name().equals("default")) {
                        builder.field("search_analyzer", DocumentMapper.this.searchAnalyzer.name());
                    }
                }
                if (DocumentMapper.this.meta != null && !DocumentMapper.this.meta.isEmpty()) {
                    builder.field("_meta", DocumentMapper.this.meta());
                }
                return builder;
            }
        }, this.rootMappersNotIncludedInObject);
        return builder;
    }

    public static class Builder {
        private Map<Class<? extends RootMapper>, RootMapper> rootMappers = new LinkedHashMap<Class<? extends RootMapper>, RootMapper>();
        private NamedAnalyzer indexAnalyzer;
        private NamedAnalyzer searchAnalyzer;
        private NamedAnalyzer searchQuoteAnalyzer;
        private final String index;
        @Nullable
        private final Settings indexSettings;
        private final RootObjectMapper rootObjectMapper;
        private ImmutableMap<String, Object> meta = ImmutableMap.of();
        private final Mapper.BuilderContext builderContext;

        public Builder(String index, @Nullable Settings indexSettings, RootObjectMapper.Builder builder) {
            String idIndexed;
            this.index = index;
            this.indexSettings = indexSettings;
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = (RootObjectMapper)builder.build(this.builderContext);
            IdFieldMapper idFieldMapper = new IdFieldMapper();
            if (indexSettings != null && (idIndexed = indexSettings.get("index.mapping._id.indexed")) != null && Booleans.parseBoolean(idIndexed, false)) {
                FieldType fieldType = new FieldType(IdFieldMapper.Defaults.FIELD_TYPE);
                fieldType.setTokenized(false);
                idFieldMapper = new IdFieldMapper(fieldType);
            }
            this.rootMappers.put(IdFieldMapper.class, idFieldMapper);
            this.rootMappers.put(SizeFieldMapper.class, new SizeFieldMapper());
            this.rootMappers.put(IndexFieldMapper.class, new IndexFieldMapper());
            this.rootMappers.put(SourceFieldMapper.class, new SourceFieldMapper());
            this.rootMappers.put(TypeFieldMapper.class, new TypeFieldMapper());
            this.rootMappers.put(AnalyzerMapper.class, new AnalyzerMapper());
            this.rootMappers.put(AllFieldMapper.class, new AllFieldMapper());
            this.rootMappers.put(BoostFieldMapper.class, new BoostFieldMapper());
            this.rootMappers.put(RoutingFieldMapper.class, new RoutingFieldMapper());
            this.rootMappers.put(TimestampFieldMapper.class, new TimestampFieldMapper());
            this.rootMappers.put(TTLFieldMapper.class, new TTLFieldMapper());
            this.rootMappers.put(UidFieldMapper.class, new UidFieldMapper());
        }

        public Builder meta(ImmutableMap<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(Mapper.Builder mapper) {
            RootMapper rootMapper = (RootMapper)mapper.build(this.builderContext);
            this.rootMappers.put(rootMapper.getClass(), rootMapper);
            return this;
        }

        public Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            this.indexAnalyzer = indexAnalyzer;
            return this;
        }

        public boolean hasIndexAnalyzer() {
            return this.indexAnalyzer != null;
        }

        public Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            this.searchAnalyzer = searchAnalyzer;
            if (this.searchQuoteAnalyzer == null) {
                this.searchQuoteAnalyzer = searchAnalyzer;
            }
            return this;
        }

        public Builder searchQuoteAnalyzer(NamedAnalyzer searchQuoteAnalyzer) {
            this.searchQuoteAnalyzer = searchQuoteAnalyzer;
            return this;
        }

        public boolean hasSearchAnalyzer() {
            return this.searchAnalyzer != null;
        }

        public boolean hasSearchQuoteAnalyzer() {
            return this.searchQuoteAnalyzer != null;
        }

        public DocumentMapper build(DocumentMapperParser docMapperParser) {
            Preconditions.checkNotNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            return new DocumentMapper(this.index, this.indexSettings, docMapperParser, this.rootObjectMapper, this.meta, this.indexAnalyzer, this.searchAnalyzer, this.searchQuoteAnalyzer, this.rootMappers);
        }
    }

    public static class ParseListenerAdapter
    implements ParseListener {
        public boolean beforeFieldAdded(FieldMapper fieldMapper, Field fieldable, Object parseContext) {
            return true;
        }
    }

    public static interface ParseListener<ParseContext> {
        public static final ParseListener EMPTY = new ParseListenerAdapter();

        public boolean beforeFieldAdded(FieldMapper var1, Field var2, ParseContext var3);
    }

    public static class MergeFlags {
        private boolean simulate = true;

        public static MergeFlags mergeFlags() {
            return new MergeFlags();
        }

        public boolean simulate() {
            return this.simulate;
        }

        public MergeFlags simulate(boolean simulate) {
            this.simulate = simulate;
            return this;
        }
    }

    public static class MergeResult {
        private final String[] conflicts;

        public MergeResult(String[] conflicts) {
            this.conflicts = conflicts;
        }

        public boolean hasConflicts() {
            return this.conflicts.length > 0;
        }

        public String[] conflicts() {
            return this.conflicts;
        }
    }
}

