/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.ObjectMapperListener;

public class MergeContext {
    private final DocumentMapper documentMapper;
    private final DocumentMapper.MergeFlags mergeFlags;
    private final List<String> mergeConflicts = Lists.newArrayList();
    private final FieldMapperListener.Aggregator newFieldMappers = new FieldMapperListener.Aggregator();
    private final ObjectMapperListener.Aggregator newObjectMappers = new ObjectMapperListener.Aggregator();
    private List<FieldMapper> fieldDataChanges = null;

    public MergeContext(DocumentMapper documentMapper, DocumentMapper.MergeFlags mergeFlags) {
        this.documentMapper = documentMapper;
        this.mergeFlags = mergeFlags;
    }

    public DocumentMapper docMapper() {
        return this.documentMapper;
    }

    public DocumentMapper.MergeFlags mergeFlags() {
        return this.mergeFlags;
    }

    public FieldMapperListener.Aggregator newFieldMappers() {
        return this.newFieldMappers;
    }

    public ObjectMapperListener.Aggregator newObjectMappers() {
        return this.newObjectMappers;
    }

    public void addConflict(String mergeFailure) {
        this.mergeConflicts.add(mergeFailure);
    }

    public boolean hasConflicts() {
        return !this.mergeConflicts.isEmpty();
    }

    public String[] buildConflicts() {
        return this.mergeConflicts.toArray(new String[this.mergeConflicts.size()]);
    }

    public void addFieldDataChange(FieldMapper mapper) {
        if (this.fieldDataChanges == null) {
            this.fieldDataChanges = new ArrayList<FieldMapper>();
        }
        this.fieldDataChanges.add(mapper);
    }

    public List<FieldMapper> fieldMapperChanges() {
        if (this.fieldDataChanges == null) {
            return Collections.emptyList();
        }
        return this.fieldDataChanges;
    }
}

