/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.Joda;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericDateAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class DateFieldMapper
extends NumberFieldMapper<Long> {
    public static final String CONTENT_TYPE = "date";
    protected final FormatDateTimeFormatter dateTimeFormatter;
    private final boolean parseUpperInclusive;
    private final DateMathParser dateMathParser;
    private String nullValue;
    protected final TimeUnit timeUnit;

    public static Locale parseLocale(String locale) {
        String[] parts = locale.split("_", -1);
        switch (parts.length) {
            case 3: {
                return new Locale(parts[0], parts[1], parts[2]);
            }
            case 2: {
                return new Locale(parts[0], parts[1]);
            }
            case 1: {
                if ("ROOT".equalsIgnoreCase(parts[0])) {
                    return Locale.ROOT;
                }
                return new Locale(parts[0]);
            }
        }
        throw new ElasticSearchIllegalArgumentException("Can't parse locale: [" + locale + "]");
    }

    protected DateFieldMapper(FieldMapper.Names names, FormatDateTimeFormatter dateTimeFormatter, int precisionStep, float boost, FieldType fieldType, String nullValue, TimeUnit timeUnit, boolean parseUpperInclusive, Explicit<Boolean> ignoreMalformed, PostingsFormatProvider provider, SimilarityProvider similarity, @Nullable Settings fieldDataSettings) {
        super(names, precisionStep, boost, fieldType, ignoreMalformed, new NamedAnalyzer("_date/" + precisionStep, new NumericDateAnalyzer(precisionStep, dateTimeFormatter.parser())), new NamedAnalyzer("_date/max", new NumericDateAnalyzer(Integer.MAX_VALUE, dateTimeFormatter.parser())), provider, similarity, fieldDataSettings);
        this.dateTimeFormatter = dateTimeFormatter;
        this.nullValue = nullValue;
        this.timeUnit = timeUnit;
        this.parseUpperInclusive = parseUpperInclusive;
        this.dateMathParser = new DateMathParser(dateTimeFormatter, timeUnit);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("long");
    }

    @Override
    protected int maxPrecisionStep() {
        return 64;
    }

    @Override
    public Long value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return Numbers.bytesToLong((BytesRef)value);
        }
        return this.parseStringValue(value.toString());
    }

    @Override
    public Object valueForSearch(Object value) {
        if (value instanceof String) {
            return value;
        }
        Long val = this.value(value);
        if (val == null) {
            return null;
        }
        return this.dateTimeFormatter.printer().print(val);
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        BytesRef bytesRef = new BytesRef();
        NumericUtils.longToPrefixCoded((long)this.parseValue(value), (int)0, (BytesRef)bytesRef);
        return bytesRef;
    }

    private long parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof BytesRef) {
            return this.dateTimeFormatter.parser().parseMillis(((BytesRef)value).utf8ToString());
        }
        return this.dateTimeFormatter.parser().parseMillis(value.toString());
    }

    private String convertToString(Object value) {
        if (value instanceof BytesRef) {
            return ((BytesRef)value).utf8ToString();
        }
        return value.toString();
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions, boolean transpositions) {
        long iSim;
        long iValue = this.dateMathParser.parse(value, System.currentTimeMillis());
        try {
            iSim = TimeValue.parseTimeValue(minSim, null).millis();
        }
        catch (Exception e) {
            iSim = (long)Double.parseDouble(minSim);
        }
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(iValue - iSim), (Long)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        long lValue = this.dateMathParser.parse(this.convertToString(value), now);
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        long lValue = this.dateMathParser.parse(this.convertToString(value), now);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)lValue, (Long)lValue, (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeQuery.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(this.convertToString(lowerTerm), now))), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(this.convertToString(upperTerm), now) : this.dateMathParser.parse(this.convertToString(upperTerm), now)), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)(lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(this.convertToString(lowerTerm), now))), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(this.convertToString(upperTerm), now) : this.dateMathParser.parse(this.convertToString(upperTerm), now)), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(IndexFieldDataService fieldData, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        long now = context == null ? System.currentTimeMillis() : context.nowInMillis();
        return NumericRangeFieldDataFilter.newLongRange((IndexNumericFieldData)fieldData.getForField(this), lowerTerm == null ? null : Long.valueOf(this.dateMathParser.parse(this.convertToString(lowerTerm), now)), upperTerm == null ? null : Long.valueOf(includeUpper && this.parseUpperInclusive ? this.dateMathParser.parseUpperInclusive(this.convertToString(upperTerm), now) : this.dateMathParser.parse(this.convertToString(upperTerm), now)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        long value = this.parseStringValue(this.nullValue);
        return NumericRangeFilter.newLongRange((String)this.names.indexName(), (int)this.precisionStep, (Long)value, (Long)value, (boolean)true, (boolean)true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException {
        LongFieldMapper.CustomLongNumericField field;
        String dateAsString = null;
        Long value = null;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue instanceof Number) {
                value = ((Number)externalValue).longValue();
            } else {
                dateAsString = (String)externalValue;
                if (dateAsString == null) {
                    dateAsString = this.nullValue;
                }
            }
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token token = parser.currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                dateAsString = this.nullValue;
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                value = parser.longValue();
            } else if (token == XContentParser.Token.START_OBJECT) {
                String currentFieldName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (token == XContentParser.Token.VALUE_NULL) {
                            dateAsString = this.nullValue;
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            value = parser.longValue();
                            continue;
                        }
                        dateAsString = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
            } else {
                dateAsString = parser.text();
            }
        }
        if (value != null) {
            field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, this.timeUnit.toMillis(value), this.fieldType);
            field.setBoost(boost);
            return field;
        }
        if (dateAsString == null) {
            return null;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.names.fullName(), dateAsString, boost);
        }
        value = this.parseStringValue(dateAsString);
        field = new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, value, this.fieldType);
        field.setBoost(boost);
        return field;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((DateFieldMapper)mergeWith).nullValue;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        builder.field("format", this.dateTimeFormatter.format());
        if (this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
        if (this.timeUnit != Defaults.TIME_UNIT) {
            builder.field("numeric_resolution", this.timeUnit.name().toLowerCase(Locale.ROOT));
        }
        if (this.dateTimeFormatter.locale() != null) {
            builder.field("locale", (Object)this.dateTimeFormatter.locale());
        }
    }

    private long parseStringValue(String value) {
        try {
            return this.dateTimeFormatter.parser().parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new MapperParsingException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number with locale [" + this.dateTimeFormatter.locale() + "]", e);
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.dateField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    builder.nullValue(propNode.toString());
                    continue;
                }
                if (propName.equals("format")) {
                    builder.dateTimeFormatter(TypeParsers.parseDateTimeFormatter(propName, propNode));
                    continue;
                }
                if (propName.equals("numeric_resolution")) {
                    builder.timeUnit(TimeUnit.valueOf(propNode.toString().toUpperCase(Locale.ROOT)));
                    continue;
                }
                if (!propName.equals("locale")) continue;
                builder.locale(DateFieldMapper.parseLocale(propNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, DateFieldMapper> {
        protected TimeUnit timeUnit = Defaults.TIME_UNIT;
        protected String nullValue = Defaults.NULL_VALUE;
        protected FormatDateTimeFormatter dateTimeFormatter = Defaults.DATE_TIME_FORMATTER;
        private Locale locale;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder nullValue(String nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        public Builder dateTimeFormatter(FormatDateTimeFormatter dateTimeFormatter) {
            this.dateTimeFormatter = dateTimeFormatter;
            return this;
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            boolean parseUpperInclusive = true;
            if (context.indexSettings() != null) {
                parseUpperInclusive = context.indexSettings().getAsBoolean("index.mapping.date.parse_upper_inclusive", (Boolean)true);
            }
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            if (this.locale != null && !this.locale.equals(this.dateTimeFormatter.locale())) {
                this.dateTimeFormatter = new FormatDateTimeFormatter(this.dateTimeFormatter.format(), this.dateTimeFormatter.parser(), this.dateTimeFormatter.printer(), this.locale);
            }
            DateFieldMapper fieldMapper = new DateFieldMapper(this.buildNames(context), this.dateTimeFormatter, this.precisionStep, this.boost, this.fieldType, this.nullValue, this.timeUnit, parseUpperInclusive, this.ignoreMalformed(context), this.provider, this.similarity, this.fieldDataSettings);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FormatDateTimeFormatter DATE_TIME_FORMATTER = Joda.forPattern("dateOptionalTime");
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final String NULL_VALUE;
        public static final TimeUnit TIME_UNIT;
        public static final boolean PARSE_UPPER_INCLUSIVE = true;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
            TIME_UNIT = TimeUnit.MILLISECONDS;
        }
    }
}

