/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.internal.AllFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.similarity.SimilarityProvider;

public abstract class NumberFieldMapper<T extends Number>
extends AbstractFieldMapper<T>
implements AllFieldMapper.IncludeInAll {
    protected int precisionStep;
    protected Boolean includeInAll;
    protected Explicit<Boolean> ignoreMalformed;
    private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(NumberFieldMapper.this.precisionStep);
        }
    };

    protected NumberFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Explicit<Boolean> ignoreMalformed, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider provider, SimilarityProvider similarity, @Nullable Settings fieldDataSettings) {
        super(names, boost, fieldType, indexAnalyzer, searchAnalyzer, provider, similarity, fieldDataSettings);
        this.precisionStep = precisionStep <= 0 || precisionStep >= this.maxPrecisionStep() ? Integer.MAX_VALUE : precisionStep;
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    protected abstract int maxPrecisionStep();

    public int precisionStep() {
        return this.precisionStep;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        RuntimeException e;
        try {
            return this.innerParseCreateField(context);
        }
        catch (IllegalArgumentException e1) {
            e = e1;
        }
        catch (MapperParsingException e2) {
            e = e2;
        }
        if (this.ignoreMalformed.value().booleanValue()) {
            return null;
        }
        throw e;
    }

    protected abstract Field innerParseCreateField(ParseContext var1) throws IOException;

    @Override
    public boolean useTermQueryWithQueryString() {
        return true;
    }

    @Override
    public Query termQuery(Object value, @Nullable QueryParseContext context) {
        return this.rangeQuery(value, value, true, true, context);
    }

    @Override
    public Filter termFilter(Object value, @Nullable QueryParseContext context) {
        return this.rangeFilter(value, value, true, true, context);
    }

    @Override
    public abstract Query rangeQuery(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Filter rangeFilter(Object var1, Object var2, boolean var3, boolean var4, @Nullable QueryParseContext var5);

    @Override
    public abstract Query fuzzyQuery(String var1, String var2, int var3, int var4, boolean var5);

    public abstract Filter rangeFilter(IndexFieldDataService var1, Object var2, Object var3, boolean var4, boolean var5, @Nullable QueryParseContext var6);

    @Override
    public Object valueForSearch(Object value) {
        return this.value(value);
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            NumberFieldMapper nfmMergeWith = (NumberFieldMapper)mergeWith;
            this.precisionStep = nfmMergeWith.precisionStep;
            this.includeInAll = nfmMergeWith.includeInAll;
            if (nfmMergeWith.ignoreMalformed.explicit()) {
                this.ignoreMalformed = nfmMergeWith.ignoreMalformed;
            }
        }
    }

    @Override
    public void close() {
        this.tokenStream.remove();
    }

    protected NumericTokenStream popCachedStream() {
        return this.tokenStream.get();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", (Object)this.ignoreMalformed.value());
        }
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    public static abstract class CustomNumericField
    extends Field {
        protected final NumberFieldMapper mapper;

        public CustomNumericField(NumberFieldMapper mapper, Number value, FieldType fieldType) {
            super(mapper.names().indexName(), fieldType);
            this.mapper = mapper;
            if (value != null) {
                this.fieldsData = value;
            }
        }

        public String stringValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }

        public abstract String numericAsString();
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends AbstractFieldMapper.Builder<T, Y> {
        protected int precisionStep = 4;
        private Boolean ignoreMalformed;

        public Builder(String name, FieldType fieldType) {
            super(name, fieldType);
        }

        @Override
        public T store(boolean store) {
            return (T)((Builder)super.store(store));
        }

        @Override
        public T boost(float boost) {
            return (T)((Builder)super.boost(boost));
        }

        @Override
        public T indexName(String indexName) {
            return (T)((Builder)super.indexName(indexName));
        }

        @Override
        public T includeInAll(Boolean includeInAll) {
            return (T)((Builder)super.includeInAll(includeInAll));
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (T)((Builder)this.builder);
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(context.indexSettings().getAsBoolean("index.mapping.ignore_malformed", Defaults.IGNORE_MALFORMED.value()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final int PRECISION_STEP = 4;
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final Explicit<Boolean> IGNORE_MALFORMED;

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.freeze();
            IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        }
    }
}

