/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.shape.Shape;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.GeoJSONShapeParser;
import org.elasticsearch.common.geo.GeoShapeConstants;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;

public class GeoShapeFieldMapper
extends AbstractFieldMapper<String> {
    public static final String CONTENT_TYPE = "geo_shape";
    private final PrefixTreeStrategy defaultStrategy;
    private final RecursivePrefixTreeStrategy recursiveStrategy;
    private final TermQueryPrefixTreeStrategy termStrategy;

    private static final int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
        if (treeLevels > 0 || precisionInMeters >= 0.0) {
            return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
        }
        return defaultLevels;
    }

    public GeoShapeFieldMapper(FieldMapper.Names names, SpatialPrefixTree tree, String defaultStrategyName, double distanceErrorPct, FieldType fieldType, PostingsFormatProvider provider) {
        super(names, 1.0f, fieldType, null, null, provider, null, null);
        this.recursiveStrategy = new RecursivePrefixTreeStrategy(tree, names.indexName());
        this.recursiveStrategy.setDistErrPct(distanceErrorPct);
        this.termStrategy = new TermQueryPrefixTreeStrategy(tree, names.indexName());
        this.termStrategy.setDistErrPct(distanceErrorPct);
        this.defaultStrategy = this.resolveStrategy(defaultStrategyName);
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Shape shape = GeoJSONShapeParser.parse(context.parser());
            Field[] fields = this.defaultStrategy.createIndexableFields(shape);
            if (fields == null || fields.length == 0) {
                return;
            }
            for (Field field : fields) {
                if (!this.customBoost()) {
                    field.setBoost(this.boost);
                }
                if (!context.listener().beforeFieldAdded(this, field, context)) continue;
                context.doc().add((IndexableField)field);
            }
        }
        catch (Exception e) {
            throw new MapperParsingException("failed to parse [" + this.names.fullName() + "]", e);
        }
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        builder.field("type", this.contentType());
        if (this.defaultStrategy.getGrid() instanceof GeohashPrefixTree) {
            if (this.defaultStrategy.getGrid().getMaxLevels() != Defaults.GEOHASH_LEVELS) {
                builder.field("tree_levels", this.defaultStrategy.getGrid().getMaxLevels());
            }
        } else {
            builder.field("tree", "quadtree");
            if (this.defaultStrategy.getGrid().getMaxLevels() != Defaults.QUADTREE_LEVELS) {
                builder.field("tree_levels", this.defaultStrategy.getGrid().getMaxLevels());
            }
        }
        if (this.defaultStrategy.getDistErrPct() != 0.025) {
            builder.field("distance_error_pct", this.defaultStrategy.getDistErrPct());
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public String value(Object value) {
        throw new UnsupportedOperationException("GeoShape fields cannot be converted to String values");
    }

    public PrefixTreeStrategy defaultStrategy() {
        return this.defaultStrategy;
    }

    public PrefixTreeStrategy recursiveStrategy() {
        return this.recursiveStrategy;
    }

    public PrefixTreeStrategy termStrategy() {
        return this.termStrategy;
    }

    public PrefixTreeStrategy resolveStrategy(String strategyName) {
        if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
            return this.recursiveStrategy;
        }
        if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
            return this.termStrategy;
        }
        throw new ElasticSearchIllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if ("tree".equals(fieldName)) {
                    builder.tree(fieldNode.toString());
                    continue;
                }
                if ("tree_levels".equals(fieldName)) {
                    builder.treeLevels(Integer.parseInt(fieldNode.toString()));
                    continue;
                }
                if ("precision".equals(fieldName)) {
                    builder.treeLevelsByDistance(DistanceUnit.parse(fieldNode.toString(), DistanceUnit.METERS, DistanceUnit.METERS));
                    continue;
                }
                if ("distance_error_pct".equals(fieldName)) {
                    builder.distanceErrorPct(Double.parseDouble(fieldNode.toString()));
                    continue;
                }
                if (!"strategy".equals(fieldName)) continue;
                builder.strategy(fieldNode.toString());
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, GeoShapeFieldMapper> {
        private String tree = "geohash";
        private String strategyName = Defaults.STRATEGY;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private double distanceErrorPct = 0.025;
        private SpatialPrefixTree prefixTree;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
        }

        public Builder tree(String tree) {
            this.tree = tree;
            return this;
        }

        public Builder strategy(String strategy) {
            this.strategyName = strategy;
            return this;
        }

        public Builder treeLevelsByDistance(double meters) {
            this.precisionInMeters = meters;
            return this;
        }

        public Builder treeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
            return this;
        }

        public Builder distanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
            return this;
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            FieldMapper.Names names = this.buildNames(context);
            if ("geohash".equals(this.tree)) {
                this.prefixTree = new GeohashPrefixTree((SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT, GeoShapeFieldMapper.getLevels(this.treeLevels, this.precisionInMeters, Defaults.GEOHASH_LEVELS, true));
            } else if ("quadtree".equals(this.tree)) {
                this.prefixTree = new QuadPrefixTree((SpatialContext)GeoShapeConstants.SPATIAL_CONTEXT, GeoShapeFieldMapper.getLevels(this.treeLevels, this.precisionInMeters, Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new ElasticSearchIllegalArgumentException("Unknown prefix tree type [" + this.tree + "]");
            }
            return new GeoShapeFieldMapper(names, this.prefixTree, this.strategyName, this.distanceErrorPct, this.fieldType, this.provider);
        }
    }

    public static class Defaults {
        public static final String TREE = "geohash";
        public static final String STRATEGY = SpatialStrategy.RECURSIVE.getStrategyName();
        public static final int GEOHASH_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
        public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
        public static final double DISTANCE_ERROR_PCT = 0.025;
        public static final FieldType FIELD_TYPE = new FieldType();

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setStoreTermVectors(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
        }
    }

    public static class Names {
        public static final String TREE = "tree";
        public static final String TREE_GEOHASH = "geohash";
        public static final String TREE_QUADTREE = "quadtree";
        public static final String TREE_LEVELS = "tree_levels";
        public static final String TREE_PRESISION = "precision";
        public static final String DISTANCE_ERROR_PCT = "distance_error_pct";
        public static final String STRATEGY = "strategy";
    }
}

