/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.IntegerFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;

public class SizeFieldMapper
extends IntegerFieldMapper
implements RootMapper {
    public static final String NAME = "_size";
    public static final String CONTENT_TYPE = "_size";
    private EnabledAttributeMapper enabledState;

    public SizeFieldMapper() {
        this(Defaults.ENABLED_STATE, new FieldType(Defaults.SIZE_FIELD_TYPE), null, null);
    }

    public SizeFieldMapper(EnabledAttributeMapper enabled, FieldType fieldType, PostingsFormatProvider provider, @Nullable Settings fieldDataSettings) {
        super(new FieldMapper.Names("_size"), 4, 1.0f, fieldType, Defaults.NULL_VALUE, Defaults.IGNORE_MALFORMED, provider, null, fieldDataSettings);
        this.enabledState = enabled;
    }

    @Override
    protected String contentType() {
        return "_size";
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException {
        if (!this.enabledState.enabled) {
            return null;
        }
        if (context.flyweight()) {
            return null;
        }
        return new IntegerFieldMapper.CustomIntegerNumericField((NumberFieldMapper)this, context.source().length(), this.fieldType);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabledState == Defaults.ENABLED_STATE && this.fieldType().stored() == Defaults.SIZE_FIELD_TYPE.stored()) {
            return builder;
        }
        builder.startObject(this.contentType());
        if (this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (this.fieldType().stored() != Defaults.SIZE_FIELD_TYPE.stored() && this.enabledState.enabled) {
            builder.field("store", this.fieldType().stored());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        SizeFieldMapper sizeFieldMapperMergeWith = (SizeFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && sizeFieldMapperMergeWith.enabledState != this.enabledState && !sizeFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = sizeFieldMapperMergeWith.enabledState;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED);
                    continue;
                }
                if (!fieldName.equals("store")) continue;
                builder.store(TypeParsers.parseStore(fieldName, fieldNode.toString()));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IntegerFieldMapper> {
        protected EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;

        public Builder() {
            super("_size", new FieldType(Defaults.SIZE_FIELD_TYPE));
            this.builder = this;
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        @Override
        public Builder store(boolean store) {
            this.fieldType.setStored(store);
            return (Builder)this.builder;
        }

        @Override
        public SizeFieldMapper build(Mapper.BuilderContext context) {
            return new SizeFieldMapper(this.enabledState, this.fieldType, this.provider, this.fieldDataSettings);
        }
    }

    public static class Defaults
    extends IntegerFieldMapper.Defaults {
        public static final String NAME = "_size";
        public static final EnabledAttributeMapper ENABLED_STATE = EnabledAttributeMapper.DISABLED;
        public static final FieldType SIZE_FIELD_TYPE = new FieldType(IntegerFieldMapper.Defaults.FIELD_TYPE);

        static {
            SIZE_FIELD_TYPE.freeze();
        }
    }
}

