/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.AlreadyExpiredException;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.LongFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;
import org.elasticsearch.search.internal.SearchContext;

public class TTLFieldMapper
extends LongFieldMapper
implements InternalMapper,
RootMapper {
    public static final String NAME = "_ttl";
    public static final String CONTENT_TYPE = "_ttl";
    private EnabledAttributeMapper enabledState;
    private long defaultTTL;

    public TTLFieldMapper() {
        this(new FieldType(Defaults.TTL_FIELD_TYPE), Defaults.ENABLED_STATE, -1L, Defaults.IGNORE_MALFORMED, null, null);
    }

    protected TTLFieldMapper(FieldType fieldType, EnabledAttributeMapper enabled, long defaultTTL, Explicit<Boolean> ignoreMalformed, PostingsFormatProvider provider, @Nullable Settings fieldDataSettings) {
        super(new FieldMapper.Names("_ttl", "_ttl", "_ttl", "_ttl"), 4, 1.0f, fieldType, Defaults.NULL_VALUE, ignoreMalformed, provider, null, fieldDataSettings);
        this.enabledState = enabled;
        this.defaultTTL = defaultTTL;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public long defaultTTL() {
        return this.defaultTTL;
    }

    @Override
    public Object valueForSearch(Object value) {
        SearchContext searchContext = SearchContext.current();
        long now = searchContext != null ? searchContext.nowInMillis() : System.currentTimeMillis();
        long val = this.value(value);
        return val - now;
    }

    public Object valueForSearch(long expirationTime) {
        return expirationTime - System.currentTimeMillis();
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException, MapperParsingException {
        if (context.sourceToParse().ttl() < 0L) {
            long ttl = context.parser().currentToken() == XContentParser.Token.VALUE_STRING ? TimeValue.parseTimeValue(context.parser().text(), null).millis() : context.parser().longValue();
            if (ttl <= 0L) {
                throw new MapperParsingException("TTL value must be > 0. Illegal value provided [" + ttl + "]");
            }
            context.sourceToParse().ttl(ttl);
        }
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Field innerParseCreateField(ParseContext context) throws IOException, AlreadyExpiredException {
        if (this.enabledState.enabled && !context.sourceToParse().flyweight()) {
            long ttl = context.sourceToParse().ttl();
            if (ttl <= 0L && this.defaultTTL > 0L) {
                ttl = this.defaultTTL;
                context.sourceToParse().ttl(ttl);
            }
            if (ttl > 0L) {
                long timestamp = context.sourceToParse().timestamp();
                long expire = new Date(timestamp + ttl).getTime();
                long now = System.currentTimeMillis();
                if (now >= expire) {
                    throw new AlreadyExpiredException(context.index(), context.type(), context.id(), timestamp, ttl, now);
                }
                return new LongFieldMapper.CustomLongNumericField((NumberFieldMapper)this, expire, this.fieldType);
            }
        }
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabledState == Defaults.ENABLED_STATE && this.defaultTTL == -1L) {
            return builder;
        }
        builder.startObject("_ttl");
        if (this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (this.defaultTTL != -1L && this.enabledState.enabled) {
            builder.field("default", this.defaultTTL);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        TTLFieldMapper ttlMergeWith = (TTLFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate()) {
            if (ttlMergeWith.defaultTTL != -1L) {
                this.defaultTTL = ttlMergeWith.defaultTTL;
            }
            if (ttlMergeWith.enabledState != this.enabledState && !ttlMergeWith.enabledState.unset()) {
                this.enabledState = ttlMergeWith.enabledState;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                TimeValue ttlTimeValue;
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    EnabledAttributeMapper enabledState = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                    builder.enabled(enabledState);
                    continue;
                }
                if (!fieldName.equals("default") || (ttlTimeValue = XContentMapValues.nodeTimeValue(fieldNode, null)) == null) continue;
                builder.defaultTTL(ttlTimeValue.millis());
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, TTLFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;
        private long defaultTTL = -1L;

        public Builder() {
            super("_ttl", new FieldType(Defaults.TTL_FIELD_TYPE));
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabledState = enabled;
            return (Builder)this.builder;
        }

        public Builder defaultTTL(long defaultTTL) {
            this.defaultTTL = defaultTTL;
            return (Builder)this.builder;
        }

        @Override
        public TTLFieldMapper build(Mapper.BuilderContext context) {
            return new TTLFieldMapper(this.fieldType, this.enabledState, this.defaultTTL, this.ignoreMalformed(context), this.provider, this.fieldDataSettings);
        }
    }

    public static class Defaults
    extends LongFieldMapper.Defaults {
        public static final String NAME = "_ttl";
        public static final FieldType TTL_FIELD_TYPE = new FieldType(LongFieldMapper.Defaults.FIELD_TYPE);
        public static final EnabledAttributeMapper ENABLED_STATE;
        public static final long DEFAULT = -1L;

        static {
            TTL_FIELD_TYPE.setStored(true);
            TTL_FIELD_TYPE.setIndexed(true);
            TTL_FIELD_TYPE.setTokenized(false);
            TTL_FIELD_TYPE.freeze();
            ENABLED_STATE = EnabledAttributeMapper.DISABLED;
        }
    }
}

