/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class FuzzyQueryParser
implements QueryParser {
    public static final String NAME = "fuzzy";

    @Inject
    public FuzzyQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new QueryParsingException(parseContext.index(), "[fuzzy] query malformed, no field");
        }
        String fieldName = parser.currentName();
        String value = null;
        float boost = 1.0f;
        String minSimilarity = "0.5";
        int prefixLength = 0;
        int maxExpansions = 50;
        boolean transpositions = false;
        MultiTermQuery.RewriteMethod rewriteMethod = null;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if ("term".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("boost".equals(currentFieldName)) {
                    boost = parser.floatValue();
                    continue;
                }
                if ("min_similarity".equals(currentFieldName) || "minSimilarity".equals(currentFieldName)) {
                    minSimilarity = parser.text();
                    continue;
                }
                if ("prefix_length".equals(currentFieldName) || "prefixLength".equals(currentFieldName)) {
                    prefixLength = parser.intValue();
                    continue;
                }
                if ("max_expansions".equals(currentFieldName) || "maxExpansions".equals(currentFieldName)) {
                    maxExpansions = parser.intValue();
                    continue;
                }
                if ("transpositions".equals(currentFieldName)) {
                    transpositions = parser.booleanValue();
                    continue;
                }
                if ("rewrite".equals(currentFieldName)) {
                    rewriteMethod = QueryParsers.parseRewriteMethod(parser.textOrNull(), null);
                    continue;
                }
                throw new QueryParsingException(parseContext.index(), "[fuzzy] query does not support [" + currentFieldName + "]");
            }
            parser.nextToken();
        } else {
            value = parser.text();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(parseContext.index(), "No value specified for fuzzy query");
        }
        Query query = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            query = smartNameFieldMappers.mapper().fuzzyQuery(value, minSimilarity, prefixLength, maxExpansions, transpositions);
        }
        if (query == null) {
            int edits = FuzzyQuery.floatToEdits((float)Float.parseFloat(minSimilarity), (int)value.codePointCount(0, value.length()));
            query = new FuzzyQuery(new Term(fieldName, value), edits, prefixLength, maxExpansions, transpositions);
        }
        if (query instanceof MultiTermQuery) {
            QueryParsers.setRewriteMethod((MultiTermQuery)query, rewriteMethod);
        }
        query.setBoost(boost);
        return QueryParsers.wrapSmartNameQuery(query, smartNameFieldMappers, parseContext);
    }
}

