/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.TermRangeFilter;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.search.NotFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;

public class MissingFilterParser
implements FilterParser {
    public static final String NAME = "missing";

    @Inject
    public MissingFilterParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Filter parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        Filter filter;
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        String filterName = null;
        boolean nullValue = false;
        boolean existence = true;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(currentFieldName)) {
                fieldName = parser.text();
                continue;
            }
            if ("null_value".equals(currentFieldName)) {
                nullValue = parser.booleanValue();
                continue;
            }
            if ("existence".equals(currentFieldName)) {
                existence = parser.booleanValue();
                continue;
            }
            if ("_name".equals(currentFieldName)) {
                filterName = parser.text();
                continue;
            }
            throw new QueryParsingException(parseContext.index(), "[missing] filter does not support [" + currentFieldName + "]");
        }
        if (fieldName == null) {
            throw new QueryParsingException(parseContext.index(), "missing must be provided with a [field]");
        }
        if (!existence && !nullValue) {
            throw new QueryParsingException(parseContext.index(), "missing must have either existence, or null_value, or both set to true");
        }
        Filter existenceFilter = null;
        Filter nullFilter = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (existence) {
            if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
                existenceFilter = smartNameFieldMappers.mapper().rangeFilter(null, null, true, true, parseContext);
            }
            if (existenceFilter == null) {
                existenceFilter = new TermRangeFilter(fieldName, null, null, true, true);
            }
            existenceFilter = parseContext.cacheFilter(existenceFilter, null);
            existenceFilter = new NotFilter(existenceFilter);
            existenceFilter = parseContext.cacheFilter(existenceFilter, null);
        }
        if (nullValue && smartNameFieldMappers != null && smartNameFieldMappers.hasMapper() && (nullFilter = smartNameFieldMappers.mapper().nullValueFilter()) != null) {
            nullFilter = parseContext.cacheFilter(nullFilter, null);
        }
        if (nullFilter != null) {
            if (existenceFilter != null) {
                XBooleanFilter combined = new XBooleanFilter();
                combined.add(existenceFilter, BooleanClause.Occur.SHOULD);
                combined.add(nullFilter, BooleanClause.Occur.SHOULD);
                filter = parseContext.cacheFilter(combined, null);
            } else {
                filter = nullFilter;
            }
        } else {
            filter = existenceFilter;
        }
        if (filter == null) {
            return null;
        }
        filter = QueryParsers.wrapSmartNameFilter(filter, smartNameFieldMappers, parseContext);
        if (filterName != null) {
            parseContext.addNamedFilter(filterName, existenceFilter);
        }
        return filter;
    }
}

