/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class NestedQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<NestedQueryBuilder> {
    private final QueryBuilder queryBuilder;
    private final FilterBuilder filterBuilder;
    private final String path;
    private String scoreMode;
    private float boost = 1.0f;

    public NestedQueryBuilder(String path, QueryBuilder queryBuilder) {
        this.path = path;
        this.queryBuilder = queryBuilder;
        this.filterBuilder = null;
    }

    public NestedQueryBuilder(String path, FilterBuilder filterBuilder) {
        this.path = path;
        this.queryBuilder = null;
        this.filterBuilder = filterBuilder;
    }

    public NestedQueryBuilder scoreMode(String scoreMode) {
        this.scoreMode = scoreMode;
        return this;
    }

    @Override
    public NestedQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nested");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        } else {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        builder.field("path", this.path);
        if (this.scoreMode != null) {
            builder.field("score_mode", this.scoreMode);
        }
        if (this.boost != 1.0f) {
            builder.field("boost", this.boost);
        }
        builder.endObject();
    }
}

