/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import com.spatial4j.core.shape.Shape;
import java.util.Collection;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.BoostingQueryBuilder;
import org.elasticsearch.index.query.CommonTermsQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.CustomBoostFactorQueryBuilder;
import org.elasticsearch.index.query.CustomFiltersScoreQueryBuilder;
import org.elasticsearch.index.query.CustomScoreQueryBuilder;
import org.elasticsearch.index.query.DisMaxQueryBuilder;
import org.elasticsearch.index.query.FieldMaskingSpanQueryBuilder;
import org.elasticsearch.index.query.FieldQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilteredQueryBuilder;
import org.elasticsearch.index.query.FuzzyLikeThisFieldQueryBuilder;
import org.elasticsearch.index.query.FuzzyLikeThisQueryBuilder;
import org.elasticsearch.index.query.FuzzyQueryBuilder;
import org.elasticsearch.index.query.GeoShapeQueryBuilder;
import org.elasticsearch.index.query.HasChildQueryBuilder;
import org.elasticsearch.index.query.HasParentQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.IndicesQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisFieldQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.PrefixQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.RegexpQueryBuilder;
import org.elasticsearch.index.query.SpanFirstQueryBuilder;
import org.elasticsearch.index.query.SpanMultiTermQueryBuilder;
import org.elasticsearch.index.query.SpanNearQueryBuilder;
import org.elasticsearch.index.query.SpanNotQueryBuilder;
import org.elasticsearch.index.query.SpanOrQueryBuilder;
import org.elasticsearch.index.query.SpanQueryBuilder;
import org.elasticsearch.index.query.SpanTermQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.query.TopChildrenQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.query.WrapperQueryBuilder;

public abstract class QueryBuilders {
    public static MatchAllQueryBuilder matchAllQuery() {
        return new MatchAllQueryBuilder();
    }

    public static MatchQueryBuilder text(String name, Object text) {
        return QueryBuilders.textQuery(name, text);
    }

    public static MatchQueryBuilder textQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.BOOLEAN);
    }

    public static MatchQueryBuilder matchQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.BOOLEAN);
    }

    public static CommonTermsQueryBuilder commonTerms(String name, Object text) {
        return new CommonTermsQueryBuilder(name, text);
    }

    public static MultiMatchQueryBuilder multiMatchQuery(Object text, String ... fieldNames) {
        return new MultiMatchQueryBuilder(text, fieldNames);
    }

    public static MatchQueryBuilder textPhrase(String name, Object text) {
        return QueryBuilders.textPhraseQuery(name, text);
    }

    public static MatchQueryBuilder textPhraseQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.PHRASE);
    }

    public static MatchQueryBuilder matchPhraseQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.PHRASE);
    }

    public static MatchQueryBuilder textPhrasePrefix(String name, Object text) {
        return QueryBuilders.textPhrasePrefixQuery(name, text);
    }

    public static MatchQueryBuilder textPhrasePrefixQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.PHRASE_PREFIX);
    }

    public static MatchQueryBuilder matchPhrasePrefixQuery(String name, Object text) {
        return new MatchQueryBuilder(name, text).type(MatchQueryBuilder.Type.PHRASE_PREFIX);
    }

    public static DisMaxQueryBuilder disMaxQuery() {
        return new DisMaxQueryBuilder();
    }

    public static IdsQueryBuilder idsQuery(String ... types) {
        return new IdsQueryBuilder(types);
    }

    public static TermQueryBuilder termQuery(String name, String value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, int value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, long value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, float value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, double value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, boolean value) {
        return new TermQueryBuilder(name, value);
    }

    public static TermQueryBuilder termQuery(String name, Object value) {
        return new TermQueryBuilder(name, value);
    }

    public static FuzzyQueryBuilder fuzzyQuery(String name, String value) {
        return new FuzzyQueryBuilder(name, value);
    }

    public static FieldQueryBuilder fieldQuery(String name, String query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, int query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, long query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, float query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, double query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, boolean query) {
        return new FieldQueryBuilder(name, query);
    }

    public static FieldQueryBuilder fieldQuery(String name, Object query) {
        return new FieldQueryBuilder(name, query);
    }

    public static PrefixQueryBuilder prefixQuery(String name, String prefix) {
        return new PrefixQueryBuilder(name, prefix);
    }

    public static RangeQueryBuilder rangeQuery(String name) {
        return new RangeQueryBuilder(name);
    }

    public static WildcardQueryBuilder wildcardQuery(String name, String query) {
        return new WildcardQueryBuilder(name, query);
    }

    public static RegexpQueryBuilder regexpQuery(String name, String regexp) {
        return new RegexpQueryBuilder(name, regexp);
    }

    public static QueryStringQueryBuilder queryString(String queryString) {
        return new QueryStringQueryBuilder(queryString);
    }

    public static BoostingQueryBuilder boostingQuery() {
        return new BoostingQueryBuilder();
    }

    public static BoolQueryBuilder boolQuery() {
        return new BoolQueryBuilder();
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, String value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, int value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, long value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, float value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanTermQueryBuilder spanTermQuery(String name, double value) {
        return new SpanTermQueryBuilder(name, value);
    }

    public static SpanFirstQueryBuilder spanFirstQuery(SpanQueryBuilder match, int end) {
        return new SpanFirstQueryBuilder(match, end);
    }

    public static SpanNearQueryBuilder spanNearQuery() {
        return new SpanNearQueryBuilder();
    }

    public static SpanNotQueryBuilder spanNotQuery() {
        return new SpanNotQueryBuilder();
    }

    public static SpanOrQueryBuilder spanOrQuery() {
        return new SpanOrQueryBuilder();
    }

    public static SpanMultiTermQueryBuilder spanMultiTermQueryBuilder(MultiTermQueryBuilder multiTermQueryBuilder) {
        return new SpanMultiTermQueryBuilder(multiTermQueryBuilder);
    }

    public static FieldMaskingSpanQueryBuilder fieldMaskingSpanQuery(SpanQueryBuilder query, String field) {
        return new FieldMaskingSpanQueryBuilder(query, field);
    }

    public static FilteredQueryBuilder filtered(QueryBuilder queryBuilder, @Nullable FilterBuilder filterBuilder) {
        return new FilteredQueryBuilder(queryBuilder, filterBuilder);
    }

    public static FilteredQueryBuilder filteredQuery(QueryBuilder queryBuilder, @Nullable FilterBuilder filterBuilder) {
        return new FilteredQueryBuilder(queryBuilder, filterBuilder);
    }

    public static ConstantScoreQueryBuilder constantScoreQuery(FilterBuilder filterBuilder) {
        return new ConstantScoreQueryBuilder(filterBuilder);
    }

    public static ConstantScoreQueryBuilder constantScoreQuery(QueryBuilder queryBuilder) {
        return new ConstantScoreQueryBuilder(queryBuilder);
    }

    public static CustomBoostFactorQueryBuilder customBoostFactorQuery(QueryBuilder queryBuilder) {
        return new CustomBoostFactorQueryBuilder(queryBuilder);
    }

    public static CustomScoreQueryBuilder customScoreQuery(QueryBuilder queryBuilder) {
        return new CustomScoreQueryBuilder(queryBuilder);
    }

    public static CustomFiltersScoreQueryBuilder customFiltersScoreQuery(QueryBuilder queryBuilder) {
        return new CustomFiltersScoreQueryBuilder(queryBuilder);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery(String ... fields) {
        return new MoreLikeThisQueryBuilder(fields);
    }

    public static MoreLikeThisQueryBuilder moreLikeThisQuery() {
        return new MoreLikeThisQueryBuilder();
    }

    public static FuzzyLikeThisQueryBuilder fuzzyLikeThisQuery(String ... fields) {
        return new FuzzyLikeThisQueryBuilder(fields);
    }

    public static FuzzyLikeThisQueryBuilder fuzzyLikeThisQuery() {
        return new FuzzyLikeThisQueryBuilder();
    }

    public static FuzzyLikeThisFieldQueryBuilder fuzzyLikeThisFieldQuery(String name) {
        return new FuzzyLikeThisFieldQueryBuilder(name);
    }

    public static MoreLikeThisFieldQueryBuilder moreLikeThisFieldQuery(String name) {
        return new MoreLikeThisFieldQueryBuilder(name);
    }

    public static TopChildrenQueryBuilder topChildrenQuery(String type, QueryBuilder query) {
        return new TopChildrenQueryBuilder(type, query);
    }

    public static HasChildQueryBuilder hasChildQuery(String type, QueryBuilder query) {
        return new HasChildQueryBuilder(type, query);
    }

    public static HasParentQueryBuilder hasParentQuery(String type, QueryBuilder query) {
        return new HasParentQueryBuilder(type, query);
    }

    public static NestedQueryBuilder nestedQuery(String path, QueryBuilder query) {
        return new NestedQueryBuilder(path, query);
    }

    public static NestedQueryBuilder nestedQuery(String path, FilterBuilder filter) {
        return new NestedQueryBuilder(path, filter);
    }

    public static TermsQueryBuilder termsQuery(String name, String ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, int ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, long ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, float ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, double ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Object ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder termsQuery(String name, Collection values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, String ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, int ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, long ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, float ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, double ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, Object ... values) {
        return new TermsQueryBuilder(name, values);
    }

    public static TermsQueryBuilder inQuery(String name, Collection values) {
        return new TermsQueryBuilder(name, values);
    }

    public static IndicesQueryBuilder indicesQuery(QueryBuilder queryBuilder, String ... indices) {
        return new IndicesQueryBuilder(queryBuilder, indices);
    }

    public static WrapperQueryBuilder wrapperQuery(String source) {
        return new WrapperQueryBuilder(source);
    }

    public static WrapperQueryBuilder wrapperQuery(byte[] source, int offset, int length) {
        return new WrapperQueryBuilder(source, offset, length);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, Shape shape) {
        return new GeoShapeQueryBuilder(name, shape);
    }

    public static GeoShapeQueryBuilder geoShapeQuery(String name, String indexedShapeId, String indexedShapeType) {
        return new GeoShapeQueryBuilder(name, indexedShapeId, indexedShapeType);
    }

    private QueryBuilders() {
    }
}

