/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ExtendedCommonTermsQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class MatchQuery {
    protected final QueryParseContext parseContext;
    protected String analyzer;
    protected BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    protected boolean enablePositionIncrements = true;
    protected int phraseSlop = 0;
    protected String fuzziness = null;
    protected int fuzzyPrefixLength = 0;
    protected int maxExpansions = 50;
    protected boolean transpositions = false;
    protected MultiTermQuery.RewriteMethod rewriteMethod;
    protected MultiTermQuery.RewriteMethod fuzzyRewriteMethod;
    protected boolean lenient;
    protected ZeroTermsQuery zeroTermsQuery = ZeroTermsQuery.NONE;
    protected Float commonTermsCutoff = null;

    public MatchQuery(QueryParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setCommonTermsCutoff(float cutoff) {
        this.commonTermsCutoff = Float.valueOf(cutoff);
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(String fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setTranspositions(boolean transpositions) {
        this.transpositions = transpositions;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public void setZeroTermsQuery(ZeroTermsQuery zeroTermsQuery) {
        this.zeroTermsQuery = zeroTermsQuery;
    }

    public Query parse(Type type, String fieldName, Object value) throws IOException {
        String field;
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = this.parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
            field = mapper.names().indexName();
        } else {
            field = fieldName;
        }
        if (mapper != null && mapper.useTermQueryWithQueryString()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    Query query = QueryParsers.wrapSmartNameQuery(mapper.termQuery(value, this.parseContext), smartNameFieldMappers, this.parseContext);
                    return query;
                }
                catch (RuntimeException e) {
                    if (this.lenient) {
                        Query query = null;
                        return query;
                    }
                    throw e;
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            }
            try {
                return QueryParsers.wrapSmartNameQuery(mapper.termQuery(value, this.parseContext), smartNameFieldMappers, this.parseContext);
            }
            catch (RuntimeException e) {
                if (this.lenient) {
                    return null;
                }
                throw e;
            }
        }
        Analyzer analyzer = null;
        if (this.analyzer == null) {
            if (mapper != null) {
                analyzer = mapper.searchAnalyzer();
            }
            if (analyzer == null && smartNameFieldMappers != null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
            if (analyzer == null) {
                analyzer = this.parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = this.parseContext.mapperService().analysisService().analyzer(this.analyzer);
            if (analyzer == null) {
                throw new ElasticSearchIllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
            }
        }
        TokenStream source = analyzer.tokenStream(field, (Reader)new FastStringReader(value.toString()));
        source.reset();
        int numTokens = 0;
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        buffer.reset();
        CharTermAttribute termAtt = (CharTermAttribute)buffer.addAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)buffer.addAttribute(PositionIncrementAttribute.class);
        boolean hasMoreTokens = buffer.incrementToken();
        while (hasMoreTokens) {
            ++numTokens;
            int positionIncrement = posIncrAtt.getPositionIncrement();
            if (positionIncrement != 0) {
                positionCount += positionIncrement;
            } else {
                severalTokensAtSamePosition = true;
            }
            hasMoreTokens = buffer.incrementToken();
        }
        buffer.reset();
        source.close();
        if (numTokens == 0) {
            return this.zeroTermsQuery();
        }
        if (type == Type.BOOLEAN) {
            if (numTokens == 1) {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                Query q = this.newTermQuery(mapper, new Term(field, MatchQuery.termToByteRef(termAtt)));
                return QueryParsers.wrapSmartNameQuery(q, smartNameFieldMappers, this.parseContext);
            }
            if (this.commonTermsCutoff != null) {
                ExtendedCommonTermsQuery q = new ExtendedCommonTermsQuery(this.occur, this.occur, this.commonTermsCutoff.floatValue(), positionCount == 1);
                for (int i = 0; i < numTokens; ++i) {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    q.add(new Term(field, MatchQuery.termToByteRef(termAtt)));
                }
                return QueryParsers.wrapSmartNameQuery((Query)q, smartNameFieldMappers, this.parseContext);
            }
            BooleanQuery q = new BooleanQuery(positionCount == 1);
            for (int i = 0; i < numTokens; ++i) {
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                Query currentQuery = this.newTermQuery(mapper, new Term(field, MatchQuery.termToByteRef(termAtt)));
                q.add(currentQuery, this.occur);
            }
            return QueryParsers.wrapSmartNameQuery((Query)q, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE) {
            if (severalTokensAtSamePosition) {
                MultiPhraseQuery mpq = new MultiPhraseQuery();
                mpq.setSlop(this.phraseSlop);
                ArrayList<Term> multiTerms = new ArrayList<Term>();
                int position = -1;
                for (int i = 0; i < numTokens; ++i) {
                    int positionIncrement = 1;
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    positionIncrement = posIncrAtt.getPositionIncrement();
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        if (this.enablePositionIncrements) {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                        } else {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                        }
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(new Term(field, MatchQuery.termToByteRef(termAtt)));
                }
                if (this.enablePositionIncrements) {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                } else {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                }
                return QueryParsers.wrapSmartNameQuery((Query)mpq, smartNameFieldMappers, this.parseContext);
            }
            PhraseQuery pq = new PhraseQuery();
            pq.setSlop(this.phraseSlop);
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                int positionIncrement = 1;
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                positionIncrement = posIncrAtt.getPositionIncrement();
                if (this.enablePositionIncrements) {
                    pq.add(new Term(field, MatchQuery.termToByteRef(termAtt)), position += positionIncrement);
                    continue;
                }
                pq.add(new Term(field, MatchQuery.termToByteRef(termAtt)));
            }
            return QueryParsers.wrapSmartNameQuery((Query)pq, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE_PREFIX) {
            MultiPhrasePrefixQuery mpq = new MultiPhrasePrefixQuery();
            mpq.setSlop(this.phraseSlop);
            mpq.setMaxExpansions(this.maxExpansions);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                int positionIncrement = 1;
                boolean hasNext = buffer.incrementToken();
                assert (hasNext);
                positionIncrement = posIncrAtt.getPositionIncrement();
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(new Term(field, MatchQuery.termToByteRef(termAtt)));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
            }
            return QueryParsers.wrapSmartNameQuery(mpq, smartNameFieldMappers, this.parseContext);
        }
        throw new ElasticSearchIllegalStateException("No type found for [" + (Object)((Object)type) + "]");
    }

    private Query newTermQuery(@Nullable FieldMapper mapper, Term term) {
        Query termQuery;
        if (this.fuzziness != null) {
            Query query;
            if (mapper != null && (query = mapper.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions)) instanceof FuzzyQuery) {
                QueryParsers.setRewriteMethod((MultiTermQuery)((FuzzyQuery)query), this.fuzzyRewriteMethod);
            }
            String text = term.text();
            int edits = FuzzyQuery.floatToEdits((float)Float.parseFloat(this.fuzziness), (int)text.codePointCount(0, text.length()));
            FuzzyQuery query2 = new FuzzyQuery(term, edits, this.fuzzyPrefixLength, this.maxExpansions, this.transpositions);
            QueryParsers.setRewriteMethod((MultiTermQuery)query2, this.rewriteMethod);
            return query2;
        }
        if (mapper != null && (termQuery = mapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return new TermQuery(term);
    }

    private static BytesRef termToByteRef(CharTermAttribute attr) {
        BytesRef ref = new BytesRef();
        UnicodeUtil.UTF16toUTF8((char[])attr.buffer(), (int)0, (int)attr.length(), (BytesRef)ref);
        return ref;
    }

    protected Query zeroTermsQuery() {
        return this.zeroTermsQuery == ZeroTermsQuery.NONE ? MatchNoDocsQuery.INSTANCE : Queries.MATCH_ALL_QUERY;
    }

    public static enum ZeroTermsQuery {
        NONE,
        ALL;

    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }
}

