/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.trove.map.TObjectFloatMap;
import org.elasticsearch.common.trove.map.TObjectIntMap;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;
import org.elasticsearch.common.trove.map.hash.TObjectIntHashMap;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.HasChildFilter;
import org.elasticsearch.index.search.child.ParentIdCollector;
import org.elasticsearch.index.search.child.ScoreType;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenQuery
extends Query
implements SearchContext.Rewrite {
    private final SearchContext searchContext;
    private final String parentType;
    private final String childType;
    private final Filter parentFilter;
    private final ScoreType scoreType;
    private final Query originalChildQuery;
    private Query rewrittenChildQuery;
    private TObjectFloatHashMap<HashedBytesArray> uidToScore;
    private TObjectIntHashMap<HashedBytesArray> uidToCount;

    public ChildrenQuery(SearchContext searchContext, String parentType, String childType, Filter parentFilter, Query childQuery, ScoreType scoreType) {
        this.searchContext = searchContext;
        this.parentType = parentType;
        this.childType = childType;
        this.parentFilter = parentFilter;
        this.originalChildQuery = childQuery;
        this.scoreType = scoreType;
    }

    private ChildrenQuery(ChildrenQuery unProcessedQuery, Query rewrittenChildQuery) {
        this.searchContext = unProcessedQuery.searchContext;
        this.parentType = unProcessedQuery.parentType;
        this.childType = unProcessedQuery.childType;
        this.parentFilter = unProcessedQuery.parentFilter;
        this.scoreType = unProcessedQuery.scoreType;
        this.originalChildQuery = unProcessedQuery.originalChildQuery;
        this.rewrittenChildQuery = rewrittenChildQuery;
        this.uidToScore = unProcessedQuery.uidToScore;
        this.uidToCount = unProcessedQuery.uidToCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HasChildFilter that = (HasChildFilter)obj;
        if (!this.originalChildQuery.equals((Object)that.childQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    public int hashCode() {
        int result = this.originalChildQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + this.childType.hashCode();
        return result;
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("ChildrenQuery[").append(this.childType).append("/").append(this.parentType).append("](").append(this.originalChildQuery.toString(field)).append(')').append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.rewrittenChildQuery == null ? this.originalChildQuery.rewrite(reader) : this.rewrittenChildQuery;
        if (rewritten == this.rewrittenChildQuery) {
            return this;
        }
        int index = this.searchContext.rewrites().indexOf(this);
        ChildrenQuery rewrite = new ChildrenQuery(this, rewritten);
        this.searchContext.rewrites().set(index, rewrite);
        return rewrite;
    }

    public void extractTerms(Set<Term> terms) {
        this.rewrittenChildQuery.extractTerms(terms);
    }

    @Override
    public void contextRewrite(SearchContext searchContext) throws Exception {
        ChildUidCollector collector;
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        this.uidToScore = CacheRecycler.popObjectFloatMap();
        switch (this.scoreType) {
            case AVG: {
                this.uidToCount = CacheRecycler.popObjectIntMap();
                collector = new AvgChildUidCollector(this.scoreType, searchContext, this.parentType, this.uidToScore, this.uidToCount);
                break;
            }
            default: {
                collector = new ChildUidCollector(this.scoreType, searchContext, this.parentType, this.uidToScore);
            }
        }
        Query childQuery = this.rewrittenChildQuery == null ? (this.rewrittenChildQuery = searchContext.searcher().rewrite(this.originalChildQuery)) : this.rewrittenChildQuery;
        searchContext.searcher().search(childQuery, collector);
    }

    @Override
    public void contextClear() {
        if (this.uidToScore != null) {
            CacheRecycler.pushObjectFloatMap(this.uidToScore);
        }
        this.uidToScore = null;
        if (this.uidToCount != null) {
            CacheRecycler.pushObjectIntMap(this.uidToCount);
        }
        this.uidToCount = null;
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        if (this.uidToScore == null) {
            throw new ElasticSearchIllegalStateException("has_child query hasn't executed properly");
        }
        return new ParentWeight(this.rewrittenChildQuery.createWeight(searcher));
    }

    static final class AvgChildUidCollector
    extends ChildUidCollector {
        final TObjectIntHashMap<HashedBytesArray> uidToCount;

        AvgChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, TObjectFloatHashMap<HashedBytesArray> uidToScore, TObjectIntHashMap<HashedBytesArray> uidToCount) {
            super(scoreType, searchContext, childType, uidToScore);
            this.uidToCount = uidToCount;
            assert (scoreType == ScoreType.AVG);
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float previousScore = this.uidToScore.get(parentUid);
            float currentScore = this.scorer.score();
            if (previousScore == 0.0f) {
                this.uidToScore.put(parentUid, currentScore);
                this.uidToCount.put(parentUid, 1);
            } else {
                this.uidToScore.adjustValue(parentUid, currentScore);
                this.uidToCount.increment(parentUid);
            }
        }
    }

    static class ChildUidCollector
    extends ParentIdCollector {
        final TObjectFloatHashMap<HashedBytesArray> uidToScore;
        final ScoreType scoreType;
        Scorer scorer;

        ChildUidCollector(ScoreType scoreType, SearchContext searchContext, String childType, TObjectFloatHashMap<HashedBytesArray> uidToScore) {
            super(childType, searchContext);
            this.uidToScore = uidToScore;
            this.scoreType = scoreType;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void collect(int doc, HashedBytesArray parentUid) throws IOException {
            float previousScore = this.uidToScore.get(parentUid);
            float currentScore = this.scorer.score();
            if (previousScore == 0.0f) {
                this.uidToScore.put(parentUid, currentScore);
            } else {
                switch (this.scoreType) {
                    case SUM: {
                        this.uidToScore.adjustValue(parentUid, currentScore);
                        break;
                    }
                    case MAX: {
                        if (!(currentScore > previousScore)) break;
                        this.uidToScore.put(parentUid, currentScore);
                        break;
                    }
                    case AVG: {
                        assert (false) : "AVG has it's own collector";
                    }
                    default: {
                        assert (false) : "Are we missing a score type here? -- " + (Object)((Object)this.scoreType);
                        break;
                    }
                }
            }
        }
    }

    static class AvgParentScorer
    extends ParentScorer {
        final TObjectIntMap<HashedBytesArray> uidToCount;
        HashedBytesArray currentUid;

        AvgParentScorer(Weight weight, IdReaderTypeCache idTypeCache, TObjectFloatMap<HashedBytesArray> uidToScore, TObjectIntMap<HashedBytesArray> uidToCount, DocIdSetIterator parentsIterator) {
            super(weight, idTypeCache, uidToScore, parentsIterator);
            this.uidToCount = uidToCount;
        }

        @Override
        public int nextDoc() throws IOException {
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                this.currentUid = this.idTypeCache.idByDoc(this.currentDocId);
                this.currentScore = this.uidToScore.get(this.currentUid);
            } while (this.currentScore == 0.0f);
            this.currentScore /= (float)this.uidToCount.get(this.currentUid);
            return this.currentDocId;
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            HashedBytesArray uid = this.idTypeCache.idByDoc(this.currentDocId);
            this.currentScore = this.uidToScore.get(uid);
            if (this.currentScore != 0.0f) {
                this.currentScore /= (float)this.uidToCount.get(this.currentUid);
                return this.currentDocId;
            }
            return this.nextDoc();
        }
    }

    static class ParentScorer
    extends Scorer {
        final IdReaderTypeCache idTypeCache;
        final TObjectFloatMap<HashedBytesArray> uidToScore;
        final DocIdSetIterator parentsIterator;
        int currentDocId = -1;
        float currentScore;

        ParentScorer(Weight weight, IdReaderTypeCache idTypeCache, TObjectFloatMap<HashedBytesArray> uidToScore, DocIdSetIterator parentsIterator) {
            super(weight);
            this.idTypeCache = idTypeCache;
            this.uidToScore = uidToScore;
            this.parentsIterator = parentsIterator;
        }

        public float score() throws IOException {
            return this.currentScore;
        }

        public int freq() throws IOException {
            return 1;
        }

        public int docID() {
            return this.currentDocId;
        }

        public int nextDoc() throws IOException {
            do {
                this.currentDocId = this.parentsIterator.nextDoc();
                if (this.currentDocId == Integer.MAX_VALUE) {
                    return this.currentDocId;
                }
                HashedBytesArray uid = this.idTypeCache.idByDoc(this.currentDocId);
                this.currentScore = this.uidToScore.get(uid);
            } while (this.currentScore == 0.0f);
            return this.currentDocId;
        }

        public int advance(int target) throws IOException {
            this.currentDocId = this.parentsIterator.advance(target);
            if (this.currentDocId == Integer.MAX_VALUE) {
                return this.currentDocId;
            }
            HashedBytesArray uid = this.idTypeCache.idByDoc(this.currentDocId);
            this.currentScore = this.uidToScore.get(uid);
            if (this.currentScore != 0.0f) {
                return this.currentDocId;
            }
            return this.nextDoc();
        }

        public long cost() {
            return this.parentsIterator.cost();
        }
    }

    class ParentWeight
    extends Weight {
        final Weight childWeight;

        public ParentWeight(Weight childWeight) {
            this.childWeight = childWeight;
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            return new Explanation(ChildrenQuery.this.getBoost(), "not implemented yet...");
        }

        public Query getQuery() {
            return ChildrenQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.childWeight.getValueForNormalization();
            return sum *= ChildrenQuery.this.getBoost() * ChildrenQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            DocIdSet parentsSet = ChildrenQuery.this.parentFilter.getDocIdSet(context, acceptDocs);
            if (parentsSet == null || parentsSet == DocIdSet.EMPTY_DOCIDSET) {
                return null;
            }
            IdReaderTypeCache idTypeCache = ChildrenQuery.this.searchContext.idCache().reader(context.reader()).type(ChildrenQuery.this.parentType);
            DocIdSetIterator parentsIterator = parentsSet.iterator();
            switch (ChildrenQuery.this.scoreType) {
                case AVG: {
                    return new AvgParentScorer(this, idTypeCache, ChildrenQuery.this.uidToScore, ChildrenQuery.this.uidToCount, parentsIterator);
                }
            }
            return new ParentScorer(this, idTypeCache, ChildrenQuery.this.uidToScore, parentsIterator);
        }
    }
}

