/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.child;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.index.cache.id.IdReaderTypeCache;
import org.elasticsearch.index.search.child.ParentIdCollector;
import org.elasticsearch.search.internal.SearchContext;

public class HasChildFilter
extends Filter
implements SearchContext.Rewrite {
    final Query childQuery;
    final String parentType;
    final String childType;
    final Filter parentFilter;
    final SearchContext searchContext;
    THashSet<HashedBytesArray> collectedUids;

    public HasChildFilter(Query childQuery, String parentType, String childType, Filter parentFilter, SearchContext searchContext) {
        this.parentFilter = parentFilter;
        this.searchContext = searchContext;
        this.parentType = parentType;
        this.childType = childType;
        this.childQuery = childQuery;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        HasChildFilter that = (HasChildFilter)obj;
        if (!this.childQuery.equals((Object)that.childQuery)) {
            return false;
        }
        if (!this.childType.equals(that.childType)) {
            return false;
        }
        return this.parentType.equals(that.parentType);
    }

    public int hashCode() {
        int result = this.childQuery.hashCode();
        result = 31 * result + this.parentType.hashCode();
        result = 31 * result + this.childType.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("child_filter[").append(this.childType).append("/").append(this.parentType).append("](").append(this.childQuery).append(')');
        return sb.toString();
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        if (this.collectedUids == null) {
            throw new ElasticSearchIllegalStateException("has_child filter hasn't executed properly");
        }
        DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(context, null);
        if (DocIdSets.isEmpty(parentDocIdSet)) {
            return null;
        }
        Bits parentsBits = DocIdSets.toSafeBits(context.reader(), parentDocIdSet);
        IdReaderTypeCache idReaderTypeCache = this.searchContext.idCache().reader(context.reader()).type(this.parentType);
        if (idReaderTypeCache != null) {
            return new ParentDocSet((IndexReader)context.reader(), parentsBits, this.collectedUids, idReaderTypeCache);
        }
        return null;
    }

    @Override
    public void contextRewrite(SearchContext searchContext) throws Exception {
        searchContext.idCache().refresh(searchContext.searcher().getTopReaderContext().leaves());
        this.collectedUids = CacheRecycler.popHashSet();
        UidCollector collector = new UidCollector(this.parentType, searchContext, this.collectedUids);
        searchContext.searcher().search(this.childQuery, collector);
    }

    @Override
    public void contextClear() {
        if (this.collectedUids != null) {
            CacheRecycler.pushHashSet(this.collectedUids);
        }
        this.collectedUids = null;
    }

    static final class UidCollector
    extends ParentIdCollector {
        final THashSet<HashedBytesArray> collectedUids;

        UidCollector(String parentType, SearchContext context, THashSet<HashedBytesArray> collectedUids) {
            super(parentType, context);
            this.collectedUids = collectedUids;
        }

        @Override
        public void collect(int doc, HashedBytesArray parentIdByDoc) {
            this.collectedUids.add(parentIdByDoc);
        }
    }

    static final class ParentDocSet
    extends MatchDocIdSet {
        final IndexReader reader;
        final THashSet<HashedBytesArray> parents;
        final IdReaderTypeCache typeCache;

        ParentDocSet(IndexReader reader, Bits acceptDocs, THashSet<HashedBytesArray> parents, IdReaderTypeCache typeCache) {
            super(reader.maxDoc(), acceptDocs);
            this.reader = reader;
            this.parents = parents;
            this.typeCache = typeCache;
        }

        @Override
        protected boolean matchDoc(int doc) {
            return this.parents.contains(this.typeCache.idByDoc(doc));
        }
    }
}

