/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.docset.MatchDocIdSet;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;

public class GeoPolygonFilter
extends Filter {
    private final GeoPoint[] points;
    private final IndexGeoPointFieldData indexFieldData;

    public GeoPolygonFilter(GeoPoint[] points, IndexGeoPointFieldData indexFieldData) {
        this.points = points;
        this.indexFieldData = indexFieldData;
    }

    public GeoPoint[] points() {
        return this.points;
    }

    public String fieldName() {
        return this.indexFieldData.getFieldNames().indexName();
    }

    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
        GeoPointValues values = ((AtomicGeoPointFieldData)this.indexFieldData.load(context)).getGeoPointValues();
        return new GeoPolygonDocIdSet(context.reader().maxDoc(), acceptedDocs, values, this.points);
    }

    public String toString() {
        return "GeoPolygonFilter(" + this.indexFieldData.getFieldNames().indexName() + ", " + Arrays.toString(this.points) + ")";
    }

    public static class GeoPolygonDocIdSet
    extends MatchDocIdSet {
        private final GeoPointValues values;
        private final GeoPoint[] points;

        public GeoPolygonDocIdSet(int maxDoc, @Nullable Bits acceptDocs, GeoPointValues values, GeoPoint[] points) {
            super(maxDoc, acceptDocs);
            this.values = values;
            this.points = points;
        }

        public boolean isCacheable() {
            return true;
        }

        @Override
        protected boolean matchDoc(int doc) {
            if (!this.values.hasValue(doc)) {
                return false;
            }
            if (this.values.isMultiValued()) {
                GeoPointValues.Iter iter = this.values.getIter(doc);
                while (iter.hasNext()) {
                    GeoPoint point = iter.next();
                    if (!GeoPolygonDocIdSet.pointInPolygon(this.points, point.lat(), point.lon())) continue;
                    return true;
                }
            } else {
                GeoPoint point = this.values.getValue(doc);
                return GeoPolygonDocIdSet.pointInPolygon(this.points, point.lat(), point.lon());
            }
            return false;
        }

        private static boolean pointInPolygon(GeoPoint[] points, double lat, double lon) {
            int j = points.length - 1;
            boolean inPoly = false;
            int i = 0;
            while (i < points.length) {
                if ((points[i].lon() < lon && points[j].lon() >= lon || points[j].lon() < lon && points[i].lon() >= lon) && points[i].lat() + (lon - points[i].lon()) / (points[j].lon() - points[i].lon()) * (points[j].lat() - points[i].lat()) < lat) {
                    inPoly = !inPoly;
                }
                j = i++;
            }
            return inPoly;
        }
    }
}

