/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.nested;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.SortField;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.NumberComparatorBase;
import org.elasticsearch.index.fielddata.fieldcomparator.SortMode;
import org.elasticsearch.index.search.nested.NestedFieldComparator;

public class NestedFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final SortMode sortMode;
    private final IndexFieldData.XFieldComparatorSource wrappedSource;
    private final Filter rootDocumentsFilter;
    private final Filter innerDocumentsFilter;

    public NestedFieldComparatorSource(SortMode sortMode, IndexFieldData.XFieldComparatorSource wrappedSource, Filter rootDocumentsFilter, Filter innerDocumentsFilter) {
        this.sortMode = sortMode;
        this.wrappedSource = wrappedSource;
        this.rootDocumentsFilter = rootDocumentsFilter;
        this.innerDocumentsFilter = innerDocumentsFilter;
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        FieldComparator wrappedComparator = this.wrappedSource.newComparator(fieldname, numHits + 1, sortPos, reversed);
        switch (this.sortMode) {
            case MAX: {
                return new NestedFieldComparator.Highest(wrappedComparator, this.rootDocumentsFilter, this.innerDocumentsFilter, numHits);
            }
            case MIN: {
                return new NestedFieldComparator.Lowest(wrappedComparator, this.rootDocumentsFilter, this.innerDocumentsFilter, numHits);
            }
            case SUM: {
                return new NestedFieldComparator.Sum((NumberComparatorBase)wrappedComparator, this.rootDocumentsFilter, this.innerDocumentsFilter, numHits);
            }
            case AVG: {
                return new NestedFieldComparator.Avg((NumberComparatorBase)wrappedComparator, this.rootDocumentsFilter, this.innerDocumentsFilter, numHits);
            }
        }
        throw new ElasticSearchIllegalArgumentException(String.format(Locale.ROOT, "Unsupported sort_mode[%s] for nested type", new Object[]{this.sortMode}));
    }

    @Override
    public SortField.Type reducedType() {
        return this.wrappedSource.reducedType();
    }
}

