/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.ClosedByInterruptException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.ThreadInterruptedException;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FastByteArrayOutputStream;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.aliases.IndexAliasesService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.filter.FilterCacheStats;
import org.elasticsearch.index.cache.filter.ShardFilterCache;
import org.elasticsearch.index.cache.id.IdCacheStats;
import org.elasticsearch.index.cache.id.ShardIdCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineClosedException;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.engine.IgnoreOnRecoveryEngineException;
import org.elasticsearch.index.engine.OptimizeFailedEngineException;
import org.elasticsearch.index.engine.RefreshFailedEngineException;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.ShardFieldData;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.get.ShardGetService;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.search.stats.ShardSearchService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.IndexShardNotRecoveringException;
import org.elasticsearch.index.shard.IndexShardNotStartedException;
import org.elasticsearch.index.shard.IndexShardRecoveringException;
import org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.elasticsearch.index.shard.IndexShardStartedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreStats;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.warmer.ShardIndexWarmerService;
import org.elasticsearch.index.warmer.WarmerStats;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.recovery.RecoveryStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class InternalIndexShard
extends AbstractIndexShardComponent
implements IndexShard {
    private final ThreadPool threadPool;
    private final IndexSettingsService indexSettingsService;
    private final MapperService mapperService;
    private final IndexQueryParserService queryParserService;
    private final IndexCache indexCache;
    private final InternalIndicesLifecycle indicesLifecycle;
    private final Store store;
    private final MergeSchedulerProvider mergeScheduler;
    private final Engine engine;
    private final Translog translog;
    private final IndexAliasesService indexAliasesService;
    private final ShardIndexingService indexingService;
    private final ShardSearchService searchService;
    private final ShardGetService getService;
    private final ShardIndexWarmerService shardWarmerService;
    private final ShardFilterCache shardFilterCache;
    private final ShardIdCache shardIdCache;
    private final ShardFieldData shardFieldData;
    private final Object mutex = new Object();
    private final String checkIndexOnStartup;
    private long checkIndexTook = 0L;
    private volatile IndexShardState state;
    private TimeValue refreshInterval;
    private final TimeValue mergeInterval;
    private volatile ScheduledFuture refreshScheduledFuture;
    private volatile ScheduledFuture mergeScheduleFuture;
    private volatile ShardRouting shardRouting;
    private RecoveryStatus peerRecoveryStatus;
    private ApplyRefreshSettings applyRefreshSettings = new ApplyRefreshSettings();
    private final MeanMetric refreshMetric = new MeanMetric();
    private final MeanMetric flushMetric = new MeanMetric();
    public static final String INDEX_REFRESH_INTERVAL = "index.refresh_interval";

    @Inject
    public InternalIndexShard(ShardId shardId, @IndexSettings Settings indexSettings, IndexSettingsService indexSettingsService, IndicesLifecycle indicesLifecycle, Store store, Engine engine, MergeSchedulerProvider mergeScheduler, Translog translog, ThreadPool threadPool, MapperService mapperService, IndexQueryParserService queryParserService, IndexCache indexCache, IndexAliasesService indexAliasesService, ShardIndexingService indexingService, ShardGetService getService, ShardSearchService searchService, ShardIndexWarmerService shardWarmerService, ShardFilterCache shardFilterCache, ShardIdCache shardIdCache, ShardFieldData shardFieldData) {
        super(shardId, indexSettings);
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indexSettingsService = indexSettingsService;
        this.store = store;
        this.engine = engine;
        this.mergeScheduler = mergeScheduler;
        this.translog = translog;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.queryParserService = queryParserService;
        this.indexCache = indexCache;
        this.indexAliasesService = indexAliasesService;
        this.indexingService = indexingService;
        this.getService = getService.setIndexShard(this);
        this.searchService = searchService;
        this.shardWarmerService = shardWarmerService;
        this.shardFilterCache = shardFilterCache;
        this.shardIdCache = shardIdCache;
        this.shardFieldData = shardFieldData;
        this.state = IndexShardState.CREATED;
        this.refreshInterval = indexSettings.getAsTime("engine.robin.refresh_interval", indexSettings.getAsTime(INDEX_REFRESH_INTERVAL, engine.defaultRefreshInterval()));
        this.mergeInterval = indexSettings.getAsTime("index.merge.async_interval", TimeValue.timeValueSeconds(1L));
        indexSettingsService.addListener(this.applyRefreshSettings);
        this.logger.debug("state: [CREATED]", new Object[0]);
        this.checkIndexOnStartup = indexSettings.get("index.shard.check_on_startup", "false");
    }

    public MergeSchedulerProvider mergeScheduler() {
        return this.mergeScheduler;
    }

    public Store store() {
        return this.store;
    }

    public Engine engine() {
        return this.engine;
    }

    public Translog translog() {
        return this.translog;
    }

    @Override
    public ShardIndexingService indexingService() {
        return this.indexingService;
    }

    @Override
    public ShardGetService getService() {
        return this.getService;
    }

    @Override
    public ShardSearchService searchService() {
        return this.searchService;
    }

    @Override
    public ShardIndexWarmerService warmerService() {
        return this.shardWarmerService;
    }

    @Override
    public ShardFilterCache filterCache() {
        return this.shardFilterCache;
    }

    @Override
    public ShardIdCache idCache() {
        return this.shardIdCache;
    }

    @Override
    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public InternalIndexShard routingEntry(ShardRouting shardRouting) {
        ShardRouting currentRouting = this.shardRouting;
        if (!shardRouting.shardId().equals(this.shardId())) {
            throw new ElasticSearchIllegalArgumentException("Trying to set a routing entry with shardId [" + shardRouting.shardId() + "] on a shard with shardId [" + this.shardId() + "]");
        }
        if (currentRouting != null) {
            if (!shardRouting.primary() && currentRouting.primary()) {
                this.logger.warn("suspect illegal state: trying to move shard from primary mode to replica mode", new Object[0]);
            }
            if (currentRouting.equals(shardRouting)) {
                return this;
            }
        }
        this.shardRouting = shardRouting;
        this.indicesLifecycle.shardRoutingChanged(this, currentRouting, shardRouting);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexShardState recovering(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardRecoveringException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            IndexShardState returnValue = this.state;
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (this.state == IndexShardState.RECOVERING) {
                throw new IndexShardRecoveringException(this.shardId);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RECOVERING, reason});
            this.state = IndexShardState.RECOVERING;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard relocated(String reason) throws IndexShardNotStartedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state != IndexShardState.STARTED) {
                throw new IndexShardNotStartedException(this.shardId, this.state);
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.RELOCATED, reason});
            this.state = IndexShardState.RELOCATED;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalIndexShard start(String reason) throws IndexShardStartedException, IndexShardRelocatedException, IndexShardClosedException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.state == IndexShardState.CLOSED) {
                throw new IndexShardClosedException(this.shardId);
            }
            if (this.state == IndexShardState.STARTED) {
                throw new IndexShardStartedException(this.shardId);
            }
            if (this.state == IndexShardState.RELOCATED) {
                throw new IndexShardRelocatedException(this.shardId);
            }
            if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
                this.checkIndex(true);
            }
            this.engine.start();
            this.startScheduledTasksIfNeeded();
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.STARTED, reason});
            this.state = IndexShardState.STARTED;
        }
        this.indicesLifecycle.afterIndexShardStarted(this);
        return this;
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    @Override
    public Engine.Create prepareCreate(SourceToParse source) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Create(docMapper, docMapper.uidMapper().term(doc.uid().uid()), doc).startTime(startTime);
    }

    @Override
    public ParsedDocument create(Engine.Create create) throws ElasticSearchException {
        this.writeAllowed();
        create = this.indexingService.preCreate(create);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("index {}", create.docs());
        }
        this.engine.create(create);
        create.endTime(System.nanoTime());
        this.indexingService.postCreate(create);
        return create.parsedDoc();
    }

    @Override
    public Engine.Index prepareIndex(SourceToParse source) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(source.type());
        ParsedDocument doc = docMapper.parse(source);
        return new Engine.Index(docMapper, docMapper.uidMapper().term(doc.uid().uid()), doc).startTime(startTime);
    }

    @Override
    public ParsedDocument index(Engine.Index index) throws ElasticSearchException {
        this.writeAllowed();
        index = this.indexingService.preIndex(index);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("index {}", index.docs());
            }
            this.engine.index(index);
            index.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedIndex(index);
            throw ex;
        }
        this.indexingService.postIndex(index);
        return index.parsedDoc();
    }

    @Override
    public Engine.Delete prepareDelete(String type, String id, long version) throws ElasticSearchException {
        long startTime = System.nanoTime();
        DocumentMapper docMapper = this.mapperService.documentMapperWithAutoCreate(type);
        return new Engine.Delete(type, id, docMapper.uidMapper().term(type, id)).version(version).startTime(startTime);
    }

    @Override
    public void delete(Engine.Delete delete) throws ElasticSearchException {
        this.writeAllowed();
        delete = this.indexingService.preDelete(delete);
        try {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("delete [{}]", delete.uid().text());
            }
            this.engine.delete(delete);
            delete.endTime(System.nanoTime());
        }
        catch (RuntimeException ex) {
            this.indexingService.failedDelete(delete);
            throw ex;
        }
        this.indexingService.postDelete(delete);
    }

    @Override
    public Engine.DeleteByQuery prepareDeleteByQuery(BytesReference querySource, @Nullable String[] filteringAliases, String ... types) throws ElasticSearchException {
        long startTime = System.nanoTime();
        if (types == null) {
            types = Strings.EMPTY_ARRAY;
        }
        Query query = this.queryParserService.parse(querySource).query();
        query = this.filterQueryIfNeeded(query, types);
        Filter aliasFilter = this.indexAliasesService.aliasFilter(filteringAliases);
        Filter parentFilter = this.mapperService.hasNested() ? this.indexCache.filter().cache(NonNestedDocsFilter.INSTANCE) : null;
        return new Engine.DeleteByQuery(query, querySource, filteringAliases, aliasFilter, parentFilter, types).startTime(startTime);
    }

    @Override
    public void deleteByQuery(Engine.DeleteByQuery deleteByQuery) throws ElasticSearchException {
        this.writeAllowed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("delete_by_query [{}]", deleteByQuery.query());
        }
        deleteByQuery = this.indexingService.preDeleteByQuery(deleteByQuery);
        this.engine.delete(deleteByQuery);
        deleteByQuery.endTime(System.nanoTime());
        this.indexingService.postDeleteByQuery(deleteByQuery);
    }

    @Override
    public Engine.GetResult get(Engine.Get get) throws ElasticSearchException {
        this.readAllowed();
        return this.engine.get(get);
    }

    @Override
    public void refresh(Engine.Refresh refresh) throws ElasticSearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with {}", refresh);
        }
        long time = System.nanoTime();
        this.engine.refresh(refresh);
        this.refreshMetric.inc(System.nanoTime() - time);
    }

    @Override
    public RefreshStats refreshStats() {
        return new RefreshStats(this.refreshMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.refreshMetric.sum()));
    }

    @Override
    public FlushStats flushStats() {
        return new FlushStats(this.flushMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.flushMetric.sum()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocsStats docStats() {
        Engine.Searcher searcher = null;
        try {
            searcher = this.engine.searcher();
            DocsStats docsStats = new DocsStats(searcher.reader().numDocs(), searcher.reader().numDeletedDocs());
            return docsStats;
        }
        catch (Exception e) {
            DocsStats docsStats = new DocsStats();
            return docsStats;
        }
        finally {
            if (searcher != null) {
                searcher.release();
            }
        }
    }

    @Override
    public IndexingStats indexingStats(String ... types) {
        return this.indexingService.stats(types);
    }

    @Override
    public SearchStats searchStats(String ... groups) {
        return this.searchService.stats(groups);
    }

    @Override
    public GetStats getStats() {
        return this.getService.stats();
    }

    @Override
    public StoreStats storeStats() {
        try {
            return this.store.stats();
        }
        catch (IOException e) {
            return new StoreStats();
        }
    }

    @Override
    public MergeStats mergeStats() {
        return this.mergeScheduler.stats();
    }

    @Override
    public WarmerStats warmerStats() {
        return this.shardWarmerService.stats();
    }

    @Override
    public FilterCacheStats filterCacheStats() {
        return this.shardFilterCache.stats();
    }

    @Override
    public FieldDataStats fieldDataStats(String ... fields) {
        return this.shardFieldData.stats(fields);
    }

    @Override
    public IdCacheStats idCacheStats() {
        return this.shardIdCache.stats();
    }

    @Override
    public void flush(Engine.Flush flush) throws ElasticSearchException {
        this.verifyStartedOrRecovering();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("flush with {}", flush);
        }
        long time = System.nanoTime();
        this.engine.flush(flush);
        this.flushMetric.inc(System.nanoTime() - time);
    }

    @Override
    public void optimize(Engine.Optimize optimize) throws ElasticSearchException {
        this.verifyStarted();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("optimize with {}", optimize);
        }
        this.engine.optimize(optimize);
    }

    @Override
    public <T> T snapshot(Engine.SnapshotHandler<T> snapshotHandler) throws EngineException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RELOCATED && state != IndexShardState.CLOSED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed");
        }
        return this.engine.snapshot(snapshotHandler);
    }

    @Override
    public void recover(Engine.RecoveryHandler recoveryHandler) throws EngineException {
        this.verifyStarted();
        this.engine.recover(recoveryHandler);
    }

    @Override
    public Engine.Searcher searcher() {
        this.readAllowed();
        return this.engine.searcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason) {
        Object object = this.mutex;
        synchronized (object) {
            this.indexSettingsService.removeListener(this.applyRefreshSettings);
            if (this.state != IndexShardState.CLOSED) {
                if (this.refreshScheduledFuture != null) {
                    this.refreshScheduledFuture.cancel(true);
                    this.refreshScheduledFuture = null;
                }
                if (this.mergeScheduleFuture != null) {
                    this.mergeScheduleFuture.cancel(true);
                    this.mergeScheduleFuture = null;
                }
            }
            this.logger.debug("state: [{}]->[{}], reason [{}]", new Object[]{this.state, IndexShardState.CLOSED, reason});
            this.state = IndexShardState.CLOSED;
        }
    }

    public long checkIndexTook() {
        return this.checkIndexTook;
    }

    public void performRecoveryPrepareForTranslog() throws ElasticSearchException {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        if (Booleans.parseBoolean(this.checkIndexOnStartup, false)) {
            this.checkIndex(true);
        }
        this.engine.enableGcDeletes(false);
        this.engine.start();
    }

    public RecoveryStatus peerRecoveryStatus() {
        return this.peerRecoveryStatus;
    }

    public void performRecoveryFinalization(boolean withFlush, RecoveryStatus peerRecoveryStatus) throws ElasticSearchException {
        this.performRecoveryFinalization(withFlush);
        this.peerRecoveryStatus = peerRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRecoveryFinalization(boolean withFlush) throws ElasticSearchException {
        if (withFlush) {
            this.engine.flush(new Engine.Flush());
        }
        this.translog.clearUnreferenced();
        this.engine.refresh(new Engine.Refresh(true));
        Object object = this.mutex;
        synchronized (object) {
            this.logger.debug("state: [{}]->[{}], reason [post recovery]", new Object[]{this.state, IndexShardState.STARTED});
            this.state = IndexShardState.STARTED;
        }
        this.startScheduledTasksIfNeeded();
        this.indicesLifecycle.afterIndexShardStarted(this);
        this.engine.enableGcDeletes(true);
    }

    public void performRecoveryOperation(Translog.Operation operation) throws ElasticSearchException {
        block11: {
            if (this.state != IndexShardState.RECOVERING) {
                throw new IndexShardNotRecoveringException(this.shardId, this.state);
            }
            try {
                switch (operation.opType()) {
                    case CREATE: {
                        Translog.Create create = (Translog.Create)operation;
                        this.engine.create(this.prepareCreate(SourceToParse.source(create.source()).type(create.type()).id(create.id()).routing(create.routing()).parent(create.parent()).timestamp(create.timestamp()).ttl(create.ttl())).version(create.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case SAVE: {
                        Translog.Index index = (Translog.Index)operation;
                        this.engine.index(this.prepareIndex(SourceToParse.source(index.source()).type(index.type()).id(index.id()).routing(index.routing()).parent(index.parent()).timestamp(index.timestamp()).ttl(index.ttl())).version(index.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case DELETE: {
                        Translog.Delete delete = (Translog.Delete)operation;
                        Uid uid = Uid.createUid(delete.uid().text());
                        this.engine.delete(new Engine.Delete(uid.type(), uid.id(), delete.uid()).version(delete.version()).origin(Engine.Operation.Origin.RECOVERY));
                        break;
                    }
                    case DELETE_BY_QUERY: {
                        Translog.DeleteByQuery deleteByQuery = (Translog.DeleteByQuery)operation;
                        this.engine.delete(this.prepareDeleteByQuery(deleteByQuery.source(), deleteByQuery.filteringAliases(), deleteByQuery.types()));
                        break;
                    }
                    default: {
                        throw new ElasticSearchIllegalStateException("No operation defined for [" + operation + "]");
                    }
                }
            }
            catch (ElasticSearchException e) {
                boolean hasIgnoreOnRecoveryException = false;
                ElasticSearchException current = e;
                while (true) {
                    if (current instanceof IgnoreOnRecoveryEngineException) {
                        hasIgnoreOnRecoveryException = true;
                        break;
                    }
                    if (!(current.getCause() instanceof ElasticSearchException)) break;
                    current = (ElasticSearchException)current.getCause();
                }
                if (hasIgnoreOnRecoveryException) break block11;
                throw e;
            }
        }
    }

    @Override
    public boolean ignoreRecoveryAttempt() {
        IndexShardState state = this.state();
        return state == IndexShardState.RECOVERING || state == IndexShardState.STARTED || state == IndexShardState.RELOCATED || state == IndexShardState.CLOSED;
    }

    public void readAllowed() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RELOCATED) {
            throw new IllegalIndexShardStateException(this.shardId, state, "Read operations only allowed when started/relocated");
        }
    }

    private void writeAllowed() throws IllegalIndexShardStateException {
        this.verifyStartedOrRecovering();
    }

    private void verifyStartedOrRecovering() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED && state != IndexShardState.RECOVERING) {
            throw new IllegalIndexShardStateException(this.shardId, state, "write operation only allowed when started/recovering");
        }
    }

    private void verifyStarted() throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state != IndexShardState.STARTED) {
            throw new IndexShardNotStartedException(this.shardId, state);
        }
    }

    private void startScheduledTasksIfNeeded() {
        if (this.refreshInterval.millis() > 0L) {
            this.refreshScheduledFuture = this.threadPool.schedule(this.refreshInterval, "same", new EngineRefresher());
            this.logger.debug("scheduling refresher every {}", this.refreshInterval);
        } else {
            this.logger.debug("scheduled refresher disabled", new Object[0]);
        }
        if (this.mergeInterval.millis() > 0L) {
            this.mergeScheduleFuture = this.threadPool.schedule(this.mergeInterval, "same", new EngineMerger());
            this.logger.debug("scheduling optimizer / merger every {}", this.mergeInterval);
        } else {
            this.logger.debug("scheduled optimizer / merger disabled", new Object[0]);
        }
    }

    private Query filterQueryIfNeeded(Query query, String[] types) {
        Filter searchFilter = this.mapperService.searchFilter(types);
        if (searchFilter != null) {
            query = new XFilteredQuery(query, this.indexCache.filter().cache(searchFilter));
        }
        return query;
    }

    private void checkIndex(boolean throwException) throws IndexShardException {
        try {
            this.checkIndexTook = 0L;
            long time = System.currentTimeMillis();
            if (!Lucene.indexExists(this.store.directory())) {
                return;
            }
            CheckIndex checkIndex = new CheckIndex(this.store.directory());
            FastByteArrayOutputStream os = new FastByteArrayOutputStream();
            PrintStream out = new PrintStream((OutputStream)os, false, Streams.UTF8.name());
            checkIndex.setInfoStream(out);
            out.flush();
            CheckIndex.Status status = checkIndex.checkIndex();
            if (!status.clean) {
                if (this.state == IndexShardState.CLOSED) {
                    return;
                }
                this.logger.warn("check index [failure]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
                if ("fix".equalsIgnoreCase(this.checkIndexOnStartup)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("fixing index, writing new segments file ...", new Object[0]);
                    }
                    checkIndex.fixIndex(status, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("index fixed, wrote new segments file \"{}\"", status.segmentsFileName);
                    }
                } else if (throwException) {
                    throw new IndexShardException(this.shardId, "index check failure");
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("check index [success]\n{}", new String(os.bytes().toBytes(), Charsets.UTF_8));
            }
            this.checkIndexTook = System.currentTimeMillis() - time;
        }
        catch (Exception e) {
            this.logger.warn("failed to check index", e, new Object[0]);
        }
    }

    class EngineMerger
    implements Runnable {
        EngineMerger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().possibleMergeNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("merge").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block9: {
                        try {
                            InternalIndexShard.this.engine.maybeMerge();
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (OptimizeFailedEngineException e) {
                            if (!(e.getCause() instanceof EngineClosedException || e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block9;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine optimize/merge", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.mergeScheduleFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.mergeInterval, "same", EngineMerger.this);
                        }
                    }
                }
            });
        }
    }

    class EngineRefresher
    implements Runnable {
        EngineRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InternalIndexShard.this.engine().refreshNeeded()) {
                Object object = InternalIndexShard.this.mutex;
                synchronized (object) {
                    if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", this);
                    }
                }
                return;
            }
            InternalIndexShard.this.threadPool.executor("refresh").execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block10: {
                        try {
                            if (InternalIndexShard.this.engine.refreshNeeded()) {
                                InternalIndexShard.this.refresh(new Engine.Refresh(false));
                            }
                        }
                        catch (EngineClosedException e) {
                        }
                        catch (RefreshFailedEngineException e) {
                            if (!(e.getCause() instanceof InterruptedException || e.getCause() instanceof ClosedByInterruptException || e.getCause() instanceof ThreadInterruptedException || InternalIndexShard.this.state == IndexShardState.CLOSED)) {
                                InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            if (InternalIndexShard.this.state == IndexShardState.CLOSED) break block10;
                            InternalIndexShard.this.logger.warn("Failed to perform scheduled engine refresh", e, new Object[0]);
                        }
                    }
                    Object object = InternalIndexShard.this.mutex;
                    synchronized (object) {
                        if (InternalIndexShard.this.state != IndexShardState.CLOSED) {
                            InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(InternalIndexShard.this.refreshInterval, "same", EngineRefresher.this);
                        }
                    }
                }
            });
        }
    }

    private class ApplyRefreshSettings
    implements IndexSettingsService.Listener {
        private ApplyRefreshSettings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRefreshSettings(Settings settings) {
            Object object = InternalIndexShard.this.mutex;
            synchronized (object) {
                if (InternalIndexShard.this.state == IndexShardState.CLOSED) {
                    return;
                }
                TimeValue refreshInterval = settings.getAsTime("engine.robin.refresh_interval", settings.getAsTime(InternalIndexShard.INDEX_REFRESH_INTERVAL, InternalIndexShard.this.refreshInterval));
                if (!refreshInterval.equals(InternalIndexShard.this.refreshInterval)) {
                    InternalIndexShard.this.logger.info("updating refresh_interval from [{}] to [{}]", InternalIndexShard.this.refreshInterval, refreshInterval);
                    if (InternalIndexShard.this.refreshScheduledFuture != null) {
                        InternalIndexShard.this.refreshScheduledFuture.cancel(false);
                        InternalIndexShard.this.refreshScheduledFuture = null;
                    }
                    InternalIndexShard.this.refreshInterval = refreshInterval;
                    if (refreshInterval.millis() > 0L) {
                        InternalIndexShard.this.refreshScheduledFuture = InternalIndexShard.this.threadPool.schedule(refreshInterval, "same", new EngineRefresher());
                    }
                }
            }
        }
    }
}

