/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.similarity;

import java.util.Map;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.similarity.PreBuiltSimilarityProvider;
import org.elasticsearch.index.similarity.Similarities;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class SimilarityLookupService
extends AbstractIndexComponent {
    private final ImmutableMap<String, SimilarityProvider> similarities;

    public SimilarityLookupService(Index index, Settings indexSettings) {
        this(index, indexSettings, ImmutableMap.of());
    }

    @Inject
    public SimilarityLookupService(Index index, @IndexSettings Settings indexSettings, Map<String, SimilarityProvider.Factory> similarities) {
        super(index, indexSettings);
        MapBuilder<String, SimilarityProvider> providers = MapBuilder.newMapBuilder();
        Map<String, Settings> similaritySettings = indexSettings.getGroups("index.similarity");
        for (Map.Entry<String, SimilarityProvider.Factory> entry : similarities.entrySet()) {
            String name = entry.getKey();
            SimilarityProvider.Factory factory = entry.getValue();
            Settings settings = similaritySettings.get(name);
            if (settings == null) {
                settings = ImmutableSettings.Builder.EMPTY_SETTINGS;
            }
            providers.put(name, factory.create(name, settings));
        }
        for (PreBuiltSimilarityProvider.Factory factory : Similarities.listFactories()) {
            if (providers.containsKey(factory.name())) continue;
            providers.put(factory.name(), factory.get());
        }
        this.similarities = providers.immutableMap();
    }

    public SimilarityProvider similarity(String name) {
        return this.similarities.get(name);
    }
}

