/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.distributor;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RateLimitedFSDirectory;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.distributor.Distributor;

public abstract class AbstractDistributor
implements Distributor {
    protected final Directory[] delegates;

    protected AbstractDistributor(DirectoryService directoryService) throws IOException {
        this.delegates = directoryService.build();
    }

    @Override
    public Directory[] all() {
        return this.delegates;
    }

    @Override
    public Directory primary() {
        return this.delegates[0];
    }

    @Override
    public Directory any() {
        if (this.delegates.length == 1) {
            return this.delegates[0];
        }
        return this.doAny();
    }

    protected long getUsableSpace(Directory directory) {
        if (directory instanceof RateLimitedFSDirectory) {
            return ((RateLimitedFSDirectory)directory).wrappedDirectory().getDirectory().getUsableSpace();
        }
        if (directory instanceof FSDirectory) {
            return ((FSDirectory)directory).getDirectory().getUsableSpace();
        }
        return 0L;
    }

    public String toString() {
        return this.name() + Arrays.toString(this.delegates);
    }

    protected abstract Directory doAny();

    protected abstract String name();
}

