/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.cache.filter.terms;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.indices.cache.filter.terms.TermsLookup;

public class IndicesTermsFilterCache
extends AbstractComponent {
    private static TermsFilterValue NO_TERMS = new TermsFilterValue(0L, null);
    private final Client client;
    private final Cache<CacheKeyFilter.Key, TermsFilterValue> cache;

    @Inject
    public IndicesTermsFilterCache(Settings settings, Client client) {
        super(settings);
        this.client = client;
        ByteSizeValue size = this.componentSettings.getAsBytesSize("size", new ByteSizeValue(10L, ByteSizeUnit.MB));
        TimeValue expireAfterWrite = this.componentSettings.getAsTime("expire_after_write", null);
        TimeValue expireAfterAccess = this.componentSettings.getAsTime("expire_after_access", null);
        CacheBuilder<CacheKeyFilter.Key, TermsFilterValue> builder = CacheBuilder.newBuilder().maximumWeight(size.bytes()).weigher(new TermsFilterValueWeigher());
        if (expireAfterAccess != null) {
            builder.expireAfterAccess(expireAfterAccess.millis(), TimeUnit.MILLISECONDS);
        }
        if (expireAfterWrite != null) {
            builder.expireAfterWrite(expireAfterWrite.millis(), TimeUnit.MILLISECONDS);
        }
        this.cache = builder.build();
    }

    public Filter lookupTermsFilter(CacheKeyFilter.Key cacheKey, TermsLookup lookup) {
        return new LookupTermsFilter(lookup, cacheKey, this);
    }

    @Nullable
    private Filter termsFilter(CacheKeyFilter.Key cacheKey, final TermsLookup lookup) throws RuntimeException {
        try {
            return this.cache.get((CacheKeyFilter.Key)cacheKey, (Callable<TermsFilterValue>)new Callable<TermsFilterValue>(){

                @Override
                public TermsFilterValue call() throws Exception {
                    GetResponse getResponse = IndicesTermsFilterCache.this.client.get(new GetRequest(lookup.getIndex(), lookup.getType(), lookup.getId()).preference("_local")).actionGet();
                    if (!getResponse.isExists()) {
                        return NO_TERMS;
                    }
                    List<Object> values = XContentMapValues.extractRawValues(lookup.getPath(), getResponse.getSourceAsMap());
                    if (values.isEmpty()) {
                        return NO_TERMS;
                    }
                    Filter filter = lookup.getFieldMapper().termsFilter(values, lookup.getQueryParseContext());
                    return new TermsFilterValue(IndicesTermsFilterCache.this.estimateSizeInBytes(values), filter);
                }
            }).filter;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new ElasticSearchException(e.getMessage(), e.getCause());
        }
    }

    long estimateSizeInBytes(List<Object> terms) {
        long size = 8L;
        for (Object term : terms) {
            if (term instanceof BytesRef) {
                size += (long)((BytesRef)term).length;
                continue;
            }
            if (term instanceof String) {
                size += (long)(((String)term).length() / 2);
                continue;
            }
            size += 4L;
        }
        return size;
    }

    public void clear(String reason) {
        this.cache.invalidateAll();
    }

    public void clear(String reason, String[] keys) {
        for (String key : keys) {
            this.cache.invalidate(new CacheKeyFilter.Key(key));
        }
    }

    static class TermsFilterValue {
        public final long sizeInBytes;
        public final Filter filter;

        TermsFilterValue(long sizeInBytes, Filter filter) {
            this.sizeInBytes = sizeInBytes;
            this.filter = filter;
        }
    }

    static class TermsFilterValueWeigher
    implements Weigher<CacheKeyFilter.Key, TermsFilterValue> {
        TermsFilterValueWeigher() {
        }

        @Override
        public int weigh(CacheKeyFilter.Key key, TermsFilterValue value) {
            return (int)((long)key.bytes().length + value.sizeInBytes);
        }
    }

    static class LookupTermsFilter
    extends Filter
    implements CacheKeyFilter {
        private final TermsLookup lookup;
        private final CacheKeyFilter.Key cacheKey;
        private final IndicesTermsFilterCache cache;

        LookupTermsFilter(TermsLookup lookup, CacheKeyFilter.Key cacheKey, IndicesTermsFilterCache cache) {
            this.lookup = lookup;
            this.cacheKey = cacheKey;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            Filter filter = this.cache.termsFilter(this.cacheKey, this.lookup);
            if (filter == null) {
                return null;
            }
            return filter.getDocIdSet(context, acceptDocs);
        }

        @Override
        public CacheKeyFilter.Key cacheKey() {
            return this.cacheKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupTermsFilter that = (LookupTermsFilter)o;
            return this.cacheKey.equals(that.cacheKey);
        }

        public int hashCode() {
            return this.cacheKey.hashCode();
        }

        public String toString() {
            return "terms(" + this.lookup.toString() + ")";
        }
    }
}

