/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster.settings;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestXContentBuilder;

public class RestClusterUpdateSettingsAction
extends BaseRestHandler {
    @Inject
    public RestClusterUpdateSettingsAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.PUT, "/_cluster/settings", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        ClusterUpdateSettingsRequest clusterUpdateSettingsRequest = Requests.clusterUpdateSettingsRequest();
        clusterUpdateSettingsRequest.listenerThreaded(false);
        try {
            Map<String, Object> source = XContentFactory.xContent(request.content()).createParser(request.content()).mapAndClose();
            if (source.containsKey("transient")) {
                clusterUpdateSettingsRequest.transientSettings((Map)source.get("transient"));
            }
            if (source.containsKey("persistent")) {
                clusterUpdateSettingsRequest.persistentSettings((Map)source.get("persistent"));
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new XContentThrowableRestResponse(request, e));
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send response", e1, new Object[0]);
            }
            return;
        }
        this.client.admin().cluster().updateSettings(clusterUpdateSettingsRequest, new ActionListener<ClusterUpdateSettingsResponse>(){

            @Override
            public void onResponse(ClusterUpdateSettingsResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    builder.startObject("persistent");
                    for (Map.Entry entry : response.getPersistentSettings().getAsMap().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.startObject("transient");
                    for (Map.Entry entry : response.getTransientSettings().getAsMap().entrySet()) {
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                if (RestClusterUpdateSettingsAction.this.logger.isDebugEnabled()) {
                    RestClusterUpdateSettingsAction.this.logger.debug("failed to handle cluster state", e, new Object[0]);
                }
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestClusterUpdateSettingsAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

