/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.warmer.get;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.warmer.IndexWarmerMissingException;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;

public class RestGetWarmerAction
extends BaseRestHandler {
    @Inject
    public RestGetWarmerAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmer", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_warmer/{name}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_warmer/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        final String[] indices = RestActions.splitIndices(request.param("index"));
        final String name = request.param("name");
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest().filterAll().filterMetaData(false).filteredIndices(indices);
        clusterStateRequest.listenerThreaded(false);
        this.client.admin().cluster().state(clusterStateRequest, new ActionListener<ClusterStateResponse>(){

            @Override
            public void onResponse(ClusterStateResponse response) {
                try {
                    MetaData metaData = response.getState().metaData();
                    if (indices.length == 1 && metaData.indices().isEmpty()) {
                        channel.sendResponse(new XContentThrowableRestResponse(request, new IndexMissingException(new Index(indices[0]))));
                        return;
                    }
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    boolean wroteOne = false;
                    for (IndexMetaData indexMetaData : metaData) {
                        IndexWarmersMetaData warmers = (IndexWarmersMetaData)indexMetaData.custom("warmers");
                        if (warmers == null) continue;
                        boolean foundOne = false;
                        for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                            if (name != null && !Regex.simpleMatch(name, entry.name())) continue;
                            foundOne = true;
                            wroteOne = true;
                            break;
                        }
                        if (!foundOne) continue;
                        builder.startObject(indexMetaData.index(), XContentBuilder.FieldCaseConversion.NONE);
                        builder.startObject("warmers", XContentBuilder.FieldCaseConversion.NONE);
                        for (IndexWarmersMetaData.Entry entry : warmers.entries()) {
                            if (name != null && !Regex.simpleMatch(name, entry.name())) continue;
                            IndexWarmersMetaData.FACTORY.toXContent(entry, builder, (ToXContent.Params)request);
                        }
                        builder.endObject();
                        builder.endObject();
                    }
                    builder.endObject();
                    if (!wroteOne && name != null) {
                        channel.sendResponse(new XContentThrowableRestResponse(request, new IndexWarmerMissingException(name)));
                        return;
                    }
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestGetWarmerAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

