/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.get;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class RestHeadAction
extends BaseRestHandler {
    @Inject
    public RestHeadAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}/_source", this);
    }

    @Override
    public void handleRequest(RestRequest request, final RestChannel channel) {
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.listenerThreaded(false);
        getRequest.operationThreaded(true);
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.parent(request.param("parent"));
        getRequest.routing(request.param("routing"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBooleanOptional("realtime", null));
        getRequest.fields(Strings.EMPTY_ARRAY);
        this.client.get(getRequest, new ActionListener<GetResponse>(){

            @Override
            public void onResponse(GetResponse response) {
                try {
                    if (!response.isExists()) {
                        channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
                    } else {
                        channel.sendResponse(new StringRestResponse(RestStatus.OK));
                    }
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new StringRestResponse(ExceptionsHelper.status(e)));
                }
                catch (Exception e1) {
                    RestHeadAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

