/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.suggest;

import java.io.IOException;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.suggest.SuggestRequest;
import org.elasticsearch.action.suggest.SuggestResponse;
import org.elasticsearch.action.support.IgnoreIndices;
import org.elasticsearch.action.support.broadcast.BroadcastOperationThreading;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.XContentRestResponse;
import org.elasticsearch.rest.XContentThrowableRestResponse;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestXContentBuilder;
import org.elasticsearch.search.suggest.Suggest;

public class RestSuggestAction
extends BaseRestHandler {
    @Inject
    public RestSuggestAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.POST, "/_suggest", this);
        controller.registerHandler(RestRequest.Method.GET, "/_suggest", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_suggest", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_suggest", this);
    }

    @Override
    public void handleRequest(final RestRequest request, final RestChannel channel) {
        SuggestRequest suggestRequest = new SuggestRequest(RestActions.splitIndices(request.param("index")));
        if (request.hasParam("ignore_indices")) {
            suggestRequest.ignoreIndices(IgnoreIndices.fromString(request.param("ignore_indices")));
        }
        suggestRequest.listenerThreaded(false);
        try {
            BroadcastOperationThreading operationThreading = BroadcastOperationThreading.fromString(request.param("operation_threading"), BroadcastOperationThreading.SINGLE_THREAD);
            if (operationThreading == BroadcastOperationThreading.NO_THREADS) {
                operationThreading = BroadcastOperationThreading.SINGLE_THREAD;
            }
            suggestRequest.operationThreading(operationThreading);
            if (request.hasContent()) {
                suggestRequest.suggest(request.content(), request.contentUnsafe());
            } else {
                String source = request.param("source");
                if (source != null) {
                    suggestRequest.suggest(source);
                } else {
                    throw new ElasticSearchIllegalArgumentException("no content or source provided to execute suggestion");
                }
            }
            suggestRequest.routing(request.param("routing"));
            suggestRequest.preference(request.param("preference"));
        }
        catch (Exception e) {
            try {
                XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                channel.sendResponse(new XContentRestResponse(request, RestStatus.BAD_REQUEST, builder.startObject().field("error", e.getMessage()).endObject()));
            }
            catch (IOException e1) {
                this.logger.error("Failed to send failure response", e1, new Object[0]);
            }
            return;
        }
        this.client.suggest(suggestRequest, new ActionListener<SuggestResponse>(){

            @Override
            public void onResponse(SuggestResponse response) {
                try {
                    XContentBuilder builder = RestXContentBuilder.restContentBuilder(request);
                    builder.startObject();
                    RestActions.buildBroadcastShardsHeader(builder, response);
                    Suggest suggest = response.getSuggest();
                    if (suggest != null) {
                        suggest.toXContent(builder, request);
                    }
                    builder.endObject();
                    channel.sendResponse(new XContentRestResponse(request, RestStatus.OK, builder));
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new XContentThrowableRestResponse(request, e));
                }
                catch (IOException e1) {
                    RestSuggestAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

