/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.routing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.river.RiverIndexName;
import org.elasticsearch.river.RiverName;
import org.elasticsearch.river.cluster.RiverClusterService;
import org.elasticsearch.river.cluster.RiverClusterState;
import org.elasticsearch.river.cluster.RiverClusterStateUpdateTask;
import org.elasticsearch.river.cluster.RiverNodeHelper;
import org.elasticsearch.river.routing.RiverRouting;
import org.elasticsearch.river.routing.RiversRouting;

public class RiversRouter
extends AbstractLifecycleComponent<RiversRouter>
implements ClusterStateListener {
    private final String riverIndexName;
    private final Client client;
    private final RiverClusterService riverClusterService;

    @Inject
    public RiversRouter(Settings settings, Client client, ClusterService clusterService, RiverClusterService riverClusterService) {
        super(settings);
        this.riverIndexName = RiverIndexName.Conf.indexName(settings);
        this.riverClusterService = riverClusterService;
        this.client = client;
        clusterService.add(this);
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
    }

    @Override
    public void clusterChanged(final ClusterChangedEvent event) {
        if (!event.localNodeMaster()) {
            return;
        }
        this.riverClusterService.submitStateUpdateTask("reroute_rivers_node_changed", new RiverClusterStateUpdateTask(){

            @Override
            public RiverClusterState execute(RiverClusterState currentState) {
                if (!event.state().metaData().hasIndex(RiversRouter.this.riverIndexName)) {
                    if (!currentState.routing().isEmpty()) {
                        return RiverClusterState.builder().state(currentState).routing(RiversRouting.builder()).build();
                    }
                    return currentState;
                }
                RiversRouting.Builder routingBuilder = RiversRouting.builder().routing(currentState.routing());
                boolean dirty = false;
                IndexMetaData indexMetaData = event.state().metaData().index(RiversRouter.this.riverIndexName);
                for (MappingMetaData mappingMd : indexMetaData.mappings().values()) {
                    String mappingType = mappingMd.type();
                    if (currentState.routing().hasRiverByName(mappingType)) continue;
                    try {
                        GetResponse getResponse = (GetResponse)RiversRouter.this.client.prepareGet(RiversRouter.this.riverIndexName, mappingType, "_meta").execute().actionGet();
                        if (!getResponse.isExists()) continue;
                        String riverType = XContentMapValues.nodeStringValue(getResponse.getSourceAsMap().get("type"), null);
                        if (riverType == null) {
                            RiversRouter.this.logger.warn("no river type provided for [{}], ignoring...", RiversRouter.this.riverIndexName);
                            continue;
                        }
                        routingBuilder.put(new RiverRouting(new RiverName(riverType, mappingType), null));
                        dirty = true;
                    }
                    catch (NoShardAvailableActionException e) {
                    }
                    catch (ClusterBlockException e) {
                    }
                    catch (IndexMissingException e) {
                    }
                    catch (Exception e) {
                        RiversRouter.this.logger.warn("failed to get/parse _meta for [{}]", e, mappingType);
                    }
                }
                for (RiverRouting routing : currentState.routing()) {
                    if (!indexMetaData.mappings().containsKey(routing.riverName().name())) {
                        routingBuilder.remove(routing);
                        dirty = true;
                        continue;
                    }
                    if (routing.node() == null || event.state().nodes().nodeExists(routing.node().id())) continue;
                    routingBuilder.remove(routing);
                    routingBuilder.put(new RiverRouting(routing.riverName(), null));
                    dirty = true;
                }
                HashMap nodesToRivers = Maps.newHashMap();
                for (DiscoveryNode node : event.state().nodes()) {
                    if (!RiverNodeHelper.isRiverNode(node)) continue;
                    nodesToRivers.put(node, Lists.newArrayList());
                }
                ArrayList<RiverRouting> unassigned = Lists.newArrayList();
                for (RiverRouting routing : routingBuilder.build()) {
                    if (routing.node() == null) {
                        unassigned.add(routing);
                        continue;
                    }
                    ArrayList<RiverRouting> l = (ArrayList<RiverRouting>)nodesToRivers.get(routing.node());
                    if (l == null) {
                        l = Lists.newArrayList();
                        nodesToRivers.put(routing.node(), l);
                    }
                    l.add(routing);
                }
                Iterator it = unassigned.iterator();
                while (it.hasNext()) {
                    RiverRouting routing;
                    routing = (RiverRouting)it.next();
                    DiscoveryNode smallest = null;
                    int smallestSize = Integer.MAX_VALUE;
                    for (Map.Entry entry : nodesToRivers.entrySet()) {
                        if (!RiverNodeHelper.isRiverNode((DiscoveryNode)entry.getKey(), routing.riverName()) || ((List)entry.getValue()).size() >= smallestSize) continue;
                        smallestSize = ((List)entry.getValue()).size();
                        smallest = (DiscoveryNode)entry.getKey();
                    }
                    if (smallest == null) continue;
                    dirty = true;
                    it.remove();
                    routing.node(smallest);
                    ((List)nodesToRivers.get(smallest)).add(routing);
                }
                if (dirty) {
                    return RiverClusterState.builder().state(currentState).routing(routingBuilder).build();
                }
                return currentState;
            }
        });
    }
}

