/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.TopDocs;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.search.stats.StatsGroupsParseElement;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.warmer.IndicesWarmer;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchContextMissingException;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.dfs.CachedDfSource;
import org.elasticsearch.search.dfs.DfsPhase;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.fetch.FetchPhase;
import org.elasticsearch.search.fetch.FetchSearchRequest;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.QueryFetchSearchResult;
import org.elasticsearch.search.fetch.ScrollQueryFetchSearchResult;
import org.elasticsearch.search.internal.InternalScrollSearchRequest;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.query.QueryPhase;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchRequest;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.query.ScrollQuerySearchResult;
import org.elasticsearch.search.warmer.IndexWarmersMetaData;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchService
extends AbstractLifecycleComponent<SearchService> {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final IndicesWarmer indicesWarmer;
    private final ScriptService scriptService;
    private final DfsPhase dfsPhase;
    private final QueryPhase queryPhase;
    private final FetchPhase fetchPhase;
    private final long defaultKeepAlive;
    private final ScheduledFuture keepAliveReaper;
    private final AtomicLong idGenerator = new AtomicLong();
    private final CleanContextOnIndicesLifecycleListener indicesLifecycleListener = new CleanContextOnIndicesLifecycleListener();
    private final ConcurrentMapLong<SearchContext> activeContexts = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final ImmutableMap<String, SearchParseElement> elementParsers;
    private static final int[] EMPTY_DOC_IDS = new int[0];

    @Inject
    public SearchService(Settings settings, ClusterService clusterService, IndicesService indicesService, IndicesLifecycle indicesLifecycle, IndicesWarmer indicesWarmer, ThreadPool threadPool, ScriptService scriptService, DfsPhase dfsPhase, QueryPhase queryPhase, FetchPhase fetchPhase) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.indicesWarmer = indicesWarmer;
        this.scriptService = scriptService;
        this.dfsPhase = dfsPhase;
        this.queryPhase = queryPhase;
        this.fetchPhase = fetchPhase;
        TimeValue keepAliveInterval = this.componentSettings.getAsTime("keep_alive_interval", TimeValue.timeValueMinutes(1L));
        this.defaultKeepAlive = this.componentSettings.getAsTime("default_keep_alive", TimeValue.timeValueMinutes(5L)).millis();
        HashMap<String, ? extends SearchParseElement> elementParsers = new HashMap<String, SearchParseElement>();
        elementParsers.putAll(dfsPhase.parseElements());
        elementParsers.putAll(queryPhase.parseElements());
        elementParsers.putAll(fetchPhase.parseElements());
        elementParsers.put("stats", new StatsGroupsParseElement());
        this.elementParsers = ImmutableMap.copyOf(elementParsers);
        indicesLifecycle.addListener(this.indicesLifecycleListener);
        this.keepAliveReaper = threadPool.scheduleWithFixedDelay(new Reaper(), keepAliveInterval);
        this.indicesWarmer.addListener(new SearchWarmer());
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
        for (SearchContext context : this.activeContexts.values()) {
            this.freeContext(context);
        }
        this.activeContexts.clear();
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.keepAliveReaper.cancel(false);
        this.indicesService.indicesLifecycle().removeListener(this.indicesLifecycleListener);
    }

    public void releaseContextsForIndex(Index index) {
        for (SearchContext context : this.activeContexts.values()) {
            if (!context.shardTarget().index().equals(index.name())) continue;
            this.freeContext(context);
        }
    }

    public void releaseContextsForShard(ShardId shardId) {
        for (SearchContext context : this.activeContexts.values()) {
            if (!context.shardTarget().index().equals(shardId.index().name()) || context.shardTarget().shardId() != shardId.id()) continue;
            this.freeContext(context);
        }
    }

    public DfsSearchResult executeDfsPhase(ShardSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createAndPutContext(request);
        try {
            this.contextProcessing(context);
            this.dfsPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            DfsSearchResult dfsSearchResult = context.dfsResult();
            return dfsSearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Dfs phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeScan(ShardSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createAndPutContext(request);
        assert (context.searchType() == SearchType.SCAN);
        context.searchType(SearchType.COUNT);
        assert (context.searchType() == SearchType.COUNT);
        try {
            if (context.scroll() == null) {
                throw new ElasticSearchException("Scroll must be provided when scanning...");
            }
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeScan(InternalScrollSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            if (context.searchType() == SearchType.COUNT) {
                context.searchType(SearchType.SCAN);
                context.from(0);
            }
            this.queryPhase.execute(context);
            this.shortcutDocIdsToLoadForScanning(context);
            this.fetchPhase.execute(context);
            if (context.scroll() == null || context.fetchResult().hits().hits().length < context.size()) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Scan phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(ShardSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createAndPutContext(request);
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.queryPhase.execute(context);
            if (context.searchType() == SearchType.COUNT) {
                this.freeContext(context.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (RuntimeException e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQuerySearchResult executeQueryPhase(InternalScrollSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.contextProcessing(context);
            this.processScroll(request, context);
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            ScrollQuerySearchResult scrollQuerySearchResult = new ScrollQuerySearchResult(context.queryResult(), context.shardTarget());
            return scrollQuerySearchResult;
        }
        catch (RuntimeException e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QuerySearchResult executeQueryPhase(QuerySearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(context.searcher().getIndexReader(), request.dfs(), context.similarityService().similarity()));
        }
        catch (IOException e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", (Throwable)e);
        }
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            this.queryPhase.execute(context);
            this.contextProcessedSuccessfully(context);
            context.indexShard().searchService().onQueryPhase(context, System.nanoTime() - time);
            QuerySearchResult querySearchResult = context.queryResult();
            return querySearchResult;
        }
        catch (RuntimeException e) {
            context.indexShard().searchService().onFailedQueryPhase(context);
            this.logger.trace("Query phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(ShardSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createAndPutContext(request);
        this.contextProcessing(context);
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw e;
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(context.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw e;
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public QueryFetchSearchResult executeFetchPhase(QuerySearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.searcher().dfSource(new CachedDfSource(context.searcher().getIndexReader(), request.dfs(), context.similarityService().similarity()));
        }
        catch (IOException e) {
            this.freeContext(context);
            this.cleanContext(context);
            throw new QueryPhaseExecutionException(context, "Failed to set aggregated df", (Throwable)e);
        }
        try {
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw e;
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw e;
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            QueryFetchSearchResult queryFetchSearchResult = new QueryFetchSearchResult(context.queryResult(), context.fetchResult());
            return queryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public ScrollQueryFetchSearchResult executeFetchPhase(InternalScrollSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            this.processScroll(request, context);
            context.indexShard().searchService().onPreQueryPhase(context);
            long time = System.nanoTime();
            try {
                this.queryPhase.execute(context);
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedQueryPhase(context);
                throw e;
            }
            long time2 = System.nanoTime();
            context.indexShard().searchService().onQueryPhase(context, time2 - time);
            context.indexShard().searchService().onPreFetchPhase(context);
            try {
                this.shortcutDocIdsToLoad(context);
                this.fetchPhase.execute(context);
                if (context.scroll() == null) {
                    this.freeContext(request.id());
                } else {
                    this.contextProcessedSuccessfully(context);
                }
            }
            catch (RuntimeException e) {
                context.indexShard().searchService().onFailedFetchPhase(context);
                throw e;
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time2);
            ScrollQueryFetchSearchResult scrollQueryFetchSearchResult = new ScrollQueryFetchSearchResult(new QueryFetchSearchResult(context.queryResult(), context.fetchResult()), context.shardTarget());
            return scrollQueryFetchSearchResult;
        }
        catch (RuntimeException e) {
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    public FetchSearchResult executeFetchPhase(FetchSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.findContext(request.id());
        this.contextProcessing(context);
        try {
            context.docIdsToLoad(request.docIds(), 0, request.docIdsSize());
            context.indexShard().searchService().onPreFetchPhase(context);
            long time = System.nanoTime();
            this.fetchPhase.execute(context);
            if (context.scroll() == null) {
                this.freeContext(request.id());
            } else {
                this.contextProcessedSuccessfully(context);
            }
            context.indexShard().searchService().onFetchPhase(context, System.nanoTime() - time);
            FetchSearchResult fetchSearchResult = context.fetchResult();
            return fetchSearchResult;
        }
        catch (RuntimeException e) {
            context.indexShard().searchService().onFailedFetchPhase(context);
            this.logger.trace("Fetch phase failed", e, new Object[0]);
            this.freeContext(context);
            throw e;
        }
        finally {
            this.cleanContext(context);
        }
    }

    private SearchContext findContext(long id) throws SearchContextMissingException {
        SearchContext context = this.activeContexts.get(id);
        if (context == null) {
            throw new SearchContextMissingException(id);
        }
        SearchContext.setCurrent(context);
        return context;
    }

    SearchContext createAndPutContext(ShardSearchRequest request) throws ElasticSearchException {
        SearchContext context = this.createContext(request);
        this.activeContexts.put(context.id(), context);
        context.indexShard().searchService().onNewContext(context);
        return context;
    }

    SearchContext createContext(ShardSearchRequest request) throws ElasticSearchException {
        return this.createContext(request, null);
    }

    SearchContext createContext(ShardSearchRequest request, @Nullable Engine.Searcher searcher) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        IndexShard indexShard = indexService.shardSafe(request.shardId());
        SearchShardTarget shardTarget = new SearchShardTarget(this.clusterService.localNode().id(), request.index(), request.shardId());
        Engine.Searcher engineSearcher = searcher == null ? indexShard.searcher() : searcher;
        SearchContext context = new SearchContext(this.idGenerator.incrementAndGet(), request, shardTarget, engineSearcher, indexService, indexShard, this.scriptService);
        SearchContext.setCurrent(context);
        try {
            context.scroll(request.scroll());
            this.parseSource(context, request.source());
            this.parseSource(context, request.extraSource());
            if (context.from() == -1) {
                context.from(0);
            }
            if (context.size() == -1) {
                context.size(10);
            }
            this.dfsPhase.preProcess(context);
            this.queryPhase.preProcess(context);
            this.fetchPhase.preProcess(context);
            long keepAlive = this.defaultKeepAlive;
            if (request.scroll() != null && request.scroll().keepAlive() != null) {
                keepAlive = request.scroll().keepAlive().millis();
            }
            context.keepAlive(keepAlive);
        }
        catch (RuntimeException e) {
            context.release();
            throw e;
        }
        return context;
    }

    public void freeContext(long id) {
        SearchContext context = this.activeContexts.remove(id);
        if (context == null) {
            return;
        }
        context.indexShard().searchService().onFreeContext(context);
        context.release();
    }

    private void freeContext(SearchContext context) {
        SearchContext removed = this.activeContexts.remove(context.id());
        if (removed != null) {
            removed.indexShard().searchService().onFreeContext(removed);
        }
        context.release();
    }

    private void contextProcessing(SearchContext context) {
        context.accessed(-1L);
    }

    private void contextProcessedSuccessfully(SearchContext context) {
        context.accessed(this.threadPool.estimatedTimeInMillis());
    }

    private void cleanContext(SearchContext context) {
        SearchContext.removeCurrent();
    }

    private void parseSource(SearchContext context, BytesReference source) throws SearchParseException {
        if (source == null || source.length() == 0) {
            return;
        }
        XContentParser parser = null;
        try {
            XContentParser.Token token;
            parser = XContentFactory.xContent(source).createParser(source);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    String fieldName = parser.currentName();
                    parser.nextToken();
                    SearchParseElement element = this.elementParsers.get(fieldName);
                    if (element == null) {
                        throw new SearchParseException(context, "No parser for element [" + fieldName + "]");
                    }
                    element.parse(parser, context);
                    continue;
                }
                if (token != null) continue;
                break;
            }
        }
        catch (Exception e) {
            String sSource = "_na_";
            try {
                sSource = XContentHelper.convertToJson(source, false);
            }
            catch (Throwable e1) {
                // empty catch block
            }
            throw new SearchParseException(context, "Failed to parse source [" + sSource + "]", (Throwable)e);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    private void shortcutDocIdsToLoad(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length < context.from()) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int totalSize = context.from() + context.size();
        int[] docIdsToLoad = new int[context.size()];
        int counter = 0;
        for (int i = context.from(); i < totalSize && i < topDocs.scoreDocs.length; ++i) {
            docIdsToLoad[counter] = topDocs.scoreDocs[i].doc;
            ++counter;
        }
        context.docIdsToLoad(docIdsToLoad, 0, counter);
    }

    private void shortcutDocIdsToLoadForScanning(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs();
        if (topDocs.scoreDocs.length == 0) {
            context.docIdsToLoad(EMPTY_DOC_IDS, 0, 0);
            return;
        }
        int[] docIdsToLoad = new int[topDocs.scoreDocs.length];
        for (int i = 0; i < docIdsToLoad.length; ++i) {
            docIdsToLoad[i] = topDocs.scoreDocs[i].doc;
        }
        context.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
    }

    private void processScroll(InternalScrollSearchRequest request, SearchContext context) {
        context.from(context.from() + context.size());
        context.scroll(request.scroll());
        if (request.scroll() != null && request.scroll().keepAlive() != null) {
            context.keepAlive(request.scroll().keepAlive().millis());
        }
    }

    class Reaper
    implements Runnable {
        Reaper() {
        }

        @Override
        public void run() {
            long time = SearchService.this.threadPool.estimatedTimeInMillis();
            for (SearchContext context : SearchService.this.activeContexts.values()) {
                if (context.lastAccessTime() == -1L || time - context.lastAccessTime() <= context.keepAlive()) continue;
                SearchService.this.freeContext(context);
            }
        }
    }

    class CleanContextOnIndicesLifecycleListener
    extends IndicesLifecycle.Listener {
        CleanContextOnIndicesLifecycleListener() {
        }

        @Override
        public void beforeIndexClosed(IndexService indexService) {
            SearchService.this.releaseContextsForIndex(indexService.index());
        }

        @Override
        public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard) {
            SearchService.this.releaseContextsForShard(shardId);
        }
    }

    class SearchWarmer
    extends IndicesWarmer.Listener {
        SearchWarmer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void warm(IndexShard indexShard, IndexMetaData indexMetaData, IndicesWarmer.WarmerContext warmerContext) {
            IndexWarmersMetaData custom = (IndexWarmersMetaData)indexMetaData.custom("warmers");
            if (custom == null) {
                return;
            }
            for (IndexWarmersMetaData.Entry entry : custom.entries()) {
                SearchContext context = null;
                try {
                    long now = System.nanoTime();
                    ShardSearchRequest request = new ShardSearchRequest(indexShard.shardId().index().name(), indexShard.shardId().id(), indexMetaData.numberOfShards(), SearchType.QUERY_THEN_FETCH).source(entry.source()).types(entry.types());
                    context = SearchService.this.createContext(request, warmerContext.newSearcher());
                    SearchService.this.queryPhase.execute(context);
                    long took = System.nanoTime() - now;
                    if (indexShard.warmerService().logger().isTraceEnabled()) {
                        indexShard.warmerService().logger().trace("warmed [{}], took [{}]", entry.name(), TimeValue.timeValueNanos(took));
                    }
                    if (context == null) continue;
                }
                catch (Throwable t) {
                    try {
                        indexShard.warmerService().logger().warn("warmer [{}] failed", t, entry.name());
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (context == null) continue;
                        SearchService.this.freeContext(context);
                        SearchService.this.cleanContext(context);
                        continue;
                    }
                }
                SearchService.this.freeContext(context);
                SearchService.this.cleanContext(context);
            }
        }
    }
}

