/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.TermStatistics;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.XMaps;
import org.elasticsearch.common.trove.set.hash.THashSet;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.dfs.DfsPhaseExecutionException;
import org.elasticsearch.search.internal.SearchContext;

public class DfsPhase
implements SearchPhase {
    private static ThreadLocal<THashSet<Term>> cachedTermsSet = new ThreadLocal<THashSet<Term>>(){

        @Override
        protected THashSet<Term> initialValue() {
            return new THashSet<Term>();
        }
    };

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) {
        THashSet<Term> termsSet = null;
        try {
            if (!context.queryRewritten()) {
                context.updateRewriteQuery(context.searcher().rewrite(context.query()));
            }
            if (!(termsSet = cachedTermsSet.get()).isEmpty()) {
                termsSet.clear();
            }
            context.query().extractTerms(termsSet);
            if (context.rescore() != null) {
                context.rescore().rescorer().extractTerms(context, context.rescore(), termsSet);
            }
            Term[] terms = termsSet.toArray(new Term[termsSet.size()]);
            TermStatistics[] termStatistics = new TermStatistics[terms.length];
            IndexReaderContext indexReaderContext = context.searcher().getTopReaderContext();
            for (int i = 0; i < terms.length; ++i) {
                TermContext termContext = TermContext.build((IndexReaderContext)indexReaderContext, (Term)terms[i], (boolean)false);
                termStatistics[i] = context.searcher().termStatistics(terms[i], termContext);
            }
            Map<String, CollectionStatistics> fieldStatistics = XMaps.newNoNullKeysMap();
            for (Term term : terms) {
                assert (term.field() != null) : "field is null";
                if (fieldStatistics.containsKey(term.field())) continue;
                CollectionStatistics collectionStatistics = context.searcher().collectionStatistics(term.field());
                fieldStatistics.put(term.field(), collectionStatistics);
            }
            context.dfsResult().termsStatistics(terms, termStatistics).fieldStatistics(fieldStatistics).maxDoc(context.searcher().getIndexReader().maxDoc());
        }
        catch (Exception e) {
            throw new DfsPhaseExecutionException(context, "Exception during dfs phase", (Throwable)e);
        }
        finally {
            if (termsSet != null) {
                termsSet.clear();
            }
        }
    }
}

