/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import org.elasticsearch.index.fielddata.DoubleValues;

public abstract class DoubleFacetAggregatorBase {
    private int total;
    private int missing;

    public void onDoc(int docId, DoubleValues values) {
        if (values.hasValue(docId)) {
            DoubleValues.Iter iter = values.getIter(docId);
            while (iter.hasNext()) {
                this.onValue(docId, iter.next());
                ++this.total;
            }
        } else {
            ++this.missing;
        }
    }

    protected abstract void onValue(int var1, double var2);

    public final int total() {
        return this.total;
    }

    public final int missing() {
        return this.missing;
    }
}

