/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet;

import java.util.ArrayList;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetParsers;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.facet.nested.NestedFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class FacetParseElement
implements SearchParseElement {
    private final FacetParsers facetParsers;

    @Inject
    public FacetParseElement(FacetParsers facetParsers) {
        this.facetParsers = facetParsers;
    }

    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        XContentParser.Token token;
        ArrayList<SearchContextFacets.Entry> entries = new ArrayList<SearchContextFacets.Entry>();
        String facetName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                facetName = parser.currentName();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            FacetExecutor facetExecutor = null;
            boolean global = false;
            FacetExecutor.Mode defaultMainMode = null;
            FacetExecutor.Mode defaultGlobalMode = null;
            FacetExecutor.Mode mode = null;
            Filter filter = null;
            boolean cacheFilter = false;
            String nestedPath = null;
            String fieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    fieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("facet_filter".equals(fieldName) || "facetFilter".equals(fieldName)) {
                        filter = context.queryParserService().parseInnerFilter(parser);
                        continue;
                    }
                    FacetParser facetParser = this.facetParsers.processor(fieldName);
                    if (facetParser == null) {
                        throw new SearchParseException(context, "No facet type found for [" + fieldName + "]");
                    }
                    facetExecutor = facetParser.parse(facetName, parser, context);
                    defaultMainMode = facetParser.defaultMainMode();
                    defaultGlobalMode = facetParser.defaultGlobalMode();
                    continue;
                }
                if (!token.isValue()) continue;
                if ("global".equals(fieldName)) {
                    global = parser.booleanValue();
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    String modeAsText = parser.text();
                    if ("collector".equals(modeAsText)) {
                        mode = FacetExecutor.Mode.COLLECTOR;
                        continue;
                    }
                    if ("post".equals(modeAsText)) {
                        mode = FacetExecutor.Mode.POST;
                        continue;
                    }
                    throw new ElasticSearchIllegalArgumentException("failed to parse facet mode [" + modeAsText + "]");
                }
                if ("scope".equals(fieldName) || "_scope".equals(fieldName)) {
                    throw new SearchParseException(context, "the [scope] support in facets have been removed");
                }
                if ("cache_filter".equals(fieldName) || "cacheFilter".equals(fieldName)) {
                    cacheFilter = parser.booleanValue();
                    continue;
                }
                if (!"nested".equals(fieldName)) continue;
                nestedPath = parser.text();
            }
            if (filter != null && cacheFilter) {
                filter = context.filterCache().cache(filter);
            }
            if (facetExecutor == null) {
                throw new SearchParseException(context, "no facet type found for facet named [" + facetName + "]");
            }
            if (nestedPath != null) {
                facetExecutor = new NestedFacetExecutor(facetExecutor, context, nestedPath);
            }
            if (mode == null) {
                mode = global ? defaultGlobalMode : defaultMainMode;
            }
            entries.add(new SearchContextFacets.Entry(facetName, mode, facetExecutor, global, filter));
        }
        context.facets(new SearchContextFacets(entries));
    }
}

