/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.datehistogram;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.CacheRecycler;
import org.elasticsearch.common.joda.TimeZoneRounding;
import org.elasticsearch.common.trove.map.hash.TLongLongHashMap;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.LongValues;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.datehistogram.DateHistogramFacet;
import org.elasticsearch.search.facet.datehistogram.InternalCountDateHistogramFacet;

public class CountDateHistogramFacetExecutor
extends FacetExecutor {
    private final TimeZoneRounding tzRounding;
    private final IndexNumericFieldData indexFieldData;
    final DateHistogramFacet.ComparatorType comparatorType;
    final TLongLongHashMap counts;

    public CountDateHistogramFacetExecutor(IndexNumericFieldData indexFieldData, TimeZoneRounding tzRounding, DateHistogramFacet.ComparatorType comparatorType) {
        this.comparatorType = comparatorType;
        this.indexFieldData = indexFieldData;
        this.tzRounding = tzRounding;
        this.counts = CacheRecycler.popLongLongMap();
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalCountDateHistogramFacet(facetName, this.comparatorType, this.counts, true);
    }

    public static class DateHistogramProc
    extends LongFacetAggregatorBase {
        private final TLongLongHashMap counts;
        private final TimeZoneRounding tzRounding;

        public DateHistogramProc(TLongLongHashMap counts, TimeZoneRounding tzRounding) {
            this.counts = counts;
            this.tzRounding = tzRounding;
        }

        @Override
        public void onValue(int docId, long value) {
            this.counts.adjustOrPutValue(this.tzRounding.calc(value), 1L, 1L);
        }

        public TLongLongHashMap counts() {
            return this.counts;
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private LongValues values;
        private final DateHistogramProc histoProc;

        public Collector() {
            this.histoProc = new DateHistogramProc(CountDateHistogramFacetExecutor.this.counts, CountDateHistogramFacetExecutor.this.tzRounding);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)CountDateHistogramFacetExecutor.this.indexFieldData.load(context)).getLongValues();
        }

        public void collect(int doc) throws IOException {
            this.histoProc.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
        }
    }
}

