/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.HashedBytesArray;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.search.facet.Facet;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.filter.FilterFacet;

public class InternalFilterFacet
extends InternalFacet
implements FilterFacet {
    private static final BytesReference STREAM_TYPE = new HashedBytesArray("filter");
    static InternalFacet.Stream STREAM = new InternalFacet.Stream(){

        @Override
        public Facet readFacet(StreamInput in) throws IOException {
            return InternalFilterFacet.readFilterFacet(in);
        }
    };
    private long count;

    public static void registerStreams() {
        InternalFacet.Streams.registerStream(STREAM, STREAM_TYPE);
    }

    @Override
    public BytesReference streamType() {
        return STREAM_TYPE;
    }

    InternalFilterFacet() {
    }

    public InternalFilterFacet(String name, long count) {
        super(name);
        this.count = count;
    }

    @Override
    public String getType() {
        return "filter";
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Facet reduce(List<Facet> facets) {
        if (facets.size() == 1) {
            return facets.get(0);
        }
        int count = 0;
        for (Facet facet : facets) {
            count = (int)((long)count + ((FilterFacet)facet).getCount());
        }
        return new InternalFilterFacet(this.getName(), count);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        builder.field(Fields._TYPE, "filter");
        builder.field(Fields.COUNT, this.count);
        builder.endObject();
        return builder;
    }

    public static FilterFacet readFilterFacet(StreamInput in) throws IOException {
        InternalFilterFacet result = new InternalFilterFacet();
        result.readFrom(in);
        return result;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.count = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.count);
    }

    static final class Fields {
        static final XContentBuilderString _TYPE = new XContentBuilderString("_type");
        static final XContentBuilderString COUNT = new XContentBuilderString("count");

        Fields() {
        }
    }
}

