/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.geodistance;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.DoubleValues;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacet;
import org.elasticsearch.search.facet.geodistance.GeoDistanceFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class ValueGeoDistanceFacetExecutor
extends GeoDistanceFacetExecutor {
    private final IndexNumericFieldData valueIndexFieldData;

    public ValueGeoDistanceFacetExecutor(IndexGeoPointFieldData indexFieldData, double lat, double lon, DistanceUnit unit, GeoDistance geoDistance, GeoDistanceFacet.Entry[] entries, SearchContext context, IndexNumericFieldData valueIndexFieldData) {
        super(indexFieldData, lat, lon, unit, geoDistance, entries, context);
        this.valueIndexFieldData = valueIndexFieldData;
    }

    @Override
    public Collector collector() {
        return new Collector(new Aggregator(this.fixedSourceDistance, this.entries));
    }

    public static class Aggregator
    extends GeoDistanceFacetExecutor.Aggregator {
        DoubleValues valueValues;

        public Aggregator(GeoDistance.FixedSourceDistance fixedSourceDistance, GeoDistanceFacet.Entry[] entries) {
            super(fixedSourceDistance, entries);
        }

        @Override
        protected void collectGeoPoint(GeoDistanceFacet.Entry entry, int docId, double distance) {
            entry.foundInDoc = true;
            ++entry.count;
            DoubleValues.Iter iter = this.valueValues.getIter(docId);
            while (iter.hasNext()) {
                double value = iter.next();
                ++entry.totalCount;
                entry.total += value;
                if (value < entry.min) {
                    entry.min = value;
                }
                if (!(value > entry.max)) continue;
                entry.max = value;
            }
        }
    }

    class Collector
    extends GeoDistanceFacetExecutor.Collector {
        Collector(Aggregator aggregator) {
            super(aggregator);
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            ((Aggregator)this.aggregator).valueValues = ((AtomicNumericFieldData)ValueGeoDistanceFacetExecutor.this.valueIndexFieldData.load(context)).getDoubleValues();
        }
    }
}

